/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  Rubik.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Rubik */

#ifndef _XtRubik_h
#define _XtRubik_h

/***********************************************************************
 *
 * Rubik Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsizex ((char *) "sizex")
#define XtNsizey ((char *) "sizey")
#define XtNsizez ((char *) "sizez")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNcontrol ((char *) "control")
#define XtNfast ((char *) "fast")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCDelay ((char *) "Delay")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCSizeZ ((char *) "SizeZ")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCControl ((char *) "Control")
#define XtCFast ((char *) "Fast")

typedef struct _RubikClassRec *RubikWidgetClass;

extern WidgetClass rubikWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction;
	Boolean     control;
	int         fast;
} rubikCallbackStruct;
#endif

#define RUBIK_HIDE (-9)
#define RUBIK_PRACTICE_QUERY (-8)
#define RUBIK_RANDOMIZE_QUERY (-7)
#define RUBIK_SOLVE_MESSAGE (-6)
#define RUBIK_RESTORE (-5)
#define RUBIK_CLEAR (-4)
#define RUBIK_RESET (-3)
#define RUBIK_ILLEGAL (-2)
#define RUBIK_IGNORE (-1)
#define RUBIK_MOVED 0
#define RUBIK_SOLVED 2
#define RUBIK_PRACTICE 3
#define RUBIK_RANDOMIZE 4
#define RUBIK_ORIENT 5
#define RUBIK_COMPUTED 6
#define RUBIK_UNDO 7
#define RUBIK_DECX 8
#define RUBIK_DECY 9
#define RUBIK_DECZ 10
#define RUBIK_INCX 11
#define RUBIK_INCY 12
#define RUBIK_INCZ 13
#define RUBIK_DIM 14

#define MAXORIENT 4
#define MAXFACES 6
#define MINFACETS 1
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _RubikRec *RubikWidget;

#endif /* _XtRubik_h */
/* DON'T ADD STUFF AFTER THIS #endif */
