/*-
# X-BASED BARREL
#
#  BarrelP.h
#
###
#
#  Copyright (c) 1994 - 2008	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Barrel */

#ifndef _BarrelP_h
#define _BarrelP_h

#include "xwin.h"
#include "timer.h"
#include "Barrel.h"

#ifdef WINVER
extern void DestroyPuzzle(BarrelWidget w, HBRUSH brush);
extern void ResizePuzzle(BarrelWidget w);
extern void SizePuzzle(BarrelWidget w);
extern void InitializePuzzle(BarrelWidget w, HBRUSH brush);
extern void ExposePuzzle(BarrelWidget w);
extern void HidePuzzle(BarrelWidget w);
extern void SelectPuzzle(BarrelWidget w,
	const int x, const int y, const int shift);
extern void MotionPuzzle(BarrelWidget w,
	const int x, const int y, const int shift);
extern void ReleasePuzzle(BarrelWidget w,
	const int x, const int y, const int shift);
extern void PracticePuzzle(BarrelWidget w);
extern void RandomizePuzzle(BarrelWidget w);
extern void GetPuzzle(BarrelWidget w);
extern void WritePuzzle(BarrelWidget w);
extern void UndoPuzzle(BarrelWidget w);
extern void RedoPuzzle(BarrelWidget w);
extern void ClearPuzzle(BarrelWidget w);
extern void SolvePuzzle(BarrelWidget w);
extern void OrientizePuzzle(BarrelWidget w);
extern void PairsPuzzle(BarrelWidget w);
extern void SpeedPuzzle(BarrelWidget w);
extern void SlowPuzzle(BarrelWidget w);
extern void SoundPuzzle(BarrelWidget w);
extern void EnterPuzzle(BarrelWidget w);
extern void LeavePuzzle(BarrelWidget w);
extern void MovePuzzleInput(BarrelWidget w, int x, int direction, int shift);
extern int  MovePuzzleDir(BarrelWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _BarrelClassPart {
	int         ignore;
} BarrelClassPart;

typedef struct _BarrelClassRec {
	CoreClassPart coreClass;
	BarrelClassPart barrelClass;
} BarrelClassRec;

extern BarrelClassRec barrelClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif
#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4
#define MAX_COLORS (MAX_FACES+1)
#define PLUNGERS_NUMBER 3
#define FG_SHADES 3
#define MAX_SLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MoveRecord {
#if 0
	int direction, control;
#endif
	unsigned char packed;	/* This makes assumptions on the data. */
	int tile;		/* Do not make assumptions on this one. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _BarrelStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} BarrelStack;

typedef struct _BarrelPart {
	int        *tileOfPosition, spacePosition[PLUNGERS_NUMBER];
	int         currentTile, currentFace, currentRef;
	Boolean     started, cheat, sound, motion;
	Boolean     practice, orient, mono, reverse, pairs, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices, motionDiff, shiftDiff;
	int         base;
	int         tiles, faces, tileFaces;
	Point       offset, tileSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC[FG_SHADES];
	GC          faceGC[MAX_COLORS];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], moveSound[81];
	char        picture[81];
	char        faceChar[MAX_COLORS];
#else
	int         menu, graphicsFormat, pixmapSize;
	char       *userName, *scoreFile, *bumpSound, *moveSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	char       *faceName[MAX_COLORS];
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       faceColor[MAX_COLORS];
	XtCallbackList select;
#endif
} BarrelPart;

typedef struct _BarrelRec {
	CorePart    core;
	BarrelPart   barrel;
} BarrelRec;

extern int *startPosition;
extern void setPuzzle(BarrelWidget w, int reason);
extern Boolean MovePuzzle(BarrelWidget w,
	const int direction, const int tile, const int shift,
	const Boolean motion, const int speed);
extern void MovePuzzleDelay(BarrelWidget w,
	const int direction, const int tile, const Boolean all);

extern void SolveSomeTiles(BarrelWidget w);
extern void DrawAllTiles(const BarrelWidget w);
extern Boolean CheckSolved(const BarrelWidget w);
extern void newMoves(BarrelStack *s);
extern void deleteMoves(BarrelStack *s);
extern void setMove(BarrelStack *s, int direction, int tile, int control);
extern void getMove(BarrelStack *s, int *direction, int *tile, int *control);
extern int madeMoves(BarrelStack *s);
extern void flushMoves(BarrelWidget w, BarrelStack *s, Boolean undo);
extern int numMoves(BarrelStack *s);
extern void scanMoves(FILE *fp, BarrelWidget w, int moves);
extern void printMoves(FILE *fp, BarrelStack *s);
extern void scanStartPosition(FILE *fp, BarrelWidget w);
extern void printStartPosition(FILE *fp, BarrelWidget w);
extern void setStartPosition(BarrelWidget w);

#endif /* _BarrelP_h */
