/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * ixcolor.c
 *
 * Xǥ顼͡Ȥʴؿ 
 *
 */

#include"ixcolor.h"

/****************************************/
/* iNametoPixel                         */
/* 顼͡फԥͤ */
/* ԥ֤ͤ                     */
/****************************************/
unsigned long iNametoPixel( Display *d, Colormap cmap, char color[] )
{
    XColor c0, c1;
    XAllocNamedColor( d, cmap, color, &c1, &c0 );
    return (c1.pixel);
}


/*********************************/
/* iRGBtoPixel                   */
/* RGBͤԥͤ */
/*                               */
/*********************************/
unsigned long iRGBtoPixel( Display *d, Colormap cmap, int r, int g, int b )
{
    XColor c0;

    c0.red = r;
    c0.green = g;
    c0.blue = b;
    XAllocColor( d, cmap, &c0 );
    return (c0.pixel);
}


/*********************************/
/* iPixeltoRGB                   */
/* ԥͤRGBͤ */
/*********************************/
void iPixeltoRGB( Display *d, Colormap cmap,
		  unsigned long pixel, int *r, int *g, int *b )
{
    XColor c0;

    c0.pixel = pixel;
    XQueryColor( d, cmap, &c0 );

    *r = (int)c0.red;
    *g = (int)c0.green;
    *b = (int)c0.blue;

    return;
}


unsigned long iGetColorPixelRate(  Display *d, Colormap cmap,
				   unsigned long pixel, int rate, int flag )
{
    int r, g, b;
    char tmp[32];

    iPixeltoRGB( d, cmap, pixel, &r, &g, &b );
    r /= 256;
    g /= 256;
    b /= 256;

    if( flag ){
	r = iMin( 255, (r+((255-r)*rate/100)) ); 
	g = iMin( 255, (g+((255-g)*rate/100)) ); 
	b = iMin( 255, (b+((255-b)*rate/100)) ); 
    } else {
	r = iMin( (r*rate/100), 255 );
	g = iMin( (g*rate/100), 255 );
	b = iMin( (b*rate/100), 255 );
    }
    sprintf( tmp, "#%02x%02x%02x", r, g, b );
    return iNametoPixel( d, cmap, tmp );
}
