/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * mailbox.c
 *
 * ᡼ؿ Mailbox
 *
 */

#include"mail.h"


/* Mailbox ζڤ */
char *BWD = "From ";


/*********************************************************/
/* GetMailInfoMailbox                                    */
/* ᡼ե뤫'From''Subject''Date'ɤ߹ */
/* ᡼뤬Ƥ 2                                */
/* ᡼뤬äƤ 1                                */
/* 󤫤Ѳ̵ 0                              */
/* ̵Ǥ륨顼 -1                                 */
/* ƻԤ׵᤹ -2                             */
/* ̿Ūʥ顼 -3 ֤                            */
/*********************************************************/
int GetMailInfoMailbox(MailInfo **mlist, int *mlist_n,
		       MailInfo **nlist, int *nlist_n,
		       BOOL force)
{
    int j, flag;
    char temp[2048];
    int ret;
    int mailn;
    static int old_mailn = 0;
    static time_t lasttime = 0;
    time_t newesttime = lasttime;

    FILE *fp;
    char from_tmp[2048], subj_tmp[2048], date_tmp[2048], to_tmp[2048];

    struct stat stbuf;
    static time_t boxtime = 0;
    int code = CODE_JIS;

#ifdef DEBUG
    fprintf( stderr, "GetMailInfoMailbox.\n" );
#endif

    /* եιĴ٤ */
    stat( opinfo.mailbox, &stbuf );

    while( NULL == (fp = fopen( opinfo.mailbox, "r" )) ){

	return -1;
/*
        sleep(3);
        if( ++err_cnt == 10 ){
            fprintf( stderr, "Can't open file: %s\n", opinfo.mailbox );
            return -1;
        }
*/
    }

    /* Count mails */
    mailn = 0;
    while( NULL != fgets( temp, 2048, fp ) ){
	if( 0 == strncmp( temp, BWD, strlen(BWD) ) ){
	    ++mailn;
	}
    }

    *mlist_n = mailn;

    /*
     * ᡼ξ֤ѲƤʤнλ
     */
    if( force==FALSE && mailn == old_mailn && stbuf.st_mtime == boxtime ){
	fclose( fp );
	return 0;
    }

    /* ᡼,¤Τݤ */
    if( (*mlist) != NULL ){
	free( *mlist ); *mlist = NULL;
idbgout(__func__,"Memory free mlist");
    }

    if( mailn > 0 ){
	if( NULL == (*mlist = (MailInfo*)malloc(mailn*sizeof(MailInfo))) ){
	    fprintf( stderr, "GetMailInfoMailbox():: malloc: Memory over!"
		     " (%dmails %dbyte)\n",mailn,mailn*sizeof(MailInfo) );
	    fclose( fp );
	    return -3;
	}
idbgout(__func__,"Memory alloc mlist (%dmails)",mailn);
    }

    /* ֤Ƭ᤹ */
    rewind( fp );

    /* 󹹿 */
    boxtime = stbuf.st_mtime;
    *nlist_n = 0;


    /* Read From,Subject and Date */
    for( j=0 ; j<mailn ; j++ ){

        /* BWD ޤɤФ */
	do{
	    if( NULL == fgets( temp, 2048, fp ) ){
		fclose(fp); free(*mlist); *mlist=NULL;
idbgout(__func__,"Memory free mlist");
		return -1;
	    }
	} while( 0!=strncmp( temp, BWD, strlen(BWD) ) );

	/* Read From,Subject and Date */
	flag=GetMailText( 0, fp, from_tmp, subj_tmp, date_tmp, to_tmp );

	/* Decode to JIS from MIME */
	mimdecode( from_tmp, from_tmp, &code );
	changecodetojis(from_tmp,(*mlist)[j].from,XQB_TEXT_LEN,code); 

	mimdecode( subj_tmp, subj_tmp, &code );
	changecodetojis(subj_tmp,(*mlist)[j].subject,XQB_TEXT_LEN,code); 

	mimdecode( to_tmp, to_tmp, &code );
	changecodetojis(to_tmp,(*mlist)[j].to,XQB_TEXT_LEN,code); 

	strncpy( (*mlist)[j].date, date_tmp, XQB_DATE_LEN );

	(*mlist)[j].ColorID = 0;
	(*mlist)[j].time = DateToTime( date_tmp );


	/* If need newest data then ... */
	if( lasttime < (*mlist)[j].time ){
	    if( NULL == ((*nlist) =
			 (MailInfo*)realloc((*nlist),
					    ((*nlist_n)+1)*sizeof(MailInfo))) ){
		fprintf( stderr, "GetMailInfoMailbox():: "
			 "realloc: Memory over! (%dmails)\n", (*nlist_n)+1 );
		fclose( fp );
		return -3;
	    }
if(*nlist_n==0)idbgout(__func__,"Memory realloc nlist.");

	    (*nlist)[*nlist_n] = (*mlist)[j];
	    newesttime = iMax( newesttime, (*mlist)[j].time );
	    (*nlist_n)++;
	    ret = 2;
	}

    }

    fclose( fp );

    old_mailn = mailn;
    lasttime = newesttime;

#ifdef DEBUG
    fprintf( stderr, "GetMailInfoMailbox...Ok.\n" );
#endif

    return ret;
}


