/*
 * Copyright(c) 2019-2020 Xilinx, Inc. All rights reserved.
 */

#include "qdma_access_common.h"
#include "eqdma_soft_access.h"
#include "qdma_soft_reg.h"
#include "eqdma_soft_reg.h"
#include "qdma_platform.h"
#include "qdma_reg_dump.h"

#ifdef ENABLE_WPP_TRACING
#include "eqdma_soft_access.tmh"
#endif

/** EQDMA Context array size */
#define EQDMA_SW_CONTEXT_NUM_WORDS           8
#define EQDMA_HW_CONTEXT_NUM_WORDS           2
#define EQDMA_PFETCH_CONTEXT_NUM_WORDS       2
#define EQDMA_CR_CONTEXT_NUM_WORDS           1
#define EQDMA_CMPT_CONTEXT_NUM_WORDS         6
#define EQDMA_IND_INTR_CONTEXT_NUM_WORDS     4

#define EQDMA_VF_USER_BAR_ID                 2

#define EQDMA_REG_GROUP_1_START_ADDR	0x000
#define EQDMA_REG_GROUP_2_START_ADDR	0x400
#define EQDMA_REG_GROUP_3_START_ADDR	0xB00
#define EQDMA_REG_GROUP_4_START_ADDR	0x5014

static struct eqdma_hw_err_info eqdma_err_info[EQDMA_ERRS_ALL] = {
	/* Descriptor errors */
	{
		EQDMA_DSC_ERR_POISON,
		"Poison error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_POISON_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_UR_CA,
		"Unsupported request or completer aborted error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_UR_CA_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_BCNT,
		"Unexpected Byte count in completion error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_BCNT_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_PARAM,
		"Parameter mismatch error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_PARAM_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_ADDR,
		"Address mismatch error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_ADDR_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_TAG,
		"Unexpected tag error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_TAG_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_FLR,
		"FLR error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_FLR_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_TIMEOUT,
		"Timed out error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_TIMEOUT_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_DAT_POISON,
		"Poison data error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_DAT_POISON_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_FLR_CANCEL,
		"Descriptor fetch cancelled due to FLR error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_FLR_CANCEL_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_DMA,
		"DMA engine error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_DMA_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_DSC,
		"Invalid PIDX update error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_DSC_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_RQ_CANCEL,
		"Descriptor fetch cancelled due to disable register status error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_RQ_CANCEL_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_DBE,
		"UNC_ERR_RAM_DBE error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_DBE_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_SBE,
		"UNC_ERR_RAM_SBE error",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_SBE_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},
	{
		EQDMA_DSC_ERR_ALL,
		"All Descriptor errors",
		EQDMA_OFFSET_GLBL_DSC_ERR_MASK,
		EQDMA_OFFSET_GLBL_DSC_ERR_STAT,
		EQDMA_GLBL_DSC_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_DSC_MASK
	},

	/* TRQ errors */
	{
		EQDMA_TRQ_ERR_CSR_UNMAPPED,
		"Access targeted unmapped register space via CSR pathway error",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_CSR_UNMAPPED_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_VF_ACCESS,
		"VF attempted to access Global register space or Function map",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_VF_ACCESS_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_TCP_CSR_TIMEOUT,
		"Timeout on request to dma internal csr register",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_TCP_CSR_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_QSPC_UNMAPPED,
		"Access targeted unmapped register via queue space pathway",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_QSPC_UNMAPPED_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_QID_RANGE,
		"Qid range error",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_QID_RANGE_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_TCP_QSPC_TIMEOUT,
		"Timeout on request to dma internal queue space register",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_TCP_QSPC_TIMEOUT_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},
	{
		EQDMA_TRQ_ERR_ALL,
		"All TRQ errors",
		EQDMA_OFFSET_GLBL_TRQ_ERR_MASK,
		EQDMA_OFFSET_GLBL_TRQ_ERR_STAT,
		EQDMA_GLBL_TRQ_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_TRQ_MASK
	},

	/* C2H Errors*/
	{
		EQDMA_ST_C2H_ERR_MTY_MISMATCH,
		"MTY mismatch error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_MTY_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_LEN_MISMATCH,
		"Packet length mismatch error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_LEN_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_SH_CMPT_DSC,
		"A Shared CMPT queue has encountered a descriptor error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_SH_CMPT_DSC_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_QID_MISMATCH,
		"Qid mismatch error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_QID_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_DESC_RSP_ERR,
		"Descriptor error bit set",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_DESC_RSP_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_ENG_WPL_DATA_PAR_ERR,
		"Data parity error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_ENG_WPL_DATA_PAR_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_MSI_INT_FAIL,
		"MSI got a fail response error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_MSI_INT_FAIL_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_ERR_DESC_CNT,
		"Descriptor count error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_ERR_DESC_CNT_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_PORTID_CTXT_MISMATCH,
		"Port id in packet and pfetch ctxt mismatch error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_PORTID_CTXT_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_CMPT_INV_Q_ERR,
		"Writeback on invalid queue error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_CMPT_INV_Q_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_CMPT_QFULL_ERR,
		"Completion queue gets full error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_CMPT_QFULL_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_CMPT_CIDX_ERR,
		"Bad CIDX update by the software error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_CMPT_CIDX_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_CMPT_PRTY_ERR,
		"C2H completion Parity error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_CMPT_PRTY_ERR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_AVL_RING_DSC,
		"Available ring fetch returns descriptor with error",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_AVL_RING_DSC_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_HDR_ECC_UNC,
		"multi-bit ecc error on c2h packet header",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_HDR_ECC_UNC_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_HDR_ECC_COR,
		"single-bit ecc error on c2h packet header",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_HDR_ECC_COR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_C2H_ERR_ALL,
		"All C2h errors",
		EQDMA_OFFSET_C2H_ERR_MASK,
		EQDMA_OFFSET_C2H_ERR_STAT,
		EQDMA_C2H_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},

	/* C2H fatal errors */
	{
		EQDMA_ST_FATAL_ERR_MTY_MISMATCH,
		"Fatal MTY mismatch error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_MTY_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_LEN_MISMATCH,
		"Fatal Len mismatch error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_LEN_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_QID_MISMATCH,
		"Fatal Qid mismatch error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_QID_MISMATCH_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_TIMER_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_TIMER_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_PFCH_II_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_PFCH_II_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_CMPT_CTXT_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_CMPT_CTXT_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_PFCH_CTXT_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_PFCH_CTXT_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_DESC_REQ_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_DESC_REQ_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_INT_CTXT_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_INT_CTXT_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_CMPT_COAL_DATA_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_CMPT_COAL_DATA_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_CMPT_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_CMPT_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_QID_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_QID_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_PAYLOAD_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_PAYLOAD_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_WPL_DATA_PAR,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_WPL_DATA_PAR_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_AVL_RING_FIFO_RAM_RDBE,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_AVL_RING_FIFO_RAM_RDBE_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_HDR_ECC_UNC,
		"RAM double bit fatal error",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_HDR_ECC_UNC_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},
	{
		EQDMA_ST_FATAL_ERR_ALL,
		"All fatal errors",
		EQDMA_OFFSET_C2H_FATAL_ERR_MASK,
		EQDMA_OFFSET_C2H_FATAL_ERR_STAT,
		EQDMA_C2H_FATAL_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_ST_C2H_MASK
	},

	/* H2C St errors */
	{
		EQDMA_ST_H2C_ERR_ZERO_LEN_DESC,
		"Zero length descriptor error",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_ZERO_LEN_DESC_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_SDI_MRKR_REQ_MOP,
		"A non-EOP descriptor received",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_SDI_MRKR_REQ_MOP_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_NO_DMA_DSC,
		"No DMA descriptor received error",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_NO_DMA_DSC_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_SBE,
		"Single bit error detected on H2C-ST data error",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_SBE_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_DBE,
		"Double bit error detected on H2C-ST data error",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_DBE_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_PAR,
		"Internal data parity error",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_PAR_ERR_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},
	{
		EQDMA_ST_H2C_ERR_ALL,
		"All H2C errors",
		EQDMA_OFFSET_H2C_ERR_MASK,
		EQDMA_OFFSET_H2C_ERR_STAT,
		EQDMA_H2C_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_ST_H2C_MASK
	},

	/* SBE errors */
	{
		EQDMA_SBE_ERR_MI_H2C0_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_H2C0_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_H2C1_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_H2C1_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_H2C2_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_H2C2_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_H2C3_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_H2C3_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_C2H0_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_C2H0_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_C2H1_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_C2H1_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_C2H2_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_C2H2_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_C2H3_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_C2H3_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_H2C_RD_BRG_DAT,
		"Bridge master read single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_H2C_RD_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_H2C_WR_BRG_DAT,
		"Bridge master write single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_H2C_WR_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_C2H_RD_BRG_DAT,
		"Bridge slave read data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_C2H_RD_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_C2H_WR_BRG_DAT,
		"Bridge slave write data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_C2H_WR_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_FUNC_MAP,
		"Function map RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_FUNC_MAP_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DSC_HW_CTXT,
		"Descriptor engine hardware context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DSC_HW_CTXT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DSC_CRD_RCV,
		"Descriptor engine receive credit context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DSC_CRD_RCV_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DSC_SW_CTXT,
		"Descriptor engine software context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DSC_SW_CTXT_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DSC_CPLI,
		"Descriptor engine fetch completion information RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DSC_CPLI_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DSC_CPLD,
		"Descriptor engine fetch completion data RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DSC_CPLD_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_MI_TL_SLV_FIFO_RAM,
		"TL Slavle FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_MI_TL_SLV_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_TIMER_FIFO_RAM,
		"Timer fifo RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_TIMER_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_QID_FIFO_RAM,
		"C2H ST QID FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_QID_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_WRB_COAL_DATA_RAM,
		"Writeback Coalescing RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_WRB_COAL_DATA_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_INT_CTXT_RAM,
		"Interrupt context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_INT_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_DESC_REQ_FIFO_RAM,
		"C2H ST descriptor request RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_DESC_REQ_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_PFCH_CTXT_RAM,
		"C2H ST prefetch RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_PFCH_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_WRB_CTXT_RAM,
		"C2H ST completion context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_WRB_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_PFCH_LL_RAM,
		"C2H ST prefetch list RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_PFCH_LL_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_PEND_FIFO_RAM,
		"Pend FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_PEND_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_RC_RRQ_ODD_RAM,
		"RC RRQ Odd RAM single bit ECC error.",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_RC_RRQ_ODD_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},
	{
		EQDMA_SBE_ERR_ALL,
		"All SBE errors",
		EQDMA_OFFSET_RAM_SBE_MASK,
		EQDMA_OFFSET_RAM_SBE_STAT,
		EQDMA_SBE_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_RAM_SBE_MASK
	},


	/* DBE errors */
	{
		EQDMA_DBE_ERR_MI_H2C0_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_H2C0_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_H2C1_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_H2C1_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_H2C2_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_H2C2_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_H2C3_DAT,
		"H2C MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_H2C3_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_C2H0_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_C2H0_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_C2H1_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_C2H1_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_C2H2_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_C2H2_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_C2H3_DAT,
		"C2H MM data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_C2H3_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_H2C_RD_BRG_DAT,
		"Bridge master read single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_H2C_RD_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_H2C_WR_BRG_DAT,
		"Bridge master write single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_H2C_WR_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_C2H_RD_BRG_DAT,
		"Bridge slave read data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_C2H_RD_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_C2H_WR_BRG_DAT,
		"Bridge slave write data buffer single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_C2H_WR_BRG_DAT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_FUNC_MAP,
		"Function map RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_FUNC_MAP_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DSC_HW_CTXT,
		"Descriptor engine hardware context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DSC_HW_CTXT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DSC_CRD_RCV,
		"Descriptor engine receive credit context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DSC_CRD_RCV_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DSC_SW_CTXT,
		"Descriptor engine software context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DSC_SW_CTXT_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DSC_CPLI,
		"Descriptor engine fetch completion information RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DSC_CPLI_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DSC_CPLD,
		"Descriptor engine fetch completion data RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DSC_CPLD_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_MI_TL_SLV_FIFO_RAM,
		"TL Slavle FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_MI_TL_SLV_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_TIMER_FIFO_RAM,
		"Timer fifo RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_TIMER_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_QID_FIFO_RAM,
		"C2H ST QID FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_QID_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_WRB_COAL_DATA_RAM,
		"Writeback Coalescing RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_WRB_COAL_DATA_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_INT_CTXT_RAM,
		"Interrupt context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_INT_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_DESC_REQ_FIFO_RAM,
		"C2H ST descriptor request RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_DESC_REQ_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_PFCH_CTXT_RAM,
		"C2H ST prefetch RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_PFCH_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_WRB_CTXT_RAM,
		"C2H ST completion context RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_WRB_CTXT_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_PFCH_LL_RAM,
		"C2H ST prefetch list RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_PFCH_LL_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_PEND_FIFO_RAM,
		"Pend FIFO RAM single bit ECC error",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_PEND_FIFO_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_RC_RRQ_ODD_RAM,
		"RC RRQ Odd RAM single bit ECC error.",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_RC_RRQ_ODD_RAM_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	},
	{
		EQDMA_DBE_ERR_ALL,
		"All DBE errors",
		EQDMA_OFFSET_RAM_DBE_MASK,
		EQDMA_OFFSET_RAM_DBE_STAT,
		EQDMA_DBE_ERR_ALL_MASK,
		EQDMA_GLBL_ERR_RAM_DBE_MASK
	}
};

static int32_t all_eqdma_hw_errs[EQDMA_TOTAL_LEAF_ERROR_AGGREGATORS] = {

	EQDMA_DSC_ERR_ALL,
	EQDMA_TRQ_ERR_ALL,
	EQDMA_ST_C2H_ERR_ALL,
	EQDMA_ST_FATAL_ERR_ALL,
	EQDMA_ST_H2C_ERR_ALL,
	EQDMA_SBE_1_ERR_ALL,
	EQDMA_SBE_ERR_ALL,
	EQDMA_DBE_1_ERR_ALL,
	EQDMA_DBE_ERR_ALL
};

static struct xreg_info eqdma_config_regs[] = {

	/* QDMA_TRQ_SEL_GLBL1 (0x00000) */
	{"CFG_BLOCK_ID",
		0x00, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_BUSDEV",
		0x04, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_PCIE_MAX_PL_SZ",
		0x08, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_PCIE_MAX_RDRQ_SZ",
		0x0C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_SYS_ID",
		0x10, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_MSI_EN",
		0x14, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_PCIE_DATA_WIDTH",
		0x18, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_PCIE_CTRL",
		0x1C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_AXI_USR_MAX_PL_SZ",
		0x40, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_AXI_USR_MAX_RDRQ_SZ",
		0x44, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_MISC_CTRL",
		0x4C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_SCRATCH_REG",
		0x80, 8, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"CFG_GIC",
		0xA0, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_SBE_MSK_1_A",
		0xE0, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_SBE_STS_1_A",
		0xE4, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_DBE_MSK_1_A",
		0xE8, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_DBE_STS_1_A",
		0xEC, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},

	{"RAM_SBE_MSK_A",
		0xF0, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_SBE_STS_A",
		0xF4, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_DBE_MSK_A",
		0xF8, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"RAM_DBE_STS_A",
		0xFC, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_GLBL2 (0x00100) */
	{"GLBL2_ID",
		0x100, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_PF_BL_INT",
		0x104, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_PF_VF_BL_INT",
		0x108, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_PF_BL_EXT",
		0x10C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_PF_VF_BL_EXT",
		0x110, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_CHNL_INST",
		0x114, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_CHNL_QDMA",
		0x118, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_CHNL_STRM",
		0x11C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_QDMA_CAP",
		0x120, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_PASID_CAP",
		0x128, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_FUNC_RET",
		0x12C, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_SYS_ID",
		0x130, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_MISC_CAP",
		0x134, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_DBG_PCIE_RQ",
		0x1B8, 2, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_DBG_AXIMM_WR",
		0x1C0, 2, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"GLBL2_DBG_AXIMM_RD",
		0x1C8, 2, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_GLBL (0x00200) */
	{"GLBL_RNGSZ",
		0x204, 16, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_ERR_STAT",
		0x248, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_ERR_MASK",
		0x24C, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_CFG",
		0x250, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_ERR_STS",
		0x254, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_ERR_MSK",
		0x258, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_ERR_LOG",
		0x25C, 2,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_TRQ_ERR_STS",
		0x264, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_TRQ_ERR_MSK",
		0x268, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_TRQ_ERR_LOG",
		0x26C, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_DBG_DAT",
		0x270, 2,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_DBG_CTL",
		0x278, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_DSC_ERR_LOG2",
		0x27C, 1,  0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_VF},

	/* QDMA_TRQ_SEL_FMAP (0x00400 - 0x7FC) */
	/* TODO: max 256, display 4 for now */
	{"TRQ_SEL_FMAP",
		0x400, 4, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_IND (0x00800) */
	{"IND_CTXT_DATA",
		0x804, 8, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"IND_CTXT_MASK",
		0x824, 8, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"IND_CTXT_CMD",
		0x844, 1, 0, 0, 0, QDMA_MM_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_C2H (0x00A00) */
	{"C2H_TIMER_CNT",
	0xA00, 16, 0, 0, 0, QDMA_COMPLETION_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_CNT_THRESH",
	0xA40, 16, 0, 0, 0, QDMA_COMPLETION_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PFCH_CFG",
	0xA80, 2, 0, 0, 0, QDMA_COMPLETION_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_S_AXIS_C2H_ACCEPTED",
		0xA88, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_S_AXIS_CMPT_ACCEPTED",
		0xA8C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_DESC_RSP_PKT_ACCEPTED",
		0xA90, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_AXIS_PKG_CMP",
		0xA94, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_DESC_RSP_ACCEPTED",
		0xA98, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DESC_RSP_CMP",
		0xA9C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_WRQ_OUT",
		0xAA0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_WPL_REN_ACCEPTED",
		0xAA4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_TOTAL_WRQ_LEN",
		0xAA8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_TOTAL_WPL_LEN",
		0xAAC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_BUF_SZ",
		0xAB0, 16, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_ERR_STAT",
		0xAF0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_ERR_MASK",
		0xAF4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_FATAL_ERR_STAT",
		0xAF8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_FATAL_ERR_MASK",
		0xAFC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_FATAL_ERR_ENABLE",
		0xB00, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"GLBL_ERR_INT",
		0xB04, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_PFCH_CFG",
		0xB08, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INT_TIMER_TICK",
		0xB0C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DESC_RSP_DROP_ACCEPTED",
		0xB10, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_DESC_RSP_ERR_ACCEPTED",
		0xB14, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_STAT_DESC_REQ",
		0xB18, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DEBUG_DMA_ENG",
		0xB1C, 4, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DBG_PFCH_ERR_CTXT",
		0xB2C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_FIRST_ERR_QID",
		0xB30, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"STAT_NUM_CMPT_IN",
		0xB34, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_CMPT_OUT",
		0xB38, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_CMPT_DRP",
		0xB3C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_STAT_DESC_OUT",
		0xB40, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_DSC_CRDT_SENT",
		0xB44, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_FCH_DSC_RCVD",
		0xB48, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"STAT_NUM_BYP_DSC_RCVD",
		0xB4C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_CMPT_COAL_CFG",
		0xB50, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_H2C_REQ",
		0xB54, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_C2H_MM_REQ",
		0xB58, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_ERR_INT_REQ",
		0xB5C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_C2H_ST_REQ",
		0xB60, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_H2C_ERR_MM_MSIX_ACK",
		0xB64, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_H2C_ERR_MM_MSIX_FAIL",
		0xB68, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_H2C_ERR_MM_NO_MSIX",
		0xB6C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_H2C_ERR_MM_CTXT_INVAL",
		0xB70,
			1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_C2H_ST_MSIX_ACK",
		0xB74, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_C2H_ST_MSIX_FAIL",
		0xB78, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"C2H_INTR_C2H_ST_NO_MSIX",
		0xB7C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_C2H_ST_CTXT_INVAL",
		0xB80, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_WR_CMP",
		0xB84, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DEBUG_DMA_ENG_4",
		0xB88, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DEBUG_DMA_ENG_5",
		0xB8C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DBG_PFCH_QID",
		0xB90, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DBG_PFCH",
		0xB94, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INT_DEBUG",
		0xB98, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_IMM_ACCEPTED",
		0xB9C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_MARKER_ACCEPTED",
		0xBA0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_DISABLE_CMP_ACCEPTED",
		0xBA4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_C2H_PAYLOAD_FIFO_CRDT_CNT",
		0xBA8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_DYN_REQ",
		0xBAC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_INTR_DYN_MISC",
		0xBB0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DROP_LEN_MISMATCH",
		0xBB4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DROP_DESC_RSP_LEN",
		0xBB8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DROP_QID_FIFO_LEN",
		0xBBC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DROP_PAYLOAD_CNT",
		0xBC0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"QDMA_C2H_CMPT_FORMAT",
		0xBC4, 7, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PFCH_CACHE_DEPTH",
		0xBE0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_CMPT_COAL_BUF_DEPTH",
		0xBE4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PFCH_CRDT",
		0xBE8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_HAS_CMPT_ACCEPTED",
		0xBEC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_STAT_HAS_PLD_ACCEPTED",
		0xBF0, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PLD_PKT_ID",
		0xBF4, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PLD_PKT_ID_1",
		0xBF8, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_DROP_PAYLOAD_CNT_1",
		0xBFC, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_H2C(0x00E00) Register Space*/
	{"H2C_ERR_STAT",
		0xE00, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"H2C_ERR_MASK",
		0xE04, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"H2C_FIRST_ERR_QID",
		0xE08, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"H2C_DBG_REG",
		0xE0C, 5, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_FATAL_ERR_EN",
		0xE20, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_VF},
	{"H2C_REQ_THROT_PCIE",
		0xE24, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_ALN_DBG_REG0",
		0xE28, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_REQ_THROT_AXIMM",
		0xE2C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_C2H_MM (0x1000) */
	{"C2H_MM_CONTROL",
		0x1004, 3, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_STATUS",
		0x1040, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_CMPL_DSC_CNT",
		0x1048, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_ERR_CODE_EN_MASK",
		0x1054, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_ERR_CODE",
		0x1058, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_ERR_INFO",
		0x105C, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_PERF_MON_CTRL",
		0x10C0, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_PERF_MON_CY_CNT",
		0x10C4, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_PERF_MON_DATA_CNT",
		0x10CC, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_MM_DBG_INFO",
		0x10E8, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_SEL_H2C_MM (0x1200)*/
	{"H2C_MM_CONTROL",
		0x1204, 3, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_STATUS",
		0x1240, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_CMPL_DSC_CNT",
		0x1248, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_ERR_CODE_EN_MASK",
		0x1254, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_ERR_CODE",
		0x1258, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_ERR_INFO",
		0x125C, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_PERF_MON_CTRL",
		0x12C0, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_PERF_MON_CY_CNT",
		0x12C4, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_PERF_MON_DATA_CNT",
		0x12CC, 2, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},
	{"H2C_MM_DBG_INFO",
		0x12E8, 1, 0, 0, 0, QDMA_MM_MODE, QDMA_REG_READ_PF_ONLY},

	{"C2H_CRDT_COAL_CFG",
		0x1400, 2, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PFCH_BYP_QID",
		0x1408, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_PFCH_BYP_TAG",
		0x140C, 1, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},
	{"C2H_WATER_MARK",
		0x1500, 16, 0, 0, 0, QDMA_ST_MODE, QDMA_REG_READ_PF_ONLY},

	/* QDMA_PF_MAILBOX (0x2400) */
	{"FUNC_STATUS",
		0x22400, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"FUNC_CMD",
		 0x22404, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"FUNC_INTR_VEC",
		 0x22408, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"TARGET_FUNC",
		 0x2240C, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"INTR_CTRL",
		 0x22410, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"PF_ACK",
		 0x22420, 8, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"FLR_CTRL_STATUS",
		 0x22500, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"MSG_IN",
		 0x22C00, 32, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},
	{"MSG_OUT",
		 0x23000, 32, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},

	/* QDMA_TRQ_MSIX */
	{"TRQ_MSIX",
		 0x30000, 1, 0, 0, 0, QDMA_MAILBOX, QDMA_REG_READ_PF_ONLY},

	{"", 0, 0, 0, 0, 0, 0, 0}
};


static struct qctx_entry eqdma_sw_ctxt_entries[] = {
	{"PIDX", 0},
	{"IRQ Arm", 0},
	{"Function Id", 0},
	{"Queue Enable", 0},
	{"Fetch Credit Enable", 0},
	{"Write back/Intr Check", 0},
	{"Write back/Intr Interval", 0},
	{"Address Translation", 0},
	{"Fetch Max", 0},
	{"Ring Size", 0},
	{"Descriptor Size", 0},
	{"Bypass Enable", 0},
	{"MM Channel", 0},
	{"Writeback Enable", 0},
	{"Interrupt Enable", 0},
	{"Port Id", 0},
	{"Interrupt No Last", 0},
	{"Error", 0},
	{"Writeback Error Sent", 0},
	{"IRQ Request", 0},
	{"Marker Disable", 0},
	{"Is Memory Mapped", 0},
	{"Descriptor Ring Base Addr (Low)", 0},
	{"Descriptor Ring Base Addr (High)", 0},
	{"Interrupt Vector/Ring Index", 0},
	{"Interrupt Aggregation", 0},
	{"Disable Interrupt with VF", 0},
	{"VirtIO Enable", 0},
	{"Pack descriptor output interface", 0},
	{"Irq Bypass", 0},
	{"Host ID", 0},
	{"Pasid", 0},
	{"Pasid Enable", 0},
	{"Virtio Base addr (Low)", 0},
	{"Virtio Base addr (High)", 0},
};

static struct qctx_entry eqdma_hw_ctxt_entries[] = {
	{"CIDX", 0},
	{"Credits Consumed", 0},
	{"Descriptors Pending", 0},
	{"Queue Invalid No Desc Pending", 0},
	{"Eviction Pending", 0},
	{"Fetch Pending", 0},
};

static struct qctx_entry eqdma_credit_ctxt_entries[] = {
	{"Credit", 0},
};

static struct qctx_entry eqdma_cmpt_ctxt_entries[] = {
	{"Enable Status Desc Update", 0},
	{"Enable Interrupt", 0},
	{"Trigger Mode", 0},
	{"Function Id", 0},
	{"Counter Index", 0},
	{"Timer Index", 0},
	{"Interrupt State", 0},
	{"Color", 0},
	{"Ring Size", 0},
	{"Base Address (Low)", 0},
	{"Base Address (High)", 0},
	{"Descriptor Size", 0},
	{"PIDX", 0},
	{"CIDX", 0},
	{"Valid", 0},
	{"Error", 0},
	{"Trigger Pending", 0},
	{"Timer Running", 0},
	{"Full Update", 0},
	{"Over Flow Check Disable", 0},
	{"Address Translation", 0},
	{"Interrupt Vector/Ring Index", 0},
	{"Interrupt Aggregation", 0},
	{"Disable Insterrupt with VF", 0},
	{"VIO", 0},
	{"c2h Direction", 0},
	{"Host ID", 0},
	{"Pasid", 0},
	{"Pasid Enable", 0},
	{"Base addr Low", 0},
	{"VirtIO End of Packet", 0},
	{"Shared Completion Queue", 0},
};

static struct qctx_entry eqdma_c2h_pftch_ctxt_entries[] = {
	{"Bypass", 0},
	{"Buffer Size Index", 0},
	{"Port Id", 0},
	{"Variable Descriptor", 0},
	{"Number of descriptors prefetched", 0},
	{"Error", 0},
	{"Prefetch Enable", 0},
	{"In Prefetch", 0},
	{"Software Credit", 0},
	{"Valid", 0},
};

static struct qctx_entry eqdma_ind_intr_ctxt_entries[] = {
	{"valid", 0},
	{"vec", 0},
	{"int_st", 0},
	{"color", 0},
	{"baddr_4k (Low)", 0},
	{"baddr_4k (High)", 0},
	{"page_size", 0},
	{"pidx", 0},
	{"at", 0},
	{"Host ID", 0},
	{"Pasid", 0},
	{"Pasid Enable", 0},
	{"Function Id", 0},
};

static int eqdma_indirect_reg_invalidate(void *dev_hndl,
		enum ind_ctxt_cmd_sel sel, uint16_t hw_qid);
static int eqdma_indirect_reg_clear(void *dev_hndl,
		enum ind_ctxt_cmd_sel sel, uint16_t hw_qid);
static int eqdma_indirect_reg_read(void *dev_hndl, enum ind_ctxt_cmd_sel sel,
		uint16_t hw_qid, uint32_t cnt, uint32_t *data);
static int eqdma_indirect_reg_write(void *dev_hndl, enum ind_ctxt_cmd_sel sel,
		uint16_t hw_qid, uint32_t *data, uint16_t cnt);

uint32_t eqdma_reg_dump_buf_len(void)
{
	uint32_t length = ((sizeof(eqdma_config_regs) /
			sizeof(eqdma_config_regs[0])) + 1) *
			REG_DUMP_SIZE_PER_LINE;
	return length;
}

int eqdma_context_buf_len(uint8_t st,
		enum qdma_dev_q_type q_type, uint32_t *buflen)
{
	int len = 0;

	if (q_type == QDMA_DEV_Q_TYPE_CMPT) {
		len += (((sizeof(eqdma_cmpt_ctxt_entries) /
			sizeof(eqdma_cmpt_ctxt_entries[0])) + 1) *
			REG_DUMP_SIZE_PER_LINE);
	} else {
		len += (((sizeof(eqdma_sw_ctxt_entries) /
				sizeof(eqdma_sw_ctxt_entries[0])) + 1) *
				REG_DUMP_SIZE_PER_LINE);

		len += (((sizeof(eqdma_hw_ctxt_entries) /
			sizeof(eqdma_hw_ctxt_entries[0])) + 1) *
			REG_DUMP_SIZE_PER_LINE);

		len += (((sizeof(eqdma_credit_ctxt_entries) /
			sizeof(eqdma_credit_ctxt_entries[0])) + 1) *
			REG_DUMP_SIZE_PER_LINE);

		if (st && (q_type == QDMA_DEV_Q_TYPE_C2H)) {
			len += (((sizeof(eqdma_cmpt_ctxt_entries) /
				sizeof(eqdma_cmpt_ctxt_entries[0])) + 1) *
				REG_DUMP_SIZE_PER_LINE);

			len += (((sizeof(eqdma_c2h_pftch_ctxt_entries) /
				sizeof(eqdma_c2h_pftch_ctxt_entries[0])) + 1) *
				REG_DUMP_SIZE_PER_LINE);
		}
	}

	*buflen = len;
	return 0;
}

static uint32_t eqdma_intr_context_buf_len(void)
{
	uint32_t len = 0;

	len += (((sizeof(eqdma_ind_intr_ctxt_entries) /
			sizeof(eqdma_ind_intr_ctxt_entries[0])) + 1) *
			REG_DUMP_SIZE_PER_LINE);
	return len;
}

/*
 * eqdma_indirect_reg_invalidate() - helper function to invalidate indirect
 *					context registers.
 *
 * return -QDMA_ERR_HWACC_BUSY_TIMEOUT if register
 *	value didn't match, QDMA_SUCCESS other wise
 */
static int eqdma_indirect_reg_invalidate(void *dev_hndl,
		enum ind_ctxt_cmd_sel sel, uint16_t hw_qid)
{
	union qdma_ind_ctxt_cmd cmd;

	qdma_reg_access_lock(dev_hndl);

	/* set command register */
	cmd.word = 0;
	cmd.bits.qid = hw_qid;
	cmd.bits.op = QDMA_CTXT_CMD_INV;
	cmd.bits.sel = sel;
	qdma_reg_write(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD, cmd.word);

	/* check if the operation went through well */
	if (qdma4_hw_monitor_reg(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD,
			QDMA_IND_CTXT_CMD_BUSY_MASK, 0,
			QDMA_REG_POLL_DFLT_INTERVAL_US,
			QDMA_REG_POLL_DFLT_TIMEOUT_US)) {
		qdma_reg_access_release(dev_hndl);
		qdma_log_error("%s: hw_monitor_reg failed with err:%d\n",
						__func__,
					   -QDMA_ERR_HWACC_BUSY_TIMEOUT);
		return -QDMA_ERR_HWACC_BUSY_TIMEOUT;
	}

	qdma_reg_access_release(dev_hndl);

	return QDMA_SUCCESS;
}

/*
 * eqdma_indirect_reg_clear() - helper function to clear indirect
 *				context registers.
 *
 * return -QDMA_ERR_HWACC_BUSY_TIMEOUT if register
 *	value didn't match, QDMA_SUCCESS other wise
 */
static int eqdma_indirect_reg_clear(void *dev_hndl,
		enum ind_ctxt_cmd_sel sel, uint16_t hw_qid)
{
	union qdma_ind_ctxt_cmd cmd;

	qdma_reg_access_lock(dev_hndl);

	/* set command register */
	cmd.word = 0;
	cmd.bits.qid = hw_qid;
	cmd.bits.op = QDMA_CTXT_CMD_CLR;
	cmd.bits.sel = sel;
	qdma_reg_write(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD, cmd.word);

	/* check if the operation went through well */
	if (qdma4_hw_monitor_reg(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD,
			QDMA_IND_CTXT_CMD_BUSY_MASK, 0,
			QDMA_REG_POLL_DFLT_INTERVAL_US,
			QDMA_REG_POLL_DFLT_TIMEOUT_US)) {
		qdma_reg_access_release(dev_hndl);
		qdma_log_error("%s: hw_monitor_reg failed with err:%d\n",
						__func__,
					   -QDMA_ERR_HWACC_BUSY_TIMEOUT);
		return -QDMA_ERR_HWACC_BUSY_TIMEOUT;
	}

	qdma_reg_access_release(dev_hndl);

	return QDMA_SUCCESS;
}

/*
 * eqdma_indirect_reg_read() - helper function to read indirect
 *				context registers.
 *
 * return -QDMA_ERR_HWACC_BUSY_TIMEOUT if register
 *	value didn't match, QDMA_SUCCESS other wise
 */
static int eqdma_indirect_reg_read(void *dev_hndl, enum ind_ctxt_cmd_sel sel,
		uint16_t hw_qid, uint32_t cnt, uint32_t *data)
{
	uint32_t index = 0, reg_addr = QDMA_OFFSET_IND_CTXT_DATA;
	union qdma_ind_ctxt_cmd cmd;

	qdma_reg_access_lock(dev_hndl);

	/* set command register */
	cmd.word = 0;
	cmd.bits.qid = hw_qid;
	cmd.bits.op = QDMA_CTXT_CMD_RD;
	cmd.bits.sel = sel;
	qdma_reg_write(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD, cmd.word);

	/* check if the operation went through well */
	if (qdma4_hw_monitor_reg(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD,
			QDMA_IND_CTXT_CMD_BUSY_MASK, 0,
			QDMA_REG_POLL_DFLT_INTERVAL_US,
			QDMA_REG_POLL_DFLT_TIMEOUT_US)) {
		qdma_reg_access_release(dev_hndl);
		qdma_log_error("%s: hw_monitor_reg failed with err:%d\n",
						__func__,
					   -QDMA_ERR_HWACC_BUSY_TIMEOUT);
		return -QDMA_ERR_HWACC_BUSY_TIMEOUT;
	}

	for (index = 0; index < cnt; index++, reg_addr += sizeof(uint32_t))
		data[index] = qdma_reg_read(dev_hndl, reg_addr);

	qdma_reg_access_release(dev_hndl);

	return QDMA_SUCCESS;
}

/*
 * eqdma_indirect_reg_write() - helper function to write indirect
 *				context registers.
 *
 * return -QDMA_ERR_HWACC_BUSY_TIMEOUT if register
 *	value didn't match, QDMA_SUCCESS other wise
 */
static int eqdma_indirect_reg_write(void *dev_hndl, enum ind_ctxt_cmd_sel sel,
		uint16_t hw_qid, uint32_t *data, uint16_t cnt)
{
	uint32_t index, reg_addr;
	struct qdma_indirect_ctxt_regs regs;
	uint32_t *wr_data = (uint32_t *)&regs;

	qdma_reg_access_lock(dev_hndl);

	/* write the context data */
	for (index = 0; index < QDMA_IND_CTXT_DATA_NUM_REGS; index++) {
		if (index < cnt)
			regs.qdma_ind_ctxt_data[index] = data[index];
		else
			regs.qdma_ind_ctxt_data[index] = 0;
		regs.qdma_ind_ctxt_mask[index] = 0xFFFFFFFF;
	}

	regs.cmd.word = 0;
	regs.cmd.bits.qid = hw_qid;
	regs.cmd.bits.op = QDMA_CTXT_CMD_WR;
	regs.cmd.bits.sel = sel;
	reg_addr = QDMA_OFFSET_IND_CTXT_DATA;

	for (index = 0; index < ((2 * QDMA_IND_CTXT_DATA_NUM_REGS) + 1);
			index++, reg_addr += sizeof(uint32_t))
		qdma_reg_write(dev_hndl, reg_addr, wr_data[index]);

	/* check if the operation went through well */
	if (qdma4_hw_monitor_reg(dev_hndl, QDMA_OFFSET_IND_CTXT_CMD,
			QDMA_IND_CTXT_CMD_BUSY_MASK, 0,
			QDMA_REG_POLL_DFLT_INTERVAL_US,
			QDMA_REG_POLL_DFLT_TIMEOUT_US)) {
		qdma_reg_access_release(dev_hndl);
		qdma_log_error("%s: hw_monitor_reg failed with err:%d\n",
						__func__,
					   -QDMA_ERR_HWACC_BUSY_TIMEOUT);
		return -QDMA_ERR_HWACC_BUSY_TIMEOUT;
	}

	qdma_reg_access_release(dev_hndl);

	return QDMA_SUCCESS;
}

/*
 * eqdma_fill_sw_ctxt() - Helper function to fill sw context into structure
 *
 */
static void eqdma_fill_sw_ctxt(struct qdma_descq_sw_ctxt *sw_ctxt)
{
	eqdma_sw_ctxt_entries[0].value = sw_ctxt->pidx;
	eqdma_sw_ctxt_entries[1].value = sw_ctxt->irq_arm;
	eqdma_sw_ctxt_entries[2].value = sw_ctxt->fnc_id;
	eqdma_sw_ctxt_entries[3].value = sw_ctxt->qen;
	eqdma_sw_ctxt_entries[4].value = sw_ctxt->frcd_en;
	eqdma_sw_ctxt_entries[5].value = sw_ctxt->wbi_chk;
	eqdma_sw_ctxt_entries[6].value = sw_ctxt->wbi_intvl_en;
	eqdma_sw_ctxt_entries[7].value = sw_ctxt->at;
	eqdma_sw_ctxt_entries[8].value = sw_ctxt->fetch_max;
	eqdma_sw_ctxt_entries[9].value = sw_ctxt->rngsz_idx;
	eqdma_sw_ctxt_entries[10].value = sw_ctxt->desc_sz;
	eqdma_sw_ctxt_entries[11].value = sw_ctxt->bypass;
	eqdma_sw_ctxt_entries[12].value = sw_ctxt->mm_chn;
	eqdma_sw_ctxt_entries[13].value = sw_ctxt->wbk_en;
	eqdma_sw_ctxt_entries[14].value = sw_ctxt->irq_en;
	eqdma_sw_ctxt_entries[15].value = sw_ctxt->port_id;
	eqdma_sw_ctxt_entries[16].value = sw_ctxt->irq_no_last;
	eqdma_sw_ctxt_entries[17].value = sw_ctxt->err;
	eqdma_sw_ctxt_entries[18].value = sw_ctxt->err_wb_sent;
	eqdma_sw_ctxt_entries[19].value = sw_ctxt->irq_req;
	eqdma_sw_ctxt_entries[20].value = sw_ctxt->mrkr_dis;
	eqdma_sw_ctxt_entries[21].value = sw_ctxt->is_mm;
	eqdma_sw_ctxt_entries[22].value = sw_ctxt->ring_bs_addr & 0xFFFFFFFF;
	eqdma_sw_ctxt_entries[23].value =
		(sw_ctxt->ring_bs_addr >> 32) & 0xFFFFFFFF;
	eqdma_sw_ctxt_entries[24].value = sw_ctxt->vec;
	eqdma_sw_ctxt_entries[25].value = sw_ctxt->intr_aggr;
	eqdma_sw_ctxt_entries[26].value = sw_ctxt->dis_intr_on_vf;
	eqdma_sw_ctxt_entries[27].value = sw_ctxt->virtio_en;
	eqdma_sw_ctxt_entries[28].value = sw_ctxt->pack_byp_out;
	eqdma_sw_ctxt_entries[29].value = sw_ctxt->irq_byp;
	eqdma_sw_ctxt_entries[30].value = sw_ctxt->host_id;
	eqdma_sw_ctxt_entries[31].value = sw_ctxt->pasid;
	eqdma_sw_ctxt_entries[32].value = sw_ctxt->pasid_en;
	eqdma_sw_ctxt_entries[33].value = sw_ctxt->virtio_dsc_base & 0xFFFFFFFF;
	eqdma_sw_ctxt_entries[34].value =
			(sw_ctxt->virtio_dsc_base >> 32) & 0xFFFFFFFF;
}

/*
 * eqdma_fill_cmpt_ctxt() - Helper function to fill completion context
 *                         into structure
 *
 */
static void eqdma_fill_cmpt_ctxt(struct qdma_descq_cmpt_ctxt *cmpt_ctxt)
{
	eqdma_cmpt_ctxt_entries[0].value = cmpt_ctxt->en_stat_desc;
	eqdma_cmpt_ctxt_entries[1].value = cmpt_ctxt->en_int;
	eqdma_cmpt_ctxt_entries[2].value = cmpt_ctxt->trig_mode;
	eqdma_cmpt_ctxt_entries[3].value = cmpt_ctxt->fnc_id;
	eqdma_cmpt_ctxt_entries[4].value = cmpt_ctxt->counter_idx;
	eqdma_cmpt_ctxt_entries[5].value = cmpt_ctxt->timer_idx;
	eqdma_cmpt_ctxt_entries[6].value = cmpt_ctxt->in_st;
	eqdma_cmpt_ctxt_entries[7].value = cmpt_ctxt->color;
	eqdma_cmpt_ctxt_entries[8].value = cmpt_ctxt->ringsz_idx;
	eqdma_cmpt_ctxt_entries[9].value = cmpt_ctxt->bs_addr & 0xFFFFFFFF;
	eqdma_cmpt_ctxt_entries[10].value =
		(cmpt_ctxt->bs_addr >> 32) & 0xFFFFFFFF;
	eqdma_cmpt_ctxt_entries[11].value = cmpt_ctxt->desc_sz;
	eqdma_cmpt_ctxt_entries[12].value = cmpt_ctxt->pidx;
	eqdma_cmpt_ctxt_entries[13].value = cmpt_ctxt->cidx;
	eqdma_cmpt_ctxt_entries[14].value = cmpt_ctxt->valid;
	eqdma_cmpt_ctxt_entries[15].value = cmpt_ctxt->err;
	eqdma_cmpt_ctxt_entries[16].value = cmpt_ctxt->user_trig_pend;
	eqdma_cmpt_ctxt_entries[17].value = cmpt_ctxt->timer_running;
	eqdma_cmpt_ctxt_entries[18].value = cmpt_ctxt->full_upd;
	eqdma_cmpt_ctxt_entries[19].value = cmpt_ctxt->ovf_chk_dis;
	eqdma_cmpt_ctxt_entries[20].value = cmpt_ctxt->at;
	eqdma_cmpt_ctxt_entries[21].value = cmpt_ctxt->vec;
	eqdma_cmpt_ctxt_entries[22].value = cmpt_ctxt->int_aggr;
	eqdma_cmpt_ctxt_entries[23].value = cmpt_ctxt->dis_intr_on_vf;
	eqdma_cmpt_ctxt_entries[24].value = cmpt_ctxt->vio;
	eqdma_cmpt_ctxt_entries[25].value = cmpt_ctxt->dir_c2h;
	eqdma_cmpt_ctxt_entries[26].value = cmpt_ctxt->host_id;
	eqdma_cmpt_ctxt_entries[27].value = cmpt_ctxt->pasid;
	eqdma_cmpt_ctxt_entries[28].value = cmpt_ctxt->pasid_en;
	eqdma_cmpt_ctxt_entries[29].value = cmpt_ctxt->base_addr;
	eqdma_cmpt_ctxt_entries[30].value = cmpt_ctxt->vio_eop;
	eqdma_cmpt_ctxt_entries[31].value = cmpt_ctxt->sh_cmpt;
}

/*
 * eqdma_fill_hw_ctxt() - Helper function to fill HW context into structure
 *
 */
static void eqdma_fill_hw_ctxt(struct qdma_descq_hw_ctxt *hw_ctxt)
{
	eqdma_hw_ctxt_entries[0].value = hw_ctxt->cidx;
	eqdma_hw_ctxt_entries[1].value = hw_ctxt->crd_use;
	eqdma_hw_ctxt_entries[2].value = hw_ctxt->dsc_pend;
	eqdma_hw_ctxt_entries[3].value = hw_ctxt->idl_stp_b;
	eqdma_hw_ctxt_entries[4].value = hw_ctxt->evt_pnd;
	eqdma_hw_ctxt_entries[5].value = hw_ctxt->fetch_pnd;
}

/*
 * eqdma_fill_credit_ctxt() - Helper function to fill Credit context
 *                           into structure
 *
 */
static void eqdma_fill_credit_ctxt(struct qdma_descq_credit_ctxt *cr_ctxt)
{
	eqdma_credit_ctxt_entries[0].value = cr_ctxt->credit;
}

/*
 * eqdma_fill_pfetch_ctxt() - Helper function to fill Prefetch context
 *                           into structure
 *
 */
static void eqdma_fill_pfetch_ctxt(struct qdma_descq_prefetch_ctxt
		*pfetch_ctxt)
{
	eqdma_c2h_pftch_ctxt_entries[0].value = pfetch_ctxt->bypass;
	eqdma_c2h_pftch_ctxt_entries[1].value = pfetch_ctxt->bufsz_idx;
	eqdma_c2h_pftch_ctxt_entries[2].value = pfetch_ctxt->port_id;
	eqdma_c2h_pftch_ctxt_entries[3].value = pfetch_ctxt->var_desc;
	eqdma_c2h_pftch_ctxt_entries[4].value = pfetch_ctxt->num_pftch;
	eqdma_c2h_pftch_ctxt_entries[5].value = pfetch_ctxt->err;
	eqdma_c2h_pftch_ctxt_entries[6].value = pfetch_ctxt->pfch_en;
	eqdma_c2h_pftch_ctxt_entries[7].value = pfetch_ctxt->pfch;
	eqdma_c2h_pftch_ctxt_entries[8].value = pfetch_ctxt->sw_crdt;
	eqdma_c2h_pftch_ctxt_entries[9].value = pfetch_ctxt->valid;
}

/*
 * eqdma_fill_intr_ctxt() - Helper function to fill interrupt context
 *                           into structure
 *
 */
static void eqdma_fill_intr_ctxt(struct qdma_indirect_intr_ctxt *intr_ctxt)
{
	eqdma_ind_intr_ctxt_entries[0].value = intr_ctxt->valid;
	eqdma_ind_intr_ctxt_entries[1].value = intr_ctxt->vec;
	eqdma_ind_intr_ctxt_entries[2].value = intr_ctxt->int_st;
	eqdma_ind_intr_ctxt_entries[3].value = intr_ctxt->color;
	eqdma_ind_intr_ctxt_entries[4].value =
			intr_ctxt->baddr_4k & 0xFFFFFFFF;
	eqdma_ind_intr_ctxt_entries[5].value =
			(intr_ctxt->baddr_4k >> 32) & 0xFFFFFFFF;
	eqdma_ind_intr_ctxt_entries[6].value = intr_ctxt->page_size;
	eqdma_ind_intr_ctxt_entries[7].value = intr_ctxt->pidx;
	eqdma_ind_intr_ctxt_entries[8].value = intr_ctxt->at;
	eqdma_ind_intr_ctxt_entries[9].value = intr_ctxt->host_id;
	eqdma_ind_intr_ctxt_entries[10].value = intr_ctxt->pasid;
	eqdma_ind_intr_ctxt_entries[11].value = intr_ctxt->pasid_en;
	eqdma_ind_intr_ctxt_entries[12].value = intr_ctxt->func_id;
}

/*****************************************************************************/
/**
 * eqdma_set_default_global_csr() - function to set the global CSR register to
 * default values. The value can be modified later by using the set/get csr
 * functions
 *
 * @dev_hndl:	device handle
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_set_default_global_csr(void *dev_hndl)
{
	/* Default values */
	uint32_t cfg_val = 0, reg_val = 0;
	uint32_t rng_sz[QDMA_NUM_RING_SIZES] = {2049, 65, 129, 193, 257, 385,
		513, 769, 1025, 1537, 3073, 4097, 6145, 8193, 12289, 16385};
	uint32_t tmr_cnt[QDMA_NUM_C2H_TIMERS] = {1, 2, 4, 5, 8, 10, 15, 20, 25,
		30, 50, 75, 100, 125, 150, 200};
	uint32_t cnt_th[QDMA_NUM_C2H_COUNTERS] = {2, 4, 8, 16, 24, 32, 48, 64,
		80, 96, 112, 128, 144, 160, 176, 192};
	uint32_t buf_sz[QDMA_NUM_C2H_BUFFER_SIZES] = {4096, 256, 512, 1024,
		2048, 3968, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 8192,
		9018, 16384};
	struct qdma_dev_attributes *dev_cap = NULL;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	qdma_get_device_attr(dev_hndl, &dev_cap);

	/* Configuring CSR registers */
	/* Global ring sizes */
	qdma_write_csr_values(dev_hndl, QDMA_OFFSET_GLBL_RNG_SZ, 0,
			QDMA_NUM_RING_SIZES, rng_sz);

	if (dev_cap->st_en || dev_cap->mm_cmpt_en) {
		/* Counter thresholds */
		qdma_write_csr_values(dev_hndl, QDMA_OFFSET_C2H_CNT_TH, 0,
				QDMA_NUM_C2H_COUNTERS, cnt_th);

		/* Timer Counters */
		qdma_write_csr_values(dev_hndl, QDMA_OFFSET_C2H_TIMER_CNT, 0,
				QDMA_NUM_C2H_TIMERS, tmr_cnt);


		/* Writeback Interval */
		reg_val =
			FIELD_SET(QDMA_GLBL_DSC_CFG_MAX_DSC_FETCH_MASK,
					DEFAULT_MAX_DSC_FETCH) |
			FIELD_SET(QDMA_GLBL_DSC_CFG_WB_ACC_INT_MASK,
					DEFAULT_WRB_INT);
		qdma_reg_write(dev_hndl, QDMA_OFFSET_GLBL_DSC_CFG, reg_val);
	}

	if (dev_cap->st_en) {
		/* Buffer Sizes */
		qdma_write_csr_values(dev_hndl, QDMA_OFFSET_C2H_BUF_SZ, 0,
				QDMA_NUM_C2H_BUFFER_SIZES, buf_sz);

		/* Prefetch Configuration */
		cfg_val = qdma_reg_read(dev_hndl,
				QDMA_OFFSET_C2H_PFETCH_CACHE_DEPTH);
		reg_val =
			FIELD_SET(QDMA_C2H_PFCH_FL_TH_MASK,
					DEFAULT_PFCH_STOP_THRESH) |
			FIELD_SET(QDMA_C2H_NUM_PFCH_MASK,
					DEFAULT_PFCH_NUM_ENTRIES_PER_Q) |
			FIELD_SET(QDMA_C2H_PFCH_QCNT_MASK, (cfg_val >> 1)) |
			FIELD_SET(QDMA_C2H_EVT_QCNT_TH_MASK,
					((cfg_val >> 1) - 2));
		qdma_reg_write(dev_hndl, QDMA_OFFSET_C2H_PFETCH_CFG, reg_val);

		/* C2H interrupt timer tick */
		qdma_reg_write(dev_hndl, QDMA_OFFSET_C2H_INT_TIMER_TICK,
				DEFAULT_C2H_INTR_TIMER_TICK);

		/* C2h Completion Coalesce Configuration */
		cfg_val = qdma_reg_read(dev_hndl,
				QDMA_OFFSET_C2H_CMPT_COAL_BUF_DEPTH);
		reg_val =
			FIELD_SET(QDMA_C2H_TICK_CNT_MASK,
					DEFAULT_CMPT_COAL_TIMER_CNT) |
			FIELD_SET(QDMA_C2H_TICK_VAL_MASK,
					DEFAULT_CMPT_COAL_TIMER_TICK) |
			FIELD_SET(QDMA_C2H_MAX_BUF_SZ_MASK, cfg_val);
		qdma_reg_write(dev_hndl, QDMA_OFFSET_C2H_WRB_COAL_CFG, reg_val);

		/* H2C throttle Configuration*/
		reg_val =
			FIELD_SET(QDMA_H2C_DATA_THRESH_MASK,
					EQDMA_H2C_THROT_DATA_THRESH) |
			FIELD_SET(QDMA_H2C_REQ_THROT_EN_DATA_MASK,
					EQDMA_THROT_EN_DATA) |
			FIELD_SET(QDMA_H2C_REQ_THRESH_MASK,
					EQDMA_H2C_THROT_REQ_THRESH) |
			FIELD_SET(QDMA_H2C_REQ_THROT_EN_REQ_MASK,
					EQDMA_THROT_EN_REQ);
		qdma_reg_write(dev_hndl, QDMA_OFFSET_H2C_REQ_THROT, reg_val);
	}

	return QDMA_SUCCESS;
}

/*
 * dump_eqdma_context() - Helper function to dump queue context into string
 *
 * return len - length of the string copied into buffer
 */
static int dump_eqdma_context(struct qdma_descq_context *queue_context,
		uint8_t st,	enum qdma_dev_q_type q_type,
		char *buf, int buf_sz)
{
	int i = 0;
	int n;
	int len = 0;
	int rv;
	char banner[DEBGFS_LINE_SZ];

	if (queue_context == NULL) {
		qdma_log_error("%s: queue_context is NULL, err:%d\n",
						__func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (q_type == QDMA_DEV_Q_TYPE_CMPT) {
		eqdma_fill_cmpt_ctxt(&queue_context->cmpt_ctxt);
	} else if (q_type == QDMA_DEV_Q_TYPE_H2C) {
		eqdma_fill_sw_ctxt(&queue_context->sw_ctxt);
		eqdma_fill_hw_ctxt(&queue_context->hw_ctxt);
		eqdma_fill_credit_ctxt(&queue_context->cr_ctxt);
	} else if (q_type == QDMA_DEV_Q_TYPE_C2H) {
		eqdma_fill_sw_ctxt(&queue_context->sw_ctxt);
		eqdma_fill_hw_ctxt(&queue_context->hw_ctxt);
		eqdma_fill_credit_ctxt(&queue_context->cr_ctxt);
		if (st) {
			eqdma_fill_pfetch_ctxt(&queue_context->pfetch_ctxt);
			eqdma_fill_cmpt_ctxt(&queue_context->cmpt_ctxt);
		}
	}

	if (q_type != QDMA_DEV_Q_TYPE_CMPT) {
		for (i = 0; i < DEBGFS_LINE_SZ - 5; i++) {
			rv = QDMA_SNPRINTF_S(banner + i,
				(DEBGFS_LINE_SZ - i),
				sizeof("-"), "-");
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
		}

		/* SW context dump */
		n = sizeof(eqdma_sw_ctxt_entries) /
				sizeof((eqdma_sw_ctxt_entries)[0]);
		for (i = 0; i < n; i++) {
			if ((len >= buf_sz) ||
				((len + DEBGFS_LINE_SZ) >= buf_sz))
				goto INSUF_BUF_EXIT;

			if (i == 0) {
				if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
					goto INSUF_BUF_EXIT;
				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%40s", "SW Context");
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s\n", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;
			}

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ,
				"%-47s %#-10x %u\n",
				eqdma_sw_ctxt_entries[i].name,
				eqdma_sw_ctxt_entries[i].value,
				eqdma_sw_ctxt_entries[i].value);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}

		/* HW context dump */
		n = sizeof(eqdma_hw_ctxt_entries) /
				sizeof((eqdma_hw_ctxt_entries)[0]);
		for (i = 0; i < n; i++) {
			if ((len >= buf_sz) ||
				((len + DEBGFS_LINE_SZ) >= buf_sz))
				goto INSUF_BUF_EXIT;

			if (i == 0) {
				if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
					goto INSUF_BUF_EXIT;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%40s", "HW Context");
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s\n", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;
			}

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ,
				"%-47s %#-10x %u\n",
				eqdma_hw_ctxt_entries[i].name,
				eqdma_hw_ctxt_entries[i].value,
				eqdma_hw_ctxt_entries[i].value);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}

		/* Credit context dump */
		n = sizeof(eqdma_credit_ctxt_entries) /
			sizeof((eqdma_credit_ctxt_entries)[0]);
		for (i = 0; i < n; i++) {
			if ((len >= buf_sz) ||
				((len + DEBGFS_LINE_SZ) >= buf_sz))
				goto INSUF_BUF_EXIT;

			if (i == 0) {
				if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
					goto INSUF_BUF_EXIT;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%40s",
					"Credit Context");
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s\n", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;
			}

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ,
				"%-47s %#-10x %u\n",
				eqdma_credit_ctxt_entries[i].name,
				eqdma_credit_ctxt_entries[i].value,
				eqdma_credit_ctxt_entries[i].value);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}
	}

	if ((q_type == QDMA_DEV_Q_TYPE_CMPT) ||
			(st && q_type == QDMA_DEV_Q_TYPE_C2H)) {
		/* Completion context dump */
		n = sizeof(eqdma_cmpt_ctxt_entries) /
				sizeof((eqdma_cmpt_ctxt_entries)[0]);
		for (i = 0; i < n; i++) {
			if ((len >= buf_sz) ||
				((len + DEBGFS_LINE_SZ) >= buf_sz))
				goto INSUF_BUF_EXIT;

			if (i == 0) {
				if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
					goto INSUF_BUF_EXIT;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%40s",
					"Completion Context");
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s\n", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;
			}

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ,
				"%-47s %#-10x %u\n",
				eqdma_cmpt_ctxt_entries[i].name,
				eqdma_cmpt_ctxt_entries[i].value,
				eqdma_cmpt_ctxt_entries[i].value);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}
	}

	if (st && q_type == QDMA_DEV_Q_TYPE_C2H) {
		/* Prefetch context dump */
		n = sizeof(eqdma_c2h_pftch_ctxt_entries) /
			sizeof(eqdma_c2h_pftch_ctxt_entries[0]);
		for (i = 0; i < n; i++) {
			if ((len >= buf_sz) ||
				((len + DEBGFS_LINE_SZ) >= buf_sz))
				goto INSUF_BUF_EXIT;

			if (i == 0) {
				if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
					goto INSUF_BUF_EXIT;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%40s",
					"Prefetch Context");
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;

				rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
					DEBGFS_LINE_SZ, "\n%s\n", banner);
				if (rv < 0) {
					qdma_log_error(
						"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
						__LINE__, __func__,
						rv);
					goto INSUF_BUF_EXIT;
				}
				len += rv;
			}

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ,
				"%-47s %#-10x %u\n",
				eqdma_c2h_pftch_ctxt_entries[i].name,
				eqdma_c2h_pftch_ctxt_entries[i].value,
				eqdma_c2h_pftch_ctxt_entries[i].value);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}
	}

	return len;

INSUF_BUF_EXIT:
	if (buf_sz > DEBGFS_LINE_SZ) {
		rv = QDMA_SNPRINTF_S((buf + buf_sz - DEBGFS_LINE_SZ),
			buf_sz, DEBGFS_LINE_SZ,
			"\n\nInsufficient buffer size, partial context dump\n");
		if (rv < 0) {
			qdma_log_error(
				"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
				__LINE__, __func__,
				rv);
		}
	}

	qdma_log_error("%s: Insufficient buffer size, err:%d\n",
		__func__, -QDMA_ERR_NO_MEM);

	return -QDMA_ERR_NO_MEM;
}

/*
 * dump_eqdma_intr_context() - Helper function to dump interrupt context into
 * string
 *
 * return len - length of the string copied into buffer
 */
static int dump_eqdma_intr_context(struct qdma_indirect_intr_ctxt *intr_ctx,
		int ring_index,
		char *buf, int buf_sz)
{
	int i = 0;
	int n;
	int len = 0;
	int rv;
	char banner[DEBGFS_LINE_SZ];

	eqdma_fill_intr_ctxt(intr_ctx);

	for (i = 0; i < DEBGFS_LINE_SZ - 5; i++) {
		rv = QDMA_SNPRINTF_S(banner + i,
			(DEBGFS_LINE_SZ - i),
			sizeof("-"), "-");
		if (rv < 0) {
			qdma_log_error(
				"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
				__LINE__, __func__,
				rv);
			goto INSUF_BUF_EXIT;
		}
	}

	/* Interrupt context dump */
	n = sizeof(eqdma_ind_intr_ctxt_entries) /
			sizeof((eqdma_ind_intr_ctxt_entries)[0]);
	for (i = 0; i < n; i++) {
		if ((len >= buf_sz) || ((len + DEBGFS_LINE_SZ) >= buf_sz))
			goto INSUF_BUF_EXIT;

		if (i == 0) {
			if ((len + (3 * DEBGFS_LINE_SZ)) >= buf_sz)
				goto INSUF_BUF_EXIT;

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ, "\n%s", banner);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ, "\n%50s %d",
				"Interrupt Context for ring#", ring_index);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;

			rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len),
				DEBGFS_LINE_SZ, "\n%s\n", banner);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				goto INSUF_BUF_EXIT;
			}
			len += rv;
		}

		rv = QDMA_SNPRINTF_S(buf + len, (buf_sz - len), DEBGFS_LINE_SZ,
			"%-47s %#-10x %u\n",
			eqdma_ind_intr_ctxt_entries[i].name,
			eqdma_ind_intr_ctxt_entries[i].value,
			eqdma_ind_intr_ctxt_entries[i].value);
		if (rv < 0) {
			qdma_log_error(
				"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
				__LINE__, __func__,
				rv);
			goto INSUF_BUF_EXIT;
		}
		len += rv;
	}

	return len;

INSUF_BUF_EXIT:
	if (buf_sz > DEBGFS_LINE_SZ) {
		rv = QDMA_SNPRINTF_S((buf + buf_sz - DEBGFS_LINE_SZ),
			buf_sz, DEBGFS_LINE_SZ,
			"\n\nInsufficient buffer size, partial context dump\n");
		if (rv < 0) {
			qdma_log_error(
				"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
				__LINE__, __func__,
				rv);
		}
	}

		qdma_log_error("%s: Insufficient buffer size, err:%d\n",
			__func__, -QDMA_ERR_NO_MEM);

		return -QDMA_ERR_NO_MEM;
}

/*****************************************************************************/
/**
 * eqdma_get_version() - Function to get the eqdma version
 *
 * @dev_hndl:	device handle
 * @is_vf:	Whether PF or VF
 * @version_info:	pointer to hold the version info
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_get_version(void *dev_hndl, uint8_t is_vf,
		struct qdma_hw_version_info *version_info)
{
	uint32_t reg_val = 0;
	uint32_t reg_addr = (is_vf) ? EQDMA_OFFSET_VF_VERSION :
			QDMA_OFFSET_GLBL2_MISC_CAP;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	reg_val = qdma_reg_read(dev_hndl, reg_addr);

	qdma_fetch_version_details(is_vf, reg_val, version_info);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_sw_context_write() - create sw context and program it
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the SW context data strucutre
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_sw_context_write(void *dev_hndl, uint8_t c2h,
			 uint16_t hw_qid,
			 const struct qdma_descq_sw_ctxt *ctxt)
{
	uint32_t sw_ctxt[EQDMA_SW_CONTEXT_NUM_WORDS] = {0};
	uint16_t num_words_count = 0;
	uint32_t pasid_l, pasid_h;
	uint32_t virtio_desc_base_l, virtio_desc_base_m, virtio_desc_base_h;
	enum ind_ctxt_cmd_sel sel = c2h ?
			QDMA_CTXT_SEL_SW_C2H : QDMA_CTXT_SEL_SW_H2C;

	/* Input args check */
	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle=%p sw_ctxt=%p NULL, err:%d\n",
					   __func__, dev_hndl, ctxt,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	pasid_l =
		FIELD_GET(EQDMA_SW_CTXT_PASID_GET_L_MASK, ctxt->pasid);
	pasid_h =
		FIELD_GET(EQDMA_SW_CTXT_PASID_GET_H_MASK, ctxt->pasid);

	virtio_desc_base_l = (uint32_t)FIELD_GET(
		EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_L_MASK,
		ctxt->virtio_dsc_base);
	virtio_desc_base_m = (uint32_t)FIELD_GET(
		EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_M_MASK,
		ctxt->virtio_dsc_base);
	virtio_desc_base_h = (uint32_t)FIELD_GET(
		EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_H_MASK,
		ctxt->virtio_dsc_base);

	sw_ctxt[num_words_count++] =
		FIELD_SET(QDMA_SW_CTXT_W0_PIDX, ctxt->pidx) |
		FIELD_SET(QDMA_SW_CTXT_W0_IRQ_ARM_MASK, ctxt->irq_arm) |
		FIELD_SET(QDMA_SW_CTXT_W0_FUNC_ID_MASK, ctxt->fnc_id);

	qdma_log_debug("%s: pidx=%x, irq_arm=%x, fnc_id=%x\n",
			 __func__, ctxt->pidx, ctxt->irq_arm, ctxt->fnc_id);

	sw_ctxt[num_words_count++] =
		FIELD_SET(QDMA_SW_CTXT_W1_QEN_MASK, ctxt->qen) |
		FIELD_SET(QDMA_SW_CTXT_W1_FCRD_EN_MASK, ctxt->frcd_en) |
		FIELD_SET(QDMA_SW_CTXT_W1_WBI_CHK_MASK, ctxt->wbi_chk) |
		FIELD_SET(QDMA_SW_CTXT_W1_WB_INT_EN_MASK, ctxt->wbi_intvl_en) |
		FIELD_SET(QDMA_SW_CTXT_W1_AT_MASK, ctxt->at) |
		FIELD_SET(QDMA_SW_CTXT_W1_FETCH_MAX_MASK, ctxt->fetch_max) |
		FIELD_SET(QDMA_SW_CTXT_W1_RNG_SZ_MASK, ctxt->rngsz_idx) |
		FIELD_SET(QDMA_SW_CTXT_W1_DSC_SZ_MASK, ctxt->desc_sz) |
		FIELD_SET(QDMA_SW_CTXT_W1_BYP_MASK, ctxt->bypass) |
		FIELD_SET(QDMA_SW_CTXT_W1_MM_CHN_MASK, ctxt->mm_chn) |
		FIELD_SET(QDMA_SW_CTXT_W1_WBK_EN_MASK, ctxt->wbk_en) |
		FIELD_SET(QDMA_SW_CTXT_W1_IRQ_EN_MASK, ctxt->irq_en) |
		FIELD_SET(QDMA_SW_CTXT_W1_PORT_ID_MASK, ctxt->port_id) |
		FIELD_SET(QDMA_SW_CTXT_W1_IRQ_NO_LAST_MASK, ctxt->irq_no_last) |
		FIELD_SET(QDMA_SW_CTXT_W1_ERR_MASK, ctxt->err) |
		FIELD_SET(QDMA_SW_CTXT_W1_ERR_WB_SENT_MASK, ctxt->err_wb_sent) |
		FIELD_SET(QDMA_SW_CTXT_W1_IRQ_REQ_MASK, ctxt->irq_req) |
		FIELD_SET(QDMA_SW_CTXT_W1_MRKR_DIS_MASK, ctxt->mrkr_dis) |
		FIELD_SET(QDMA_SW_CTXT_W1_IS_MM_MASK, ctxt->is_mm);

	qdma_log_debug("%s: qen=%x, frcd_en=%x, wbi_chk=%x, wbi_intvl_en=%x\n",
			 __func__, ctxt->qen, ctxt->frcd_en, ctxt->wbi_chk,
			ctxt->wbi_intvl_en);

	qdma_log_debug("%s: at=%x, fetch_max=%x, rngsz_idx=%x, desc_sz=%x\n",
			__func__, ctxt->at, ctxt->fetch_max, ctxt->rngsz_idx,
			ctxt->desc_sz);

	qdma_log_debug("%s: bypass=%x, mm_chn=%x, wbk_en=%x, irq_en=%x\n",
			__func__, ctxt->bypass, ctxt->mm_chn, ctxt->wbk_en,
			ctxt->irq_en);

	qdma_log_debug("%s: port_id=%x, irq_no_last=%x,err=%x",
			__func__, ctxt->port_id, ctxt->irq_no_last, ctxt->err);
	qdma_log_debug(", err_wb_sent=%x\n", ctxt->err_wb_sent);

	qdma_log_debug("%s: irq_req=%x, mrkr_dis=%x, is_mm=%x\n",
			__func__, ctxt->irq_req, ctxt->mrkr_dis, ctxt->is_mm);

	sw_ctxt[num_words_count++] = ctxt->ring_bs_addr & 0xffffffff;
	sw_ctxt[num_words_count++] = (ctxt->ring_bs_addr >> 32) & 0xffffffff;

	sw_ctxt[num_words_count++] =
		FIELD_SET(QDMA_SW_CTXT_W4_VEC_MASK, ctxt->vec) |
		FIELD_SET(QDMA_SW_CTXT_W4_INTR_AGGR_MASK, ctxt->intr_aggr) |
		FIELD_SET(EQDMA_SW_CTXT_W4_DIS_INTR_VF_MASK,
				ctxt->dis_intr_on_vf) |
		FIELD_SET(EQDMA_SW_CTXT_W4_VIRTIO_EN_MASK,
				ctxt->virtio_en) |
		FIELD_SET(EQDMA_SW_CTXT_W4_PACK_BYP_OUT_MASK,
				ctxt->pack_byp_out) |
		FIELD_SET(EQDMA_SW_CTXT_W4_IRQ_BYP_MASK, ctxt->irq_byp) |
		FIELD_SET(EQDMA_SW_CTXT_W4_HOST_ID_MASK, ctxt->host_id) |
		FIELD_SET(EQDMA_SW_CTXT_W4_PASID_L_MASK, pasid_l);

	sw_ctxt[num_words_count++] =
		FIELD_SET(EQDMA_SW_CTXT_W5_PASID_H_MASK, pasid_h) |
		FIELD_SET(EQDMA_SW_CTXT_W5_PASID_EN_MASK, ctxt->pasid_en) |
		FIELD_SET(EQDMA_SW_CTXT_W5_VIRTIO_DSC_BASE_L_MASK,
				virtio_desc_base_l);

	sw_ctxt[num_words_count++] =
		FIELD_SET(EQDMA_SW_CTXT_W6_VIRTIO_DSC_BASE_M_MASK,
				virtio_desc_base_m);

	sw_ctxt[num_words_count++] =
		FIELD_SET(EQDMA_SW_CTXT_W7_VIRTIO_DSC_BASE_H_MASK,
				virtio_desc_base_h);


	qdma_log_debug("%s: vec=%x, intr_aggr=%x\n",
			__func__, ctxt->vec, ctxt->intr_aggr);

	return eqdma_indirect_reg_write(dev_hndl, sel, hw_qid,
			sw_ctxt, num_words_count);
}

/*****************************************************************************/
/**
 * eqdma_sw_context_read() - read sw context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the output context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_sw_context_read(void *dev_hndl, uint8_t c2h,
			 uint16_t hw_qid,
			 struct qdma_descq_sw_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t sw_ctxt[EQDMA_SW_CONTEXT_NUM_WORDS] = {0};
	uint32_t pasid_l, pasid_h;
	uint32_t virtio_desc_base_l, virtio_desc_base_m, virtio_desc_base_h;
	enum ind_ctxt_cmd_sel sel = c2h ?
			QDMA_CTXT_SEL_SW_C2H : QDMA_CTXT_SEL_SW_H2C;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle=%p sw_ctxt=%p NULL, err:%d\n",
					   __func__, dev_hndl, ctxt,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, hw_qid,
			EQDMA_SW_CONTEXT_NUM_WORDS, sw_ctxt);
	if (rv < 0)
		return rv;

	ctxt->pidx = FIELD_GET(QDMA_SW_CTXT_W0_PIDX, sw_ctxt[0]);
	ctxt->irq_arm =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W0_IRQ_ARM_MASK, sw_ctxt[0]));
	ctxt->fnc_id =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W0_FUNC_ID_MASK, sw_ctxt[0]));

	qdma_log_debug("%s: pidx=%x, irq_arm=%x, fnc_id=%x",
			 __func__, ctxt->pidx, ctxt->irq_arm, ctxt->fnc_id);

	ctxt->qen = FIELD_GET(QDMA_SW_CTXT_W1_QEN_MASK, sw_ctxt[1]);
	ctxt->frcd_en = FIELD_GET(QDMA_SW_CTXT_W1_FCRD_EN_MASK, sw_ctxt[1]);
	ctxt->wbi_chk = FIELD_GET(QDMA_SW_CTXT_W1_WBI_CHK_MASK, sw_ctxt[1]);
	ctxt->wbi_intvl_en =
		FIELD_GET(QDMA_SW_CTXT_W1_WB_INT_EN_MASK, sw_ctxt[1]);
	ctxt->at = FIELD_GET(QDMA_SW_CTXT_W1_AT_MASK, sw_ctxt[1]);
	ctxt->fetch_max =
		FIELD_GET(QDMA_SW_CTXT_W1_FETCH_MAX_MASK, sw_ctxt[1]);
	ctxt->rngsz_idx =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_RNG_SZ_MASK, sw_ctxt[1]));
	ctxt->desc_sz =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_DSC_SZ_MASK, sw_ctxt[1]));
	ctxt->bypass =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_BYP_MASK, sw_ctxt[1]));
	ctxt->mm_chn =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_MM_CHN_MASK, sw_ctxt[1]));
	ctxt->wbk_en =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_WBK_EN_MASK, sw_ctxt[1]));
	ctxt->irq_en =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_IRQ_EN_MASK, sw_ctxt[1]));
	ctxt->port_id =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_PORT_ID_MASK, sw_ctxt[1]));
	ctxt->irq_no_last =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_IRQ_NO_LAST_MASK,
			sw_ctxt[1]));
	ctxt->err =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_ERR_MASK, sw_ctxt[1]));
	ctxt->err_wb_sent =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_ERR_WB_SENT_MASK,
			sw_ctxt[1]));
	ctxt->irq_req =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_IRQ_REQ_MASK, sw_ctxt[1]));
	ctxt->mrkr_dis =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_MRKR_DIS_MASK, sw_ctxt[1]));
	ctxt->is_mm =
		(uint8_t)(FIELD_GET(QDMA_SW_CTXT_W1_IS_MM_MASK, sw_ctxt[1]));

	qdma_log_debug("%s: qen=%x, frcd_en=%x, wbi_chk=%x, wbi_intvl_en=%x\n",
			 __func__, ctxt->qen, ctxt->frcd_en, ctxt->wbi_chk,
			ctxt->wbi_intvl_en);
	qdma_log_debug("%s: at=%x, fetch_max=%x, rngsz_idx=%x, desc_sz=%x\n",
			__func__, ctxt->at, ctxt->fetch_max, ctxt->rngsz_idx,
			ctxt->desc_sz);
	qdma_log_debug("%s: bypass=%x, mm_chn=%x, wbk_en=%x, irq_en=%x\n",
			__func__, ctxt->bypass, ctxt->mm_chn, ctxt->wbk_en,
			ctxt->irq_en);
	qdma_log_debug("%s: port_id=%x, irq_no_last=%x,",
			__func__, ctxt->port_id, ctxt->irq_no_last);
	qdma_log_debug(" err=%x, err_wb_sent=%x\n",
			ctxt->err, ctxt->err_wb_sent);
	qdma_log_debug("%s: irq_req=%x, mrkr_dis=%x, is_mm=%x\n",
			__func__, ctxt->irq_req, ctxt->mrkr_dis, ctxt->is_mm);

	ctxt->ring_bs_addr = ((uint64_t)sw_ctxt[3] << 32) | (sw_ctxt[2]);

	ctxt->vec = FIELD_GET(QDMA_SW_CTXT_W4_VEC_MASK, sw_ctxt[4]);
	ctxt->intr_aggr = (uint8_t)(FIELD_GET(QDMA_SW_CTXT_W4_INTR_AGGR_MASK,
			sw_ctxt[4]));
	ctxt->dis_intr_on_vf =
		(uint8_t)(FIELD_GET(EQDMA_SW_CTXT_W4_DIS_INTR_VF_MASK,
				sw_ctxt[4]));
	ctxt->virtio_en =
		(uint8_t)(FIELD_GET(EQDMA_SW_CTXT_W4_VIRTIO_EN_MASK,
				sw_ctxt[4]));
	ctxt->pack_byp_out =
		(uint8_t)(FIELD_GET(EQDMA_SW_CTXT_W4_PACK_BYP_OUT_MASK,
				sw_ctxt[4]));
	ctxt->irq_byp =
		(uint8_t)(FIELD_GET(EQDMA_SW_CTXT_W4_IRQ_BYP_MASK,
				sw_ctxt[4]));
	ctxt->host_id =
		(uint8_t)(FIELD_GET(EQDMA_SW_CTXT_W4_HOST_ID_MASK,
				sw_ctxt[4]));
	pasid_l = FIELD_GET(EQDMA_SW_CTXT_W4_PASID_L_MASK, sw_ctxt[4]);

	pasid_h = FIELD_GET(EQDMA_SW_CTXT_W5_PASID_H_MASK, sw_ctxt[5]);
	ctxt->pasid_en = (uint8_t)FIELD_GET(EQDMA_SW_CTXT_W5_PASID_EN_MASK,
			sw_ctxt[5]);
	virtio_desc_base_l =
		FIELD_GET(EQDMA_SW_CTXT_W5_VIRTIO_DSC_BASE_L_MASK,
				sw_ctxt[5]);
	virtio_desc_base_m =
		FIELD_GET(EQDMA_SW_CTXT_W6_VIRTIO_DSC_BASE_M_MASK,
				sw_ctxt[6]);

	virtio_desc_base_h =
		FIELD_GET(EQDMA_SW_CTXT_W7_VIRTIO_DSC_BASE_H_MASK,
				sw_ctxt[6]);

	ctxt->pasid =
			FIELD_SET(EQDMA_SW_CTXT_PASID_GET_L_MASK, pasid_l) |
			FIELD_SET(EQDMA_SW_CTXT_PASID_GET_H_MASK, pasid_h);

	ctxt->virtio_dsc_base =
			FIELD_SET(EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_L_MASK,
					virtio_desc_base_l) |
			FIELD_SET(EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_M_MASK,
					virtio_desc_base_m) |
			FIELD_SET(EQDMA_SW_CTXT_VIRTIO_DSC_BASE_GET_H_MASK,
					virtio_desc_base_h);

	qdma_log_debug("%s: vec=%x, intr_aggr=%x\n",
			__func__, ctxt->vec, ctxt->intr_aggr);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_sw_context_clear() - clear sw context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_sw_context_clear(void *dev_hndl, uint8_t c2h,
			  uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ?
			QDMA_CTXT_SEL_SW_C2H : QDMA_CTXT_SEL_SW_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_sw_context_invalidate() - invalidate sw context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_sw_context_invalidate(void *dev_hndl, uint8_t c2h,
		uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ?
			QDMA_CTXT_SEL_SW_C2H : QDMA_CTXT_SEL_SW_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}
	return eqdma_indirect_reg_invalidate(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_sw_ctx_conf() - configure SW context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_sw_ctx_conf(void *dev_hndl, uint8_t c2h, uint16_t hw_qid,
				struct qdma_descq_sw_ctxt *ctxt,
				enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_sw_context_read(dev_hndl, c2h, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_WRITE:
		rv = eqdma_sw_context_write(dev_hndl, c2h, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_sw_context_clear(dev_hndl, c2h, hw_qid);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_sw_context_invalidate(dev_hndl, c2h, hw_qid);
		break;
	default:
		qdma_log_error("%s: access_type(%d) invalid, err:%d\n",
						__func__,
						access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_pfetch_context_write() - create prefetch context and program it
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the prefetch context data strucutre
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_pfetch_context_write(void *dev_hndl, uint16_t hw_qid,
		const struct qdma_descq_prefetch_ctxt *ctxt)
{
	uint32_t pfetch_ctxt[EQDMA_PFETCH_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_PFTCH;
	uint32_t sw_crdt_l, sw_crdt_h;
	uint16_t num_words_count = 0;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle or pfetch ctxt NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	sw_crdt_l =
		FIELD_GET(QDMA_PFTCH_CTXT_SW_CRDT_GET_L_MASK, ctxt->sw_crdt);
	sw_crdt_h =
		FIELD_GET(QDMA_PFTCH_CTXT_SW_CRDT_GET_H_MASK, ctxt->sw_crdt);

	qdma_log_debug("%s: sw_crdt_l=%u, sw_crdt_h=%u, hw_qid=%hu\n",
			 __func__, sw_crdt_l, sw_crdt_h, hw_qid);

	pfetch_ctxt[num_words_count++] =
		FIELD_SET(QDMA_PFTCH_CTXT_W0_BYPASS_MASK, ctxt->bypass) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_BUF_SIZE_IDX_MASK,
				ctxt->bufsz_idx) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_PORT_ID_MASK, ctxt->port_id) |
		FIELD_SET(EQDMA_PFTCH_CTXT_W0_NUM_PFTCH_MASK,
				ctxt->num_pftch) |
		FIELD_SET(EQDMA_PFTCH_CTXT_W0_VAR_DESC_MASK,
				ctxt->var_desc) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_ERR_MASK, ctxt->err) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_PFETCH_EN_MASK, ctxt->pfch_en) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_Q_IN_PFETCH_MASK, ctxt->pfch) |
		FIELD_SET(QDMA_PFTCH_CTXT_W0_SW_CRDT_L_MASK, sw_crdt_l);

	qdma_log_debug("%s: bypass=%x, bufsz_idx=%x, port_id=%x\n",
			__func__, ctxt->bypass, ctxt->bufsz_idx, ctxt->port_id);
	qdma_log_debug("%s: err=%x, pfch_en=%x, pfch=%x, ctxt->valid=%x\n",
			__func__, ctxt->err, ctxt->pfch_en, ctxt->pfch,
			ctxt->valid);

	pfetch_ctxt[num_words_count++] =
		FIELD_SET(QDMA_PFTCH_CTXT_W1_SW_CRDT_H_MASK, sw_crdt_h) |
		FIELD_SET(QDMA_PFTCH_CTXT_W1_VALID_MASK, ctxt->valid);

	return eqdma_indirect_reg_write(dev_hndl, sel, hw_qid,
			pfetch_ctxt, num_words_count);
}

/*****************************************************************************/
/**
 * eqdma_pfetch_context_read() - read prefetch context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the output context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_pfetch_context_read(void *dev_hndl, uint16_t hw_qid,
		struct qdma_descq_prefetch_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t pfetch_ctxt[EQDMA_PFETCH_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_PFTCH;
	uint32_t sw_crdt_l, sw_crdt_h;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle or pfetch ctxt NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, hw_qid,
			EQDMA_PFETCH_CONTEXT_NUM_WORDS, pfetch_ctxt);
	if (rv < 0)
		return rv;

	ctxt->bypass =
		FIELD_GET(QDMA_PFTCH_CTXT_W0_BYPASS_MASK, pfetch_ctxt[0]);
	ctxt->bufsz_idx =
		FIELD_GET(QDMA_PFTCH_CTXT_W0_BUF_SIZE_IDX_MASK, pfetch_ctxt[0]);
	ctxt->num_pftch = (uint16_t) FIELD_GET(
			EQDMA_PFTCH_CTXT_W0_NUM_PFTCH_MASK, pfetch_ctxt[0]);
	ctxt->port_id =
		FIELD_GET(QDMA_PFTCH_CTXT_W0_PORT_ID_MASK, pfetch_ctxt[0]);
	ctxt->var_desc = (uint8_t)
		FIELD_GET(EQDMA_PFTCH_CTXT_W0_VAR_DESC_MASK,
				pfetch_ctxt[0]);
	ctxt->err =
		(uint8_t)(FIELD_GET(QDMA_PFTCH_CTXT_W0_ERR_MASK,
			pfetch_ctxt[0]));
	ctxt->pfch_en =
		(uint8_t)(FIELD_GET(QDMA_PFTCH_CTXT_W0_PFETCH_EN_MASK,
			pfetch_ctxt[0]));
	ctxt->pfch =
		(uint8_t)(FIELD_GET(QDMA_PFTCH_CTXT_W0_Q_IN_PFETCH_MASK,
				pfetch_ctxt[0]));
	sw_crdt_l =
		FIELD_GET(QDMA_PFTCH_CTXT_W0_SW_CRDT_L_MASK, pfetch_ctxt[0]);

	sw_crdt_h =
		FIELD_GET(QDMA_PFTCH_CTXT_W1_SW_CRDT_H_MASK, pfetch_ctxt[1]);
	ctxt->valid =
		(uint8_t)(FIELD_GET(QDMA_PFTCH_CTXT_W1_VALID_MASK,
			pfetch_ctxt[1]));

	ctxt->sw_crdt =
		FIELD_SET(QDMA_PFTCH_CTXT_SW_CRDT_GET_L_MASK, sw_crdt_l) |
		FIELD_SET(QDMA_PFTCH_CTXT_SW_CRDT_GET_H_MASK, sw_crdt_h);

	qdma_log_debug("%s: sw_crdt_l=%u, sw_crdt_h=%u, hw_qid=%hu\n",
			 __func__, sw_crdt_l, sw_crdt_h, hw_qid);
	qdma_log_debug("%s: bypass=%x, bufsz_idx=%x, port_id=%x\n",
			__func__, ctxt->bypass, ctxt->bufsz_idx, ctxt->port_id);
	qdma_log_debug("%s: err=%x, pfch_en=%x, pfch=%x, ctxt->valid=%x\n",
			__func__, ctxt->err, ctxt->pfch_en, ctxt->pfch,
			ctxt->valid);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_pfetch_context_clear() - clear prefetch context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_pfetch_context_clear(void *dev_hndl, uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_PFTCH;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_pfetch_context_invalidate() - invalidate prefetch context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_pfetch_context_invalidate(void *dev_hndl, uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_PFTCH;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_invalidate(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_pfetch_ctx_conf() - configure prefetch context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_pfetch_ctx_conf(void *dev_hndl, uint16_t hw_qid,
				struct qdma_descq_prefetch_ctxt *ctxt,
				enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_pfetch_context_read(dev_hndl, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_WRITE:
		rv = eqdma_pfetch_context_write(dev_hndl, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_pfetch_context_clear(dev_hndl, hw_qid);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_pfetch_context_invalidate(dev_hndl, hw_qid);
		break;
	default:
		qdma_log_error("%s: access_type(%d) invalid, err:%d\n",
						__func__,
						access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_cmpt_context_write() - create completion context and program it
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the cmpt context data strucutre
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_cmpt_context_write(void *dev_hndl, uint16_t hw_qid,
			   const struct qdma_descq_cmpt_ctxt *ctxt)
{
	uint32_t cmpt_ctxt[EQDMA_CMPT_CONTEXT_NUM_WORDS] = {0};
	uint16_t num_words_count = 0;
	uint32_t baddr_l, baddr_h, pidx_l, pidx_h, pasid_l, pasid_h;
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_CMPT;

	/* Input args check */
	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle or cmpt ctxt NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (ctxt->trig_mode > QDMA_CMPT_UPDATE_TRIG_MODE_TMR_CNTR) {
		qdma_log_error("%s: trig_mode(%d) > (%d) is invalid, err:%d\n",
					__func__,
					ctxt->trig_mode,
					QDMA_CMPT_UPDATE_TRIG_MODE_TMR_CNTR,
					-QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	baddr_l = (uint32_t)FIELD_GET(QDMA_COMPL_CTXT_BADDR_GET_L_MASK,
			ctxt->bs_addr);
	baddr_h = (uint32_t)FIELD_GET(QDMA_COMPL_CTXT_BADDR_GET_H_MASK,
			ctxt->bs_addr);
	pidx_l = FIELD_GET(QDMA_COMPL_CTXT_PIDX_GET_L_MASK, ctxt->pidx);
	pidx_h = FIELD_GET(QDMA_COMPL_CTXT_PIDX_GET_H_MASK, ctxt->pidx);

	pasid_l =
		FIELD_GET(EQDMA_CMPL_CTXT_PASID_GET_L_MASK, ctxt->pasid);
	pasid_h =
		FIELD_GET(EQDMA_CMPL_CTXT_PASID_GET_H_MASK, ctxt->pasid);

	cmpt_ctxt[num_words_count++] =
		FIELD_SET(QDMA_COMPL_CTXT_W0_EN_STAT_DESC_MASK,
				ctxt->en_stat_desc) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_EN_INT_MASK, ctxt->en_int) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_TRIG_MODE_MASK, ctxt->trig_mode) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_FNC_ID_MASK, ctxt->fnc_id) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_COUNTER_IDX_MASK,
				ctxt->counter_idx) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_TIMER_IDX_MASK, ctxt->timer_idx) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_INT_ST_MASK, ctxt->in_st) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_COLOR_MASK, ctxt->color) |
		FIELD_SET(QDMA_COMPL_CTXT_W0_RING_SZ_MASK, ctxt->ringsz_idx);

	cmpt_ctxt[num_words_count++] =
		FIELD_SET(QDMA_COMPL_CTXT_W1_BADDR_64_L_MASK, baddr_l);

	cmpt_ctxt[num_words_count++] =
		FIELD_SET(QDMA_COMPL_CTXT_W2_BADDR_64_H_MASK, baddr_h) |
		FIELD_SET(QDMA_COMPL_CTXT_W2_DESC_SIZE_MASK, ctxt->desc_sz) |
		FIELD_SET(QDMA_COMPL_CTXT_W2_PIDX_L_MASK, pidx_l);


	cmpt_ctxt[num_words_count++] =
		FIELD_SET(QDMA_COMPL_CTXT_W3_PIDX_H_MASK, pidx_h) |
		FIELD_SET(QDMA_COMPL_CTXT_W3_CIDX_MASK, ctxt->cidx) |
		FIELD_SET(QDMA_COMPL_CTXT_W3_VALID_MASK, ctxt->valid) |
		FIELD_SET(QDMA_COMPL_CTXT_W3_ERR_MASK, ctxt->err) |
		FIELD_SET(QDMA_COMPL_CTXT_W3_USR_TRG_PND_MASK,
				ctxt->user_trig_pend);

	cmpt_ctxt[num_words_count++] =
		FIELD_SET(QDMA_COMPL_CTXT_W4_TMR_RUN_MASK,
				ctxt->timer_running) |
		FIELD_SET(QDMA_COMPL_CTXT_W4_FULL_UPDT_MASK, ctxt->full_upd) |
		FIELD_SET(QDMA_COMPL_CTXT_W4_OVF_CHK_DIS_MASK,
				ctxt->ovf_chk_dis) |
		FIELD_SET(QDMA_COMPL_CTXT_W4_AT_MASK, ctxt->at) |
		FIELD_SET(QDMA_COMPL_CTXT_W4_INTR_VEC_MASK, ctxt->vec) |
		FIELD_SET(QDMA_COMPL_CTXT_W4_INTR_AGGR_MASK, ctxt->int_aggr) |
		FIELD_SET(EQDMA_COMPL_CTXT_W4_DIS_INTR_VF_MASK,
				ctxt->dis_intr_on_vf) |
		FIELD_SET(EQDMA_COMPL_CTXT_W4_VIO_MASK, ctxt->vio) |
		FIELD_SET(EQDMA_COMPL_CTXT_W4_DIR_C2H_MASK, ctxt->dir_c2h) |
		FIELD_SET(EQDMA_COMPL_CTXT_W4_HOST_ID_MASK, ctxt->host_id) |
		FIELD_SET(EQDMA_COMPL_CTXT_W4_PASID_L_MASK, pasid_l);

	cmpt_ctxt[num_words_count++] =
		FIELD_SET(EQDMA_COMPL_CTXT_W5_PASID_H_MASK, pasid_h) |
		FIELD_SET(EQDMA_COMPL_CTXT_W5_PASID_EN_MASK,
				ctxt->pasid_en) |
		FIELD_SET(EQDMA_COMPL_CTXT_W5_BADDR4_LOW_MASK,
				ctxt->base_addr) |
		FIELD_SET(EQDMA_COMPL_CTXT_W5_VIO_EOP_MASK, ctxt->vio_eop) |
		FIELD_SET(EQDMA_COMPL_CTXT_W5_SH_CMPT_MASK, ctxt->sh_cmpt);

	return eqdma_indirect_reg_write(dev_hndl, sel, hw_qid,
			cmpt_ctxt, num_words_count);
}

/*****************************************************************************/
/**
 * eqdma_cmpt_context_read() - read completion context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_cmpt_context_read(void *dev_hndl, uint16_t hw_qid,
			   struct qdma_descq_cmpt_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t cmpt_ctxt[EQDMA_CMPT_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_CMPT;
	uint32_t baddr_l, baddr_h, pidx_l, pidx_h, pasid_l, pasid_h;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle or cmpt ctxt NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, hw_qid,
			EQDMA_CMPT_CONTEXT_NUM_WORDS, cmpt_ctxt);
	if (rv < 0)
		return rv;

	ctxt->en_stat_desc =
		FIELD_GET(QDMA_COMPL_CTXT_W0_EN_STAT_DESC_MASK, cmpt_ctxt[0]);
	ctxt->en_int = FIELD_GET(QDMA_COMPL_CTXT_W0_EN_INT_MASK, cmpt_ctxt[0]);
	ctxt->trig_mode =
		FIELD_GET(QDMA_COMPL_CTXT_W0_TRIG_MODE_MASK, cmpt_ctxt[0]);
	ctxt->fnc_id =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_FNC_ID_MASK,
			cmpt_ctxt[0]));
	ctxt->counter_idx =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_COUNTER_IDX_MASK,
			cmpt_ctxt[0]));
	ctxt->timer_idx =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_TIMER_IDX_MASK,
			cmpt_ctxt[0]));
	ctxt->in_st =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_INT_ST_MASK,
			cmpt_ctxt[0]));
	ctxt->color =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_COLOR_MASK,
			cmpt_ctxt[0]));
	ctxt->ringsz_idx =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W0_RING_SZ_MASK,
			cmpt_ctxt[0]));

	baddr_l = FIELD_GET(QDMA_COMPL_CTXT_W1_BADDR_64_L_MASK, cmpt_ctxt[1]);

	baddr_h = FIELD_GET(QDMA_COMPL_CTXT_W2_BADDR_64_H_MASK, cmpt_ctxt[2]);
	ctxt->desc_sz =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W2_DESC_SIZE_MASK,
			cmpt_ctxt[2]));
	pidx_l = FIELD_GET(QDMA_COMPL_CTXT_W2_PIDX_L_MASK, cmpt_ctxt[2]);

	pidx_h = FIELD_GET(QDMA_COMPL_CTXT_W3_PIDX_H_MASK, cmpt_ctxt[3]);
	ctxt->cidx =
		(uint16_t)(FIELD_GET(QDMA_COMPL_CTXT_W3_CIDX_MASK,
			cmpt_ctxt[3]));
	ctxt->valid =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W3_VALID_MASK,
			cmpt_ctxt[3]));
	ctxt->err =
		(uint8_t)(FIELD_GET(QDMA_COMPL_CTXT_W3_ERR_MASK, cmpt_ctxt[3]));
	ctxt->user_trig_pend = (uint8_t)
		(FIELD_GET(QDMA_COMPL_CTXT_W3_USR_TRG_PND_MASK, cmpt_ctxt[3]));

	ctxt->timer_running =
		FIELD_GET(QDMA_COMPL_CTXT_W4_TMR_RUN_MASK, cmpt_ctxt[4]);
	ctxt->full_upd =
		FIELD_GET(QDMA_COMPL_CTXT_W4_FULL_UPDT_MASK, cmpt_ctxt[4]);
	ctxt->ovf_chk_dis =
		FIELD_GET(QDMA_COMPL_CTXT_W4_OVF_CHK_DIS_MASK, cmpt_ctxt[4]);
	ctxt->at = FIELD_GET(QDMA_COMPL_CTXT_W4_AT_MASK, cmpt_ctxt[4]);
	ctxt->vec = FIELD_GET(QDMA_COMPL_CTXT_W4_INTR_VEC_MASK, cmpt_ctxt[4]);
	ctxt->int_aggr = (uint8_t)
		(FIELD_GET(QDMA_COMPL_CTXT_W4_INTR_AGGR_MASK, cmpt_ctxt[4]));
	ctxt->dis_intr_on_vf = (uint8_t)
		FIELD_GET(EQDMA_COMPL_CTXT_W4_DIS_INTR_VF_MASK,
				cmpt_ctxt[4]);
	ctxt->vio = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W4_VIO_MASK,
			cmpt_ctxt[4]);
	ctxt->dir_c2h = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W4_DIR_C2H_MASK,
			cmpt_ctxt[4]);
	ctxt->host_id = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W4_HOST_ID_MASK,
			cmpt_ctxt[4]);
	pasid_l = FIELD_GET(EQDMA_COMPL_CTXT_W4_PASID_L_MASK, cmpt_ctxt[4]);

	pasid_h = (uint32_t)FIELD_GET(EQDMA_COMPL_CTXT_W5_PASID_H_MASK,
			cmpt_ctxt[5]);
	ctxt->pasid_en = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W5_PASID_EN_MASK,
			cmpt_ctxt[5]);
	ctxt->base_addr = (uint8_t)FIELD_GET(
			EQDMA_COMPL_CTXT_W5_BADDR4_LOW_MASK, cmpt_ctxt[5]);
	ctxt->vio_eop = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W5_VIO_EOP_MASK,
			cmpt_ctxt[5]);
	ctxt->sh_cmpt = (uint8_t)FIELD_GET(EQDMA_COMPL_CTXT_W5_SH_CMPT_MASK,
			cmpt_ctxt[5]);

	ctxt->bs_addr =
		FIELD_SET(QDMA_COMPL_CTXT_BADDR_GET_L_MASK, baddr_l) |
		FIELD_SET(QDMA_COMPL_CTXT_BADDR_GET_H_MASK, (uint64_t)baddr_h);

	ctxt->pasid =
		FIELD_SET(EQDMA_CMPL_CTXT_PASID_GET_L_MASK, pasid_l) |
		FIELD_SET(EQDMA_CMPL_CTXT_PASID_GET_H_MASK,
				(uint64_t)pasid_h);

	ctxt->pidx =
		FIELD_SET(QDMA_COMPL_CTXT_PIDX_GET_L_MASK, pidx_l) |
		FIELD_SET(QDMA_COMPL_CTXT_PIDX_GET_H_MASK, pidx_h);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_cmpt_context_clear() - clear completion context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_cmpt_context_clear(void *dev_hndl, uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_CMPT;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_cmpt_context_invalidate() - invalidate completion context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_cmpt_context_invalidate(void *dev_hndl, uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_CMPT;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_invalidate(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_cmpt_ctx_conf() - configure completion context
 *
 * @dev_hndl:	device handle
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_cmpt_ctx_conf(void *dev_hndl, uint16_t hw_qid,
			struct qdma_descq_cmpt_ctxt *ctxt,
			enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_cmpt_context_read(dev_hndl, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_WRITE:
		rv = eqdma_cmpt_context_write(dev_hndl, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_cmpt_context_clear(dev_hndl, hw_qid);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_cmpt_context_invalidate(dev_hndl, hw_qid);
		break;
	default:
		qdma_log_error("%s: access_type(%d) invalid, err:%d\n",
						__func__,
						access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_hw_context_read() - read hardware context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the output context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_hw_context_read(void *dev_hndl, uint8_t c2h,
			 uint16_t hw_qid, struct qdma_descq_hw_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t hw_ctxt[EQDMA_HW_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_HW_C2H :
			QDMA_CTXT_SEL_HW_H2C;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_handle or hw_ctxt NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, hw_qid,
			EQDMA_HW_CONTEXT_NUM_WORDS, hw_ctxt);
	if (rv < 0)
		return rv;

	ctxt->cidx = FIELD_GET(QDMA_HW_CTXT_W0_CIDX_MASK, hw_ctxt[0]);
	ctxt->crd_use =
		(uint16_t)(FIELD_GET(QDMA_HW_CTXT_W0_CRD_USE_MASK, hw_ctxt[0]));

	ctxt->dsc_pend =
		(uint8_t)(FIELD_GET(QDMA_HW_CTXT_W1_DSC_PND_MASK, hw_ctxt[1]));
	ctxt->idl_stp_b =
		(uint8_t)(FIELD_GET(QDMA_HW_CTXT_W1_IDL_STP_B_MASK,
			hw_ctxt[1]));
	ctxt->evt_pnd =
		(uint8_t)(FIELD_GET(QDMA_HW_CTXT_W1_EVENT_PEND_MASK,
			hw_ctxt[1]));
	ctxt->fetch_pnd = (uint8_t)
		(FIELD_GET(QDMA_HW_CTXT_W1_FETCH_PEND_MASK, hw_ctxt[1]));

	qdma_log_debug("%s: cidx=%hu, crd_use=%hu, dsc_pend=%x\n",
			__func__, ctxt->cidx, ctxt->crd_use, ctxt->dsc_pend);
	qdma_log_debug("%s: idl_stp_b=%x, evt_pnd=%x, fetch_pnd=%x\n",
			__func__, ctxt->idl_stp_b, ctxt->evt_pnd,
			ctxt->fetch_pnd);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_hw_context_clear() - clear hardware context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_hw_context_clear(void *dev_hndl, uint8_t c2h,
			  uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_HW_C2H :
			QDMA_CTXT_SEL_HW_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_hw_context_invalidate() - invalidate hardware context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_hw_context_invalidate(void *dev_hndl, uint8_t c2h,
				   uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_HW_C2H :
			QDMA_CTXT_SEL_HW_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_invalidate(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_hw_ctx_conf() - configure HW context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *		QDMA_HW_ACCESS_WRITE Not supported
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_hw_ctx_conf(void *dev_hndl, uint8_t c2h, uint16_t hw_qid,
				struct qdma_descq_hw_ctxt *ctxt,
				enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	/** ctxt requires only H2C-0 or C2H-1
	 *  return error for any other values
	 */
	if (c2h > 1) {
		qdma_log_error("%s: c2h(%d) invalid, err:%d\n",
						__func__,
						c2h,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_hw_context_read(dev_hndl, c2h, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_hw_context_clear(dev_hndl, c2h, hw_qid);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_hw_context_invalidate(dev_hndl, c2h, hw_qid);
		break;
	case QDMA_HW_ACCESS_WRITE:
	default:
		qdma_log_error("%s: access_type=%d is invalid, err:%d\n",
					   __func__, access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_credit_context_read() - read credit context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_credit_context_read(void *dev_hndl, uint8_t c2h,
			 uint16_t hw_qid,
			 struct qdma_descq_credit_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t cr_ctxt[EQDMA_CR_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_CR_C2H :
			QDMA_CTXT_SEL_CR_H2C;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_hndl=%p credit_ctxt=%p, err:%d\n",
						__func__, dev_hndl, ctxt,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, hw_qid,
			EQDMA_CR_CONTEXT_NUM_WORDS, cr_ctxt);
	if (rv < 0)
		return rv;

	ctxt->credit = FIELD_GET(QDMA_CR_CTXT_W0_CREDT_MASK, cr_ctxt[0]);

	qdma_log_debug("%s: credit=%u\n", __func__, ctxt->credit);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_credit_context_clear() - clear credit context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_credit_context_clear(void *dev_hndl, uint8_t c2h,
			  uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_CR_C2H :
			QDMA_CTXT_SEL_CR_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_credit_context_invalidate() - invalidate credit context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_credit_context_invalidate(void *dev_hndl, uint8_t c2h,
				   uint16_t hw_qid)
{
	enum ind_ctxt_cmd_sel sel = c2h ? QDMA_CTXT_SEL_CR_C2H :
			QDMA_CTXT_SEL_CR_H2C;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_invalidate(dev_hndl, sel, hw_qid);
}

/*****************************************************************************/
/**
 * eqdma_credit_ctx_conf() - configure credit context
 *
 * @dev_hndl:	device handle
 * @c2h:	is c2h queue
 * @hw_qid:	hardware qid of the queue
 * @ctxt:	pointer to the context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *		QDMA_HW_ACCESS_WRITE Not supported
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_credit_ctx_conf(void *dev_hndl, uint8_t c2h,
		uint16_t hw_qid, struct qdma_descq_credit_ctxt *ctxt,
		enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	/** ctxt requires only H2C-0 or C2H-1
	 *  return error for any other values
	 */
	if (c2h > 1) {
		qdma_log_error("%s: c2h(%d) invalid, err:%d\n",
						__func__,
						c2h,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_credit_context_read(dev_hndl, c2h, hw_qid, ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_credit_context_clear(dev_hndl, c2h, hw_qid);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_credit_context_invalidate(dev_hndl, c2h, hw_qid);
		break;
	case QDMA_HW_ACCESS_WRITE:
	default:
		qdma_log_error("%s: Invalid access type=%d, err:%d\n",
					   __func__, access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}


/*****************************************************************************/
/**
 * eqdma_indirect_intr_context_write() - create indirect interrupt context
 *					and program it
 *
 * @dev_hndl:   device handle
 * @ring_index: indirect interrupt ring index
 * @ctxt:	pointer to the interrupt context data strucutre
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_indirect_intr_context_write(void *dev_hndl,
		uint16_t ring_index, const struct qdma_indirect_intr_ctxt *ctxt)
{
	uint32_t intr_ctxt[EQDMA_IND_INTR_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_INT_COAL;
	uint32_t baddr_l, baddr_m, baddr_h, pasid_l, pasid_h;
	uint16_t num_words_count = 0;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_hndl=%p intr_ctxt=%p, err:%d\n",
						__func__, dev_hndl, ctxt,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	baddr_l = (uint32_t)FIELD_GET(QDMA_INTR_CTXT_BADDR_GET_L_MASK,
			ctxt->baddr_4k);
	baddr_m = (uint32_t)FIELD_GET(QDMA_INTR_CTXT_BADDR_GET_M_MASK,
			ctxt->baddr_4k);
	baddr_h = (uint32_t)FIELD_GET(QDMA_INTR_CTXT_BADDR_GET_H_MASK,
			ctxt->baddr_4k);

	pasid_l =
		FIELD_GET(EQDMA_INTR_CTXT_PASID_GET_L_MASK, ctxt->pasid);
	pasid_h =
		FIELD_GET(EQDMA_INTR_CTXT_PASID_GET_H_MASK, ctxt->pasid);

	intr_ctxt[num_words_count++] =
		FIELD_SET(QDMA_INTR_CTXT_W0_VALID_MASK, ctxt->valid) |
		FIELD_SET(QDMA_INTR_CTXT_W0_VEC_ID_MASK, ctxt->vec) |
		FIELD_SET(QDMA_INTR_CTXT_W0_INT_ST_MASK, ctxt->int_st) |
		FIELD_SET(QDMA_INTR_CTXT_W0_COLOR_MASK, ctxt->color) |
		FIELD_SET(QDMA_INTR_CTXT_W0_BADDR_64_MASK, baddr_l);

	intr_ctxt[num_words_count++] =
		FIELD_SET(QDMA_INTR_CTXT_W1_BADDR_64_MASK, baddr_m);

	intr_ctxt[num_words_count++] =
		FIELD_SET(QDMA_INTR_CTXT_W2_BADDR_64_MASK, baddr_h) |
		FIELD_SET(QDMA_INTR_CTXT_W2_PAGE_SIZE_MASK, ctxt->page_size) |
		FIELD_SET(QDMA_INTR_CTXT_W2_PIDX_MASK, ctxt->pidx) |
		FIELD_SET(QDMA_INTR_CTXT_W2_AT_MASK, ctxt->at) |
		FIELD_SET(EQDMA_INTR_CTXT_W2_HOST_ID_MASK, ctxt->host_id) |
		FIELD_SET(EQDMA_INTR_CTXT_W2_PASID_L_MASK, pasid_l);

	intr_ctxt[num_words_count++] =
		FIELD_SET(EQDMA_INTR_CTXT_W3_PASID_H_MASK, pasid_h) |
		FIELD_SET(EQDMA_INTR_CTXT_W3_PASID_EN_MASK, ctxt->pasid_en) |
		FIELD_SET(EQDMA_INTR_CTXT_W3_FUNC_ID_MASK, ctxt->func_id);

	return eqdma_indirect_reg_write(dev_hndl, sel, ring_index,
			intr_ctxt, num_words_count);
}

/*****************************************************************************/
/**
 * eqdma_indirect_intr_context_read() - read indirect interrupt context
 *
 * @dev_hndl:	device handle
 * @ring_index:	indirect interrupt ring index
 * @ctxt:	pointer to the output context data
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_indirect_intr_context_read(void *dev_hndl,
		uint16_t ring_index, struct qdma_indirect_intr_ctxt *ctxt)
{
	int rv = QDMA_SUCCESS;
	uint32_t intr_ctxt[EQDMA_IND_INTR_CONTEXT_NUM_WORDS] = {0};
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_INT_COAL;
	uint64_t baddr_l, baddr_m, baddr_h, pasid_l, pasid_h;

	if (!dev_hndl || !ctxt) {
		qdma_log_error("%s: dev_hndl=%p intr_ctxt=%p, err:%d\n",
						__func__, dev_hndl, ctxt,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_indirect_reg_read(dev_hndl, sel, ring_index,
			EQDMA_IND_INTR_CONTEXT_NUM_WORDS, intr_ctxt);
	if (rv < 0)
		return rv;

	ctxt->valid = FIELD_GET(QDMA_INTR_CTXT_W0_VALID_MASK, intr_ctxt[0]);
	ctxt->vec = FIELD_GET(QDMA_INTR_CTXT_W0_VEC_ID_MASK, intr_ctxt[0]);
	ctxt->int_st =
		(uint8_t)(FIELD_GET(QDMA_INTR_CTXT_W0_INT_ST_MASK,
			intr_ctxt[0]));
	ctxt->color =
		(uint8_t)(FIELD_GET(QDMA_INTR_CTXT_W0_COLOR_MASK,
			intr_ctxt[0]));
	baddr_l = FIELD_GET(QDMA_INTR_CTXT_W0_BADDR_64_MASK, intr_ctxt[0]);

	baddr_m = FIELD_GET(QDMA_INTR_CTXT_W1_BADDR_64_MASK, intr_ctxt[1]);

	baddr_h = FIELD_GET(QDMA_INTR_CTXT_W2_BADDR_64_MASK, intr_ctxt[2]);
	ctxt->page_size =
		FIELD_GET(QDMA_INTR_CTXT_W2_PAGE_SIZE_MASK, intr_ctxt[2]);
	ctxt->pidx =
		(uint16_t)(FIELD_GET(QDMA_INTR_CTXT_W2_PIDX_MASK,
			intr_ctxt[2]));
	ctxt->at =
		(uint8_t)(FIELD_GET(QDMA_INTR_CTXT_W2_AT_MASK, intr_ctxt[2]));
	ctxt->host_id = (uint8_t)(FIELD_GET(EQDMA_INTR_CTXT_W2_HOST_ID_MASK,
			intr_ctxt[2]));
	pasid_l = (uint8_t)(FIELD_GET(EQDMA_INTR_CTXT_W2_PASID_L_MASK,
			intr_ctxt[2]));

	pasid_h = FIELD_GET(EQDMA_INTR_CTXT_W3_PASID_H_MASK, intr_ctxt[3]);
	ctxt->pasid_en = (uint8_t)FIELD_GET(EQDMA_INTR_CTXT_W3_PASID_EN_MASK,
			intr_ctxt[3]);

	ctxt->func_id = (uint16_t)FIELD_GET(EQDMA_INTR_CTXT_W3_FUNC_ID_MASK,
			intr_ctxt[3]);

	ctxt->baddr_4k =
		FIELD_SET(QDMA_INTR_CTXT_BADDR_GET_L_MASK, baddr_l) |
		FIELD_SET(QDMA_INTR_CTXT_BADDR_GET_M_MASK, baddr_m) |
		FIELD_SET(QDMA_INTR_CTXT_BADDR_GET_H_MASK, baddr_h);

	ctxt->pasid =
		FIELD_SET(EQDMA_INTR_CTXT_PASID_GET_L_MASK, pasid_l) |
		FIELD_SET(EQDMA_INTR_CTXT_PASID_GET_H_MASK, pasid_h);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_indirect_intr_context_clear() - clear indirect interrupt context
 *
 * @dev_hndl:	device handle
 * @ring_index:	indirect interrupt ring index
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_indirect_intr_context_clear(void *dev_hndl,
		uint16_t ring_index)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_INT_COAL;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_clear(dev_hndl, sel, ring_index);
}

/*****************************************************************************/
/**
 * eqdma_indirect_intr_context_invalidate() - invalidate indirect interrupt
 * context
 *
 * @dev_hndl:	device handle
 * @ring_index:	indirect interrupt ring index
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
static int eqdma_indirect_intr_context_invalidate(void *dev_hndl,
					  uint16_t ring_index)
{
	enum ind_ctxt_cmd_sel sel = QDMA_CTXT_SEL_INT_COAL;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n", __func__,
					   -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	return eqdma_indirect_reg_invalidate(dev_hndl, sel, ring_index);
}

/*****************************************************************************/
/**
 * eqdma_indirect_intr_ctx_conf() - configure indirect interrupt context
 *
 * @dev_hndl:	device handle
 * @ring_index:	indirect interrupt ring index
 * @ctxt:	pointer to context data
 * @access_type HW access type (qdma_hw_access_type enum) value
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_indirect_intr_ctx_conf(void *dev_hndl, uint16_t ring_index,
				struct qdma_indirect_intr_ctxt *ctxt,
				enum qdma_hw_access_type access_type)
{
	int rv = QDMA_SUCCESS;

	switch (access_type) {
	case QDMA_HW_ACCESS_READ:
		rv = eqdma_indirect_intr_context_read(dev_hndl, ring_index,
							ctxt);
		break;
	case QDMA_HW_ACCESS_WRITE:
		rv = eqdma_indirect_intr_context_write(dev_hndl, ring_index,
							ctxt);
		break;
	case QDMA_HW_ACCESS_CLEAR:
		rv = eqdma_indirect_intr_context_clear(dev_hndl,
							ring_index);
		break;
	case QDMA_HW_ACCESS_INVALIDATE:
		rv = eqdma_indirect_intr_context_invalidate(dev_hndl,
								ring_index);
		break;
	default:
		qdma_log_error("%s: access_type=%d is invalid, err:%d\n",
					   __func__, access_type,
					   -QDMA_ERR_INV_PARAM);
		rv = -QDMA_ERR_INV_PARAM;
		break;
	}

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_dump_config_regs() - Function to get qdma config register dump in a
 * buffer
 *
 * @dev_hndl:   device handle
 * @is_vf:      Whether PF or VF
 * @buf :       pointer to buffer to be filled
 * @buflen :    Length of the buffer
 *
 * Return:	Length up-till the buffer is filled -success and < 0 - failure
 *****************************************************************************/
int eqdma_dump_config_regs(void *dev_hndl, uint8_t is_vf,
		char *buf, uint32_t buflen)
{
	uint32_t i = 0, j = 0;
	struct xreg_info *reg_info;
	uint32_t num_regs =
		sizeof(eqdma_config_regs)/
		sizeof((eqdma_config_regs)[0]);
	uint32_t len = 0, val = 0;
	int rv = QDMA_SUCCESS;
	char name[DEBGFS_GEN_NAME_SZ] = "";
	struct qdma_dev_attributes *dev_cap;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (buflen < eqdma_reg_dump_buf_len()) {
		qdma_log_error("%s: Buffer too small, err:%d\n",
					__func__, -QDMA_ERR_NO_MEM);
		return -QDMA_ERR_NO_MEM;
	}

	if (is_vf) {
		qdma_log_error("%s: Wrong API used for VF, err:%d\n",
				__func__,
				-QDMA_ERR_HWACC_FEATURE_NOT_SUPPORTED);
		return -QDMA_ERR_HWACC_FEATURE_NOT_SUPPORTED;
	}

	qdma_get_device_attr(dev_hndl, &dev_cap);

	reg_info = eqdma_config_regs;

	for (i = 0; i < num_regs - 1; i++) {
		if ((GET_CAPABILITY_MASK(dev_cap->mm_en, dev_cap->st_en,
				dev_cap->mm_cmpt_en, dev_cap->mailbox_en)
				& reg_info[i].mode) == 0)
			continue;

		for (j = 0; j < reg_info[i].repeat; j++) {
			rv = QDMA_SNPRINTF_S(name, DEBGFS_GEN_NAME_SZ,
					DEBGFS_GEN_NAME_SZ,
					"%s_%d", reg_info[i].name, j);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s QDMA_SNPRINTF_S() failed, err:%d\n",
					__LINE__, __func__,
					rv);
				return -QDMA_ERR_NO_MEM;
			}
			val = qdma_reg_read(dev_hndl,
					(reg_info[i].addr + (j * 4)));
			rv = dump_reg(buf + len, buflen - len,
					(reg_info[i].addr + (j * 4)),
						name, val);
			if (rv < 0) {
				qdma_log_error(
				"%s Buff too small, err:%d\n",
				__func__,
				-QDMA_ERR_NO_MEM);
				return -QDMA_ERR_NO_MEM;
			}
			len += rv;
		}
	}

	return len;
}

/*****************************************************************************/
/**
 * qdma_dump_cpm_queue_context() - Function to get qdma queue context dump
 * in a buffer
 *
 * @dev_hndl:   device handle
 * @st:			Queue Mode(ST or MM)
 * @q_type:		Queue type(H2C/C2H/CMPT)
 * @context:	Queue Context
 * @buf :       pointer to buffer to be filled
 * @buflen :    Length of the buffer
 *
 * Return:	Length up-till the buffer is filled -success and < 0 - failure
 *****************************************************************************/
int eqdma_dump_queue_context(void *dev_hndl,
		uint8_t st,
		enum qdma_dev_q_type q_type,
		struct qdma_descq_context *ctxt_data,
		char *buf, uint32_t buflen)
{
	int rv = 0;
	uint32_t req_buflen = 0;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	if (!ctxt_data) {
		qdma_log_error("%s: ctxt_data is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	if (!buf) {
		qdma_log_error("%s: buf is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	if (q_type >= QDMA_DEV_Q_TYPE_MAX) {
		qdma_log_error("%s: invalid q_type, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_context_buf_len(st, q_type, &req_buflen);
	if (rv != QDMA_SUCCESS)
		return rv;

	if (buflen < req_buflen) {
		qdma_log_error("%s: Too small buffer(%d), reqd(%d), err:%d\n",
			__func__, buflen, req_buflen, -QDMA_ERR_NO_MEM);
		return -QDMA_ERR_NO_MEM;
	}

	rv = dump_eqdma_context(ctxt_data, st, q_type,
				buf, buflen);

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_dump_intr_context() - Function to get qdma interrupt context dump
 * in a buffer
 *
 * @dev_hndl:   device handle
 * @intr_ctx:	Interrupt Context
 * @ring_index: Ring index
 * @buf :       pointer to buffer to be filled
 * @buflen :    Length of the buffer
 *
 * Return:	Length up-till the buffer is filled -success and < 0 - failure
 *****************************************************************************/
int eqdma_dump_intr_context(void *dev_hndl,
		struct qdma_indirect_intr_ctxt *intr_ctx,
		int ring_index,
		char *buf, uint32_t buflen)
{
	int rv = 0;
	uint32_t req_buflen = 0;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}
	if (!intr_ctx) {
		qdma_log_error("%s: intr_ctx is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (!buf) {
		qdma_log_error("%s: buf is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	req_buflen = eqdma_intr_context_buf_len();
	if (buflen < req_buflen) {
		qdma_log_error("%s: Too small buffer(%d), reqd(%d), err:%d\n",
			__func__, buflen, req_buflen, -QDMA_ERR_NO_MEM);
		return -QDMA_ERR_NO_MEM;
	}

	rv = dump_eqdma_intr_context(intr_ctx, ring_index, buf, buflen);

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_read_dump_queue_context() - Function to read and dump the queue
 * context in a buffer
 *
 * @dev_hndl:   device handle
 * @hw_qid:     queue id
 * @st:			Queue Mode(ST or MM)
 * @q_type:		Queue type(H2C/C2H/CMPT)
 * @buf :       pointer to buffer to be filled
 * @buflen :    Length of the buffer
 *
 * Return:	Length up-till the buffer is filled -success and < 0 - failure
 *****************************************************************************/
int eqdma_read_dump_queue_context(void *dev_hndl,
		uint16_t qid_hw,
		uint8_t st,
		enum qdma_dev_q_type q_type,
		char *buf, uint32_t buflen)
{
	int rv = QDMA_SUCCESS;
	uint32_t req_buflen = 0;
	struct qdma_descq_context context;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	if (!buf) {
		qdma_log_error("%s: buf is NULL, err:%d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	if (q_type > QDMA_DEV_Q_TYPE_CMPT) {
		qdma_log_error("%s: Not supported for q_type, err = %d\n",
			__func__, -QDMA_ERR_INV_PARAM);

		return -QDMA_ERR_INV_PARAM;
	}

	rv = eqdma_context_buf_len(st, q_type, &req_buflen);
	if (rv != QDMA_SUCCESS)
		return rv;

	if (buflen < req_buflen) {
		qdma_log_error("%s: Too small buffer(%d), reqd(%d), err:%d\n",
			__func__, buflen, req_buflen, -QDMA_ERR_NO_MEM);
		return -QDMA_ERR_NO_MEM;
	}

	qdma_memset(&context, 0, sizeof(struct qdma_descq_context));

	if (q_type != QDMA_DEV_Q_TYPE_CMPT) {
		rv = eqdma_sw_ctx_conf(dev_hndl, (uint8_t)q_type, qid_hw,
				&(context.sw_ctxt), QDMA_HW_ACCESS_READ);
		if (rv < 0) {
			qdma_log_error(
			"%s: Failed to read sw context, err = %d",
					__func__, rv);
			return rv;
		}

		rv = eqdma_hw_ctx_conf(dev_hndl, (uint8_t)q_type, qid_hw,
				&(context.hw_ctxt), QDMA_HW_ACCESS_READ);
		if (rv < 0) {
			qdma_log_error(
			"%s: Failed to read hw context, err = %d",
					__func__, rv);
			return rv;
		}

		rv = eqdma_credit_ctx_conf(dev_hndl, (uint8_t)q_type,
				qid_hw, &(context.cr_ctxt),
				QDMA_HW_ACCESS_READ);
		if (rv < 0) {
			qdma_log_error(
			"%s: Failed to read credit context, err = %d",
					__func__, rv);
			return rv;
		}

		if (st && (q_type == QDMA_DEV_Q_TYPE_C2H)) {
			rv = eqdma_pfetch_ctx_conf(dev_hndl,
					qid_hw,
					&(context.pfetch_ctxt),
					QDMA_HW_ACCESS_READ);
			if (rv < 0) {
				qdma_log_error(
			"%s: Failed to read pftech context, err = %d",
						__func__, rv);
				return rv;
			}
		}
	}

	if ((st && (q_type == QDMA_DEV_Q_TYPE_C2H)) ||
			(!st && (q_type == QDMA_DEV_Q_TYPE_CMPT))) {
		rv = eqdma_cmpt_ctx_conf(dev_hndl, qid_hw,
						&(context.cmpt_ctxt),
						 QDMA_HW_ACCESS_READ);
		if (rv < 0) {
			qdma_log_error(
			"%s: Failed to read cmpt context, err = %d",
					__func__, rv);
			return rv;
		}
	}


	rv = dump_eqdma_context(&context, st, q_type,
				buf, buflen);

	return rv;
}

/*****************************************************************************/
/**
 * eqdma_get_user_bar() - Function to get the user bar number
 *
 * @dev_hndl:	device handle
 * @is_vf:	Whether PF or VF
 * @func_id:	function id of the PF
 * @user_bar:	pointer to hold the user bar number
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_get_user_bar(void *dev_hndl, uint8_t is_vf,
		uint8_t func_id, uint8_t *user_bar)
{
	uint8_t bar_found = 0;
	uint8_t bar_idx = 0;
	uint32_t user_bar_id = 0;
	uint32_t reg_addr = (is_vf) ?  EQDMA_OFFSET_VF_USER_BAR :
			QDMA_OFFSET_GLBL2_PF_BARLITE_EXT;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
					__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (!user_bar) {
		qdma_log_error("%s: user bar is NULL, err:%d\n",
					__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	user_bar_id = qdma_reg_read(dev_hndl, reg_addr);
	user_bar_id = (user_bar_id >> (6 * func_id)) & 0x3F;

	for (bar_idx = 0; bar_idx < QDMA_BAR_NUM; bar_idx++) {
		if (user_bar_id & (1 << bar_idx)) {
			*user_bar = bar_idx;
			bar_found = 1;
			break;
		}
	}
	if (bar_found == 0) {
		*user_bar = 0;
		qdma_log_error("%s: Bar not found, err:%d\n",
					__func__,
					-QDMA_ERR_HWACC_BAR_NOT_FOUND);
		return -QDMA_ERR_HWACC_BAR_NOT_FOUND;
	}

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_hw_get_error_name() - Function to get the error in string format
 *
 * @err_idx: error index
 *
 * Return: string - success and NULL on failure
 *****************************************************************************/
const char *eqdma_hw_get_error_name(uint32_t err_idx)
{
	if (err_idx >= EQDMA_ERRS_ALL) {
		qdma_log_error("%s: err_idx=%d is invalid, returning NULL\n",
				__func__, (enum eqdma_error_idx)err_idx);
		return NULL;
	}

	return eqdma_err_info[(enum eqdma_error_idx)err_idx].err_name;
}

/*****************************************************************************/
/**
 * eqdma_hw_error_process() - Function to find the error that got
 * triggered and call the handler qdma_hw_error_handler of that
 * particular error.
 *
 * @dev_hndl: device handle
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_hw_error_process(void *dev_hndl)
{
	uint32_t glbl_err_stat = 0, err_stat = 0;
	uint32_t bit = 0, i = 0;
	int32_t idx = 0;
	struct qdma_dev_attributes *dev_cap;
	uint32_t hw_err_position[EQDMA_TOTAL_LEAF_ERROR_AGGREGATORS] = {
		EQDMA_DSC_ERR_POISON,
		EQDMA_TRQ_ERR_CSR_UNMAPPED,
		EQDMA_ST_C2H_ERR_MTY_MISMATCH,
		EQDMA_ST_FATAL_ERR_MTY_MISMATCH,
		EQDMA_ST_H2C_ERR_ZERO_LEN_DESC,
		EQDMA_SBE_1_ERR_RC_RRQ_EVEN_RAM,
		EQDMA_SBE_ERR_MI_H2C0_DAT,
		EQDMA_DBE_1_ERR_RC_RRQ_EVEN_RAM,
		EQDMA_DBE_ERR_MI_H2C0_DAT
	};

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	qdma_get_device_attr(dev_hndl, &dev_cap);

	glbl_err_stat = qdma_reg_read(dev_hndl, QDMA_OFFSET_GLBL_ERR_STAT);
	if (!glbl_err_stat)
		return QDMA_HW_ERR_NOT_DETECTED;

	for (i = 0; i < EQDMA_TOTAL_LEAF_ERROR_AGGREGATORS; i++) {
		bit = hw_err_position[i];

		if ((!dev_cap->st_en) && (bit == QDMA_ST_C2H_ERR_MTY_MISMATCH ||
				bit == QDMA_ST_FATAL_ERR_MTY_MISMATCH ||
				bit == QDMA_ST_H2C_ERR_ZERO_LEN_DESC))
			continue;

		err_stat = qdma_reg_read(dev_hndl,
				eqdma_err_info[bit].stat_reg_addr);
		if (err_stat)
			qdma_reg_write(dev_hndl,
					eqdma_err_info[bit].stat_reg_addr,
					err_stat);
		else
			continue;

		pr_info("%s: err_stat 0x%x = 0x%x.\n", __func__,
			eqdma_err_info[bit].stat_reg_addr, err_stat);

		for (idx = bit; idx < all_eqdma_hw_errs[i]; idx++) {
			/* call the platform specific handler */
			if (err_stat & eqdma_err_info[idx].leaf_err_mask)
				qdma_hw_error_handler(dev_hndl,
						(enum qdma_error_idx)idx);
		}
	}

	/* Write 1 to the global status register to clear the bits */
	qdma_reg_write(dev_hndl, QDMA_OFFSET_GLBL_ERR_STAT, glbl_err_stat);

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * qdma_hw_error_enable() - Function to enable all or a specific error
 *
 * @dev_hndl: device handle
 * @err_idx: error index
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_hw_error_enable(void *dev_hndl, uint32_t err_idx)
{
	uint32_t idx = 0, i = 0;
	uint32_t reg_val = 0;
	struct qdma_dev_attributes *dev_cap;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (err_idx > EQDMA_ERRS_ALL) {
		qdma_log_error("%s: err_idx=%d is invalid, err:%d\n",
				__func__, (enum eqdma_error_idx)err_idx,
				-QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	qdma_get_device_attr(dev_hndl, &dev_cap);

	if (err_idx == EQDMA_ERRS_ALL) {
		for (i = 0; i < TOTAL_LEAF_ERROR_AGGREGATORS; i++) {

			idx = all_eqdma_hw_errs[i];

			/* Don't access streaming registers in
			 * MM only bitstreams
			 */
			if (!dev_cap->st_en) {
				if (idx == EQDMA_ST_C2H_ERR_ALL ||
					idx == EQDMA_ST_FATAL_ERR_ALL ||
					idx == EQDMA_ST_H2C_ERR_ALL)
					continue;
			}

			reg_val = eqdma_err_info[idx].leaf_err_mask;
			qdma_reg_write(dev_hndl,
				eqdma_err_info[idx].mask_reg_addr, reg_val);

			reg_val = qdma_reg_read(dev_hndl,
					EQDMA_OFFSET_GLBL_ERR_MASK);
			reg_val |= FIELD_SET(
				eqdma_err_info[idx].global_err_mask, 1);
			qdma_reg_write(dev_hndl, EQDMA_OFFSET_GLBL_ERR_MASK,
					reg_val);
		}

	} else {
		/* Don't access streaming registers in MM only bitstreams
		 *  QDMA_C2H_ERR_MTY_MISMATCH to QDMA_H2C_ERR_ALL are all
		 *  ST errors
		 */
		if (!dev_cap->st_en) {
			if (err_idx >= EQDMA_ST_C2H_ERR_MTY_MISMATCH &&
					err_idx <= EQDMA_ST_H2C_ERR_ALL)
				return QDMA_SUCCESS;
		}

		reg_val = qdma_reg_read(dev_hndl,
				eqdma_err_info[err_idx].mask_reg_addr);
		reg_val |= FIELD_SET(eqdma_err_info[err_idx].leaf_err_mask, 1);
		qdma_reg_write(dev_hndl,
				eqdma_err_info[err_idx].mask_reg_addr, reg_val);

		reg_val = qdma_reg_read(dev_hndl, EQDMA_OFFSET_GLBL_ERR_MASK);
		reg_val |=
			FIELD_SET(eqdma_err_info[err_idx].global_err_mask, 1);
		qdma_reg_write(dev_hndl, EQDMA_OFFSET_GLBL_ERR_MASK, reg_val);
	}

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_get_device_attributes() - Function to get the qdma device
 * attributes
 *
 * @dev_hndl:	device handle
 * @dev_info:	pointer to hold the device info
 *
 * Return:	0   - success and < 0 - failure
 *****************************************************************************/
int eqdma_get_device_attributes(void *dev_hndl,
		struct qdma_dev_attributes *dev_info)
{
	uint8_t count = 0;
	uint32_t reg_val = 0;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}
	if (!dev_info) {
		qdma_log_error("%s: dev_info is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}


	/* number of PFs */
	reg_val = qdma_reg_read(dev_hndl, QDMA_OFFSET_GLBL2_PF_BARLITE_INT);
	if (FIELD_GET(QDMA_GLBL2_PF0_BAR_MAP_MASK, reg_val))
		count++;
	if (FIELD_GET(QDMA_GLBL2_PF1_BAR_MAP_MASK, reg_val))
		count++;
	if (FIELD_GET(QDMA_GLBL2_PF2_BAR_MAP_MASK, reg_val))
		count++;
	if (FIELD_GET(QDMA_GLBL2_PF3_BAR_MAP_MASK, reg_val))
		count++;
	dev_info->num_pfs = count;

	/* Number of Qs */
	reg_val = qdma_reg_read(dev_hndl, QDMA_OFFSET_GLBL2_CHANNEL_QDMA_CAP);
	dev_info->num_qs = FIELD_GET(QDMA_GLBL2_MULTQ_MAX_MASK, reg_val);

	/* FLR present */
	reg_val = qdma_reg_read(dev_hndl, QDMA_OFFSET_GLBL2_MISC_CAP);
	dev_info->mailbox_en  = FIELD_GET(QDMA_GLBL2_MAILBOX_EN_MASK, reg_val);
	dev_info->flr_present = FIELD_GET(QDMA_GLBL2_FLR_PRESENT_MASK, reg_val);
	dev_info->mm_cmpt_en  = FIELD_GET(QDMA_GLBL2_MM_CMPT_EN_MASK, reg_val);

	/* ST/MM enabled? */
	reg_val = qdma_reg_read(dev_hndl, QDMA_OFFSET_GLBL2_CHANNEL_MDMA);
	dev_info->mm_en = (FIELD_GET(QDMA_GLBL2_MM_C2H_MASK, reg_val)
			&& FIELD_GET(QDMA_GLBL2_MM_H2C_MASK, reg_val)) ? 1 : 0;
	dev_info->st_en = (FIELD_GET(QDMA_GLBL2_ST_C2H_MASK, reg_val)
			&& FIELD_GET(QDMA_GLBL2_ST_H2C_MASK, reg_val)) ? 1 : 0;

	/* num of mm channels */
	/* TODO : Register not yet defined for this. Hard coding it to 1.*/
	dev_info->mm_channel_max = 1;

	dev_info->qid2vec_ctx = 0;
	dev_info->cmpt_ovf_chk_dis = 1;
	dev_info->mailbox_intr = 1;
	dev_info->sw_desc_64b = 1;
	dev_info->cmpt_desc_64b = 1;
	dev_info->dynamic_bar = 1;
	dev_info->legacy_intr = 1;
	dev_info->cmpt_trig_count_timer = 1;

	return QDMA_SUCCESS;
}

/*****************************************************************************/
/**
 * eqdma_init_ctxt_memory() - function to initialize the context memory
 *
 * @dev_hndl: device handle
 *
 * Return: returns the platform specific error code
 *****************************************************************************/
int eqdma_init_ctxt_memory(void *dev_hndl)
{
#ifdef ENABLE_INIT_CTXT_MEMORY
	uint32_t data[QDMA_REG_IND_CTXT_REG_COUNT];
	uint16_t i = 0;
	struct qdma_dev_attributes dev_info;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
					__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	qdma_memset(data, 0, sizeof(uint32_t) * QDMA_REG_IND_CTXT_REG_COUNT);
	eqdma_get_device_attributes(dev_hndl, &dev_info);

	for (; i < dev_info.num_qs; i++) {
		int sel = QDMA_CTXT_SEL_SW_C2H;
		int rv;

		for (; sel <= QDMA_CTXT_SEL_PFTCH; sel++) {
			/** if the st mode(h2c/c2h) not enabled
			 *  in the design, then skip the PFTCH
			 *  and CMPT context setup
			 */
			if ((dev_info.st_en == 0) &&
			    ((sel == QDMA_CTXT_SEL_PFTCH) ||
				(sel == QDMA_CTXT_SEL_CMPT))) {
				qdma_log_debug("%s: ST context is skipped:",
					__func__);
				qdma_log_debug("sel = %d\n", sel);
				continue;
			}

			rv = eqdma_indirect_reg_clear(dev_hndl,
					(enum ind_ctxt_cmd_sel)sel, i);
			if (rv < 0)
				return rv;
		}
	}

	/* fmap */
	for (i = 0; i < dev_info.num_pfs; i++)
		eqdma_indirect_reg_clear(dev_hndl,
				QDMA_CTXT_SEL_FMAP, i);

#else
	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
					__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}
#endif
	return QDMA_SUCCESS;

}


static int get_reg_entry(uint32_t reg_addr, int *reg_entry)
{
	uint32_t i = 0;
	struct xreg_info *reg_info;
	uint32_t num_regs =
		sizeof(eqdma_config_regs)/
		sizeof((eqdma_config_regs)[0]);

	reg_info = eqdma_config_regs;

	for (i = 0; (i < num_regs - 1); i++) {
		if (reg_info[i].addr == reg_addr) {
			*reg_entry = i;
			break;
		}
	}

	if (i >= num_regs - 1) {
		qdma_log_error("%s: 0x%08x is missing register list, err:%d\n",
					__func__,
					reg_addr,
					-QDMA_ERR_INV_PARAM);
		*reg_entry = -1;
		return -QDMA_ERR_INV_PARAM;
	}

	return 0;
}

/*****************************************************************************/
/**
 * eqdma_dump_config_reg_list() - Dump the registers
 *
 * @dev_hndl:		device handle
 * @total_regs :	Max registers to read
 * @reg_list :		array of reg addr and reg values
 * @buf :		pointer to buffer to be filled
 * @buflen :		Length of the buffer
 *
 * Return: returns the platform specific error code
 *****************************************************************************/
int eqdma_dump_config_reg_list(void *dev_hndl, uint32_t total_regs,
		struct qdma_reg_data *reg_list, char *buf, uint32_t buflen)
{
	uint32_t j = 0, len = 0;
	uint32_t reg_count = 0;
	int reg_data_entry;
	int rv = 0;
	char name[DEBGFS_GEN_NAME_SZ] = "";
	struct xreg_info *reg_info = eqdma_config_regs;

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (!buf) {
		qdma_log_error("%s: buf is NULL, err:%d\n",
				__func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	for (reg_count = 0;
			(reg_count < total_regs);) {

		rv = get_reg_entry(reg_list[reg_count].reg_addr,
					&reg_data_entry);
		if (rv < 0) {
			qdma_log_error("%s: register missing in list, err:%d\n",
						   __func__,
						   -QDMA_ERR_INV_PARAM);
			return rv;
		}

		for (j = 0; j < reg_info[reg_data_entry].repeat; j++) {
			rv = QDMA_SNPRINTF_S(name, DEBGFS_GEN_NAME_SZ,
					DEBGFS_GEN_NAME_SZ,
					"%s_%d",
					reg_info[reg_data_entry].name, j);
			if (rv < 0) {
				qdma_log_error(
					"%d:%s snprintf failed, err:%d\n",
					__LINE__, __func__,
					rv);
				return -QDMA_ERR_NO_MEM;
			}
			rv = dump_reg(buf + len, buflen - len,
				(reg_info[reg_data_entry].addr + (j * 4)),
					name,
					reg_list[reg_count + j].reg_val);
			if (rv < 0) {
				qdma_log_error(
				"%s Buff too small, err:%d\n",
				__func__,
				-QDMA_ERR_NO_MEM);
				return -QDMA_ERR_NO_MEM;
			}
			len += rv;
		}
		reg_count += j;
	}

	return len;

}


/*****************************************************************************/
/**
 * qdma_read_reg_list() - read the register values
 *
 * @dev_hndl:		device handle
 * @is_vf:		Whether PF or VF
 * @total_regs :	Max registers to read
 * @reg_list :		array of reg addr and reg values
 *
 * Return: returns the platform specific error code
 *****************************************************************************/
int eqdma_read_reg_list(void *dev_hndl, uint8_t is_vf,
		uint16_t reg_rd_group,
		uint16_t *total_regs,
		struct qdma_reg_data *reg_list)
{
	uint16_t reg_count = 0, i = 0, j = 0;
	struct xreg_info *reg_info;
	uint32_t num_regs =
		sizeof(eqdma_config_regs)/
		sizeof((eqdma_config_regs)[0]);
	struct qdma_dev_attributes *dev_cap;
	uint32_t reg_start_addr = 0;
	int reg_index = 0;
	int rv = 0;

	if (!is_vf) {
		qdma_log_error("%s: not supported for PF, err:%d\n",
				__func__,
				-QDMA_ERR_HWACC_FEATURE_NOT_SUPPORTED);
		return -QDMA_ERR_HWACC_FEATURE_NOT_SUPPORTED;
	}

	if (!dev_hndl) {
		qdma_log_error("%s: dev_handle is NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	if (!reg_list) {
		qdma_log_error("%s: reg_list is NULL, err:%d\n",
					   __func__, -QDMA_ERR_INV_PARAM);
		return -QDMA_ERR_INV_PARAM;
	}

	qdma_get_device_attr(dev_hndl, &dev_cap);

	switch (reg_rd_group) {
	case QDMA_REG_READ_GROUP_1:
			reg_start_addr = EQDMA_REG_GROUP_1_START_ADDR;
			break;
	case QDMA_REG_READ_GROUP_2:
			reg_start_addr = EQDMA_REG_GROUP_2_START_ADDR;
			break;
	case QDMA_REG_READ_GROUP_3:
			reg_start_addr = EQDMA_REG_GROUP_3_START_ADDR;
			break;
	case QDMA_REG_READ_GROUP_4:
			reg_start_addr = EQDMA_REG_GROUP_4_START_ADDR;
			break;
	default:
		qdma_log_error("%s: Invalid slot received\n",
			   __func__);
		return -QDMA_ERR_INV_PARAM;
	}

	rv = get_reg_entry(reg_start_addr, &reg_index);
	if (rv < 0) {
		qdma_log_error("%s: register missing in list, err:%d\n",
					   __func__,
					   -QDMA_ERR_INV_PARAM);
		return rv;
	}
	reg_info = &eqdma_config_regs[reg_index];

	for (i = 0, reg_count = 0;
			((i < num_regs - 1 - reg_index) &&
			(reg_count < QDMA_MAX_REGISTER_DUMP)); i++) {

		if (((GET_CAPABILITY_MASK(dev_cap->mm_en, dev_cap->st_en,
				dev_cap->mm_cmpt_en, dev_cap->mailbox_en)
				& reg_info[i].mode) == 0) ||
			(reg_info[i].read_type == QDMA_REG_READ_PF_ONLY))
			continue;

		for (j = 0; j < reg_info[i].repeat &&
				(reg_count < QDMA_MAX_REGISTER_DUMP);
				j++) {
			reg_list[reg_count].reg_addr =
					(reg_info[i].addr + (j * 4));
			reg_list[reg_count].reg_val =
				qdma_reg_read(dev_hndl,
					reg_list[reg_count].reg_addr);
			reg_count++;
		}
	}

	*total_regs = reg_count;
	return rv;
}

