.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
klein - Draws a 4d Klein bottle.
.SH SYNOPSIS
.B klein
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-klein-bottle \fIbottle-name\fP]
[-figure-8]
[-squeezed-torus]
[-lawson]
[\-mode \fIdisplay-mode\fP]
[\-wireframe]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-bands]
[\-colors \fIcolor-scheme\fP]
[\-twosided]
[\-rainbow]
[\-depth]
[\-view-mode \fIview-mode\fP]
[\-walk]
[\-turn]
[\-walk-turn]
[\-orientation-marks]
[\-projection-3d \fImode\fP]
[\-perspective-3d]
[\-orthographic-3d]
[\-projection-4d \fImode\fP]
[\-perspective-4d]
[\-orthographic-4d]
[\-speed-wx \fIfloat\fP]
[\-speed-wy \fIfloat\fP]
[\-speed-wz \fIfloat\fP]
[\-speed-xy \fIfloat\fP]
[\-speed-xz \fIfloat\fP]
[\-speed-yz \fIfloat\fP]
[\-walk-direction \fIfloat\fP]
[\-walk-speed \fIfloat\fP]
.SH DESCRIPTION
The \fIklein\fP program shows three different Klein bottles in 4d: the
figure-8 Klein bottle, the squeezed torus Klein bottle, or the Lawson
Klein bottle.  You can walk on the Klein bottle, see it turn in 4d, or
walk on it while it turns in 4d.  The figure-8 Klein bottle is well
known in its 3d form.  The 4d form used in this program is an
extension of the 3d form to 4d that does not intersect itself in 4d
(which can be seen in the depth colors mode).  The squeezed torus
Klein bottle also does not intersect itself in 4d (which can be seen
in the depth colors mode).  The Lawson Klein bottle, on the other
hand, does intersect itself in 4d.  Its primary use is that it has a
nice appearance for walking and for turning in 3d.  The Klein bottle
is a non-orientable surface.  To make this apparent, the two-sided
color mode can be used.  Alternatively, orientation markers (curling
arrows) can be drawn as a texture map on the surface of the Klein
bottle.  While walking on the Klein bottle, you will notice that the
orientation of the curling arrows changes (which it must because the
Klein bottle is non-orientable).  The program projects the 4d Klein
bottle to 3d using either a perspective or an orthographic projection.
Which of the two alternatives looks more appealing depends on the
viewing mode and the Klein bottle.  For example, the Lawson Klein
bottle looks nicest when projected perspectively.  The figure-8 Klein
bottle, on the other hand, looks nicer while walking when projected
orthographically from 4d.  For the squeezed torus Klein bottle, both
projection modes give equally acceptable projections.  The projected
Klein bottle can then be projected to the screen either perspectively
or orthographically.  When using the walking modes, perspective
projection to the screen should be used.  There are three display
modes for the Klein bottle: mesh (wireframe), solid, or transparent.
Furthermore, the appearance of the Klein bottle can be as a solid
object or as a set of see-through bands.  Finally, the colors with
with the Klein bottle is drawn can be set to two-sided, rainbow, or
depth.  In the first case, the Klein bottle is drawn with red on one
"side" and green on the "other side".  Of course, the Klein bottle
only has one side, so the color jumps from red to green along a curve
on the surface of the Klein bottle.  This mode enables you to see that
the Klein bottle is non-orientable.  The second mode draws the Klein
bottle with fully saturated rainbow colors.  This gives a very nice
effect when combined with the see-through bands mode or with the
orientation markers drawn.  The third mode draws the Klein bottle with
colors that are chosen according to the 4d "depth" of the points.
This mode enables you to see that the figure-8 and squeezed torus
Klein bottles do not intersect themselves in 4d, while the Lawson
Klein bottle does intersect itself.  The rotation speed for each of
the six planes around which the Klein bottle rotates can be chosen.
For the walk-and-turn more, only the rotation speeds around the true
4d planes are used (the xy, xz, and yz planes).  Furthermore, in the
walking modes the walking direction in the 2d base square of the Klein
bottle and the walking speed can be chosen.  This program is somewhat
inspired by Thomas Banchoff's book "Beyond the Third Dimension:
Geometry, Computer Graphics, and Higher Dimensions", Scientific
American Library, 1990.
.SH OPTIONS
.I klein
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following three options are mutually exclusive.  They determine
which Klein bottle is displayed.
.TP 8
.B \-klein-bottle random
Display a random Klein bottle (default).
.TP 8
.B \-klein-bottle figure-8 \fP(Shortcut: \fB\-figure-8\fP)
Display the figure-8 Klein bottle.
.TP 8
.B \-klein-bottle squeezed-torus \fP(Shortcut: \fB\-squeezed-torus\fP)
Display the squeezed torus Klein bottle.
.TP 8
.B \-klein-bottle lawson \fP(Shortcut: \fB\-lawson\fP)
Display the Lawson Klein bottle.
.PP
The following four options are mutually exclusive.  They determine
how the Klein bottle is displayed.
.TP 8
.B \-mode random
Display the Klein bottle in a random display mode (default).
.TP 8
.B \-mode wireframe \fP(Shortcut: \fB\-wireframe\fP)
Display the Klein bottle as a wireframe mesh.
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the Klein bottle as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the Klein bottle as a transparent surface.
.PP
The following three options are mutually exclusive.  They determine the
appearance of the Klein bottle.
.TP 8
.B \-appearance random
Display the Klein bottle with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the Klein bottle as a solid object.
.TP 8
.B \-appearance bands \fP(Shortcut: \fB\-bands\fP)
Display the Klein bottle as see-through bands.
.PP
The following four options are mutually exclusive.  They determine
how to color the Klein bottle.
.TP 8
.B \-colors random
Display the Klein bottle with a random color scheme (default).
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided\fP)
Display the Klein bottle with two colors: red on one "side" and green
on the "other side".
.TP 8
.B \-colors rainbow \fP(Shortcut: \fB\-rainbow\fP)
Display the Klein bottle with fully saturated rainbow colors.  If the
Klein bottle is displayed as see-through bands, each band will be
displayed with a different color.
.TP 8
.B \-colors depth \fP(Shortcut: \fB\-depth\fP)
Display the Klein bottle with colors chosen depending on the 4d
"depth" of the points.
.PP
The following four options are mutually exclusive.  They determine
how to view the Klein bottle.
.TP 8
.B \-view-mode random
View the Klein bottle in a random view mode (default).
.TP 8
.B \-view-mode walk \fP(Shortcut: \fB\-walk\fP)
View the Klein bottle as if walking on its surface.
.TP 8
.B \-view-mode turn \fP(Shortcut: \fB\-turn\fP)
View the Klein bottle while it turns in 4d.
.TP 8
.B \-view-mode walk-turn \fP(Shortcut: \fB\-walk-turn\fP)
View the Klein bottle as if walking on its surface.  Additionally, the
Klein bottle turns around the true 4d planes (the xy, xz, and yz
planes).
.PP
The following options determine whether orientation marks are shown on
the Klein bottle.
.TP 8
.B \-orientation-marks
Display orientation marks on the Klein bottle.
.TP 8
.B \-no-orientation-marks
Don't display orientation marks on the Klein bottle (default).
.PP
The following three options are mutually exclusive.  They determine
how the Klein bottle is projected from 3d to 2d (i.e., to the screen).
.TP 8
.B \-projection-3d random
Project the Klein bottle from 3d to 2d using a random projection mode
(default).
.TP 8
.B \-projection-3d perspective \fP(Shortcut: \fB\-perspective-3d\fP)
Project the Klein bottle from 3d to 2d using a perspective projection.
.TP 8
.B \-projection-3d orthographic \fP(Shortcut: \fB\-orthographic-3d\fP)
Project the Klein bottle from 3d to 2d using an orthographic
projection.
.PP
The following three options are mutually exclusive.  They determine
how the Klein bottle is projected from 4d to 3d.
.TP 8
.B \-projection-4d random
Project the Klein bottle from 4d to 3d using a random projection mode
(default).
.TP 8
.B \-projection-4d perspective \fP(Shortcut: \fB\-perspective-4d\fP)
Project the Klein bottle from 4d to 3d using a perspective projection.
.TP 8
.B \-projection-4d orthographic \fP(Shortcut: \fB\-orthographic-4d\fP)
Project the Klein bottle from 4d to 3d using an orthographic
projection.
.PP
The following six options determine the rotation speed of the Klein
bottle around the six possible hyperplanes.  The rotation speed is
measured in degrees per frame.  The speeds should be set to relatively
small values, e.g., less than 4 in magnitude.  In walk mode, all
speeds are ignored.  In walk-and-turn mode, the 3d rotation speeds are
ignored (i.e., the wx, wy, and wz speeds).  In walk-and-turn mode,
smaller speeds must be used than in the turn mode to achieve a nice
visualization.  Therefore, in walk-and-turn mode the speeds you have
selected are divided by 5 internally.
.TP 8
.B \-speed-wx \fIfloat\fP
Rotation speed around the wx plane (default: 1.1).
.TP 8
.B \-speed-wy \fIfloat\fP
Rotation speed around the wy plane (default: 1.3).
.TP 8
.B \-speed-wz \fIfloat\fP
Rotation speed around the wz plane (default: 1.5).
.TP 8
.B \-speed-xy \fIfloat\fP
Rotation speed around the xy plane (default: 1.7).
.TP 8
.B \-speed-xz \fIfloat\fP
Rotation speed around the xz plane (default: 1.9).
.TP 8
.B \-speed-yz \fIfloat\fP
Rotation speed around the yz plane (default: 2.1).
.PP
The following two options determine the walking speed and direction.
.TP 8
.B \-walk-direction \fIfloat\fP
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the Klein
bottle (default: 7.0).
.TP 8
.B \-walk-speed \fIfloat\fP
The walking speed is measured in percent of some sensible maximum
speed (default: 20.0).
.SH INTERACTION
If you run this program in standalone mode in its turn mode, you can
rotate the Klein bottle by dragging the mouse while pressing the left
mouse button.  This rotates the Klein bottle in 3D, i.e., around the
wx, wy, and wz planes.  If you press the shift key while dragging the
mouse with the left button pressed the Klein bottle is rotated in 4D,
i.e., around the xy, xz, and yz planes.  To examine the Klein bottle
at your leisure, it is best to set all speeds to 0.  Otherwise, the
Klein bottle will rotate while the left mouse button is not pressed.
This kind of interaction is not available in the two walk modes.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2005-2013 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 25-dec-2013.
