/* $XFree86: xc/programs/Xserver/GL/glx/g_renderswap.c,v 1.5 2002/01/14 22:47:08 tsi Exp $ */
/*
** License Applicability. Except to the extent portions of this file are
** made subject to an alternative license as permitted in the SGI Free
** Software License B, Version 1.1 (the "License"), the contents of this
** file are subject only to the provisions of the License. You may not use
** this file except in compliance with the License. You may obtain a copy
** of the License at Silicon Graphics, Inc., attn: Legal Services, 1600
** Amphitheatre Parkway, Mountain View, CA 94043-1351, or at:
** 
** http://oss.sgi.com/projects/FreeB
** 
** Note that, as provided in the License, the Software is distributed on an
** "AS IS" basis, with ALL EXPRESS AND IMPLIED WARRANTIES AND CONDITIONS
** DISCLAIMED, INCLUDING, WITHOUT LIMITATION, ANY IMPLIED WARRANTIES AND
** CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY, FITNESS FOR A
** PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
** 
** Original Code. The Original Code is: OpenGL Sample Implementation,
** Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
** Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
** Copyright in any portions created by third parties is as indicated
** elsewhere herein. All Rights Reserved.
** 
** Additional Notice Provisions: This software was created using the
** OpenGL(R) version 1.2.1 Sample Implementation published by SGI, but has
** not been independently verified as being compliant with the OpenGL(R)
** version 1.2.1 Specification.
*/

#define NEED_REPLIES
#include "glxserver.h"
#include "glxext.h"
#include "g_disptab.h"
#include "g_disptab_EXT.h"
#include "unpack.h"
#include "impsize.h"
#include "singlesize.h"

void __glXDispSwap_CallList(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->CallList)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_ListBase(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ListBase)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_Begin(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->Begin)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_Color3bv(GLbyte *pc)
{
	(*__glRenderTable->Color3bv)( 
		(GLbyte   *)(pc + 0)
	);
}

void __glXDispSwap_Color3dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Color3fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Color3iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Color3sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Color3ubv(GLbyte *pc)
{
	(*__glRenderTable->Color3ubv)( 
		(GLubyte  *)(pc + 0)
	);
}

void __glXDispSwap_Color3uiv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3uiv)( 
		(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_Color3usv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Color3usv)( 
		(GLushort *)(pc + 0)
	);
}

void __glXDispSwap_Color4bv(GLbyte *pc)
{
	(*__glRenderTable->Color4bv)( 
		(GLbyte   *)(pc + 0)
	);
}

void __glXDispSwap_Color4dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Color4fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Color4iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Color4sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Color4ubv(GLbyte *pc)
{
	(*__glRenderTable->Color4ubv)( 
		(GLubyte  *)(pc + 0)
	);
}

void __glXDispSwap_Color4uiv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4uiv)( 
		(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_Color4usv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Color4usv)( 
		(GLushort *)(pc + 0)
	);
}

void __glXDispSwap_EdgeFlagv(GLbyte *pc)
{
	(*__glRenderTable->EdgeFlagv)( 
		(GLboolean *)(pc + 0)
	);
}

void __glXDispSwap_End(GLbyte *pc)
{
	(*__glRenderTable->End)( 
	);
}

void __glXDispSwap_Indexdv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 8);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 1);

	(*__glRenderTable->Indexdv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Indexfv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 1);

	(*__glRenderTable->Indexfv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Indexiv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 1);

	(*__glRenderTable->Indexiv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Indexsv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 1);

	(*__glRenderTable->Indexsv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Normal3bv(GLbyte *pc)
{
	(*__glRenderTable->Normal3bv)( 
		(GLbyte   *)(pc + 0)
	);
}

void __glXDispSwap_Normal3dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTable->Normal3dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Normal3fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Normal3fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Normal3iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Normal3iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Normal3sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Normal3sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos2dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);

	(*__glRenderTable->RasterPos2dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos2fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 2);

	(*__glRenderTable->RasterPos2fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos2iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 2);

	(*__glRenderTable->RasterPos2iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos2sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 2);

	(*__glRenderTable->RasterPos2sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos3dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTable->RasterPos3dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos3fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 3);

	(*__glRenderTable->RasterPos3fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos3iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->RasterPos3iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos3sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->RasterPos3sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos4dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTable->RasterPos4dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos4fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 4);

	(*__glRenderTable->RasterPos4fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos4iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 4);

	(*__glRenderTable->RasterPos4iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_RasterPos4sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 4);

	(*__glRenderTable->RasterPos4sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Rectdv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 16, 2);

	(*__glRenderTable->Rectdv)( 
		(GLdouble *)(pc + 0),
		(GLdouble *)(pc + 16)
	);
}

void __glXDispSwap_Rectfv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 2);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, 2);

	(*__glRenderTable->Rectfv)( 
		(GLfloat  *)(pc + 0),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Rectiv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 2);
	__GLX_SWAP_INT_ARRAY(pc + 8, 2);

	(*__glRenderTable->Rectiv)( 
		(GLint    *)(pc + 0),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_Rectsv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 2);
	__GLX_SWAP_SHORT_ARRAY(pc + 4, 2);

	(*__glRenderTable->Rectsv)( 
		(GLshort  *)(pc + 0),
		(GLshort  *)(pc + 4)
	);
}

void __glXDispSwap_TexCoord1dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 8);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 1);

	(*__glRenderTable->TexCoord1dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord1fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 1);

	(*__glRenderTable->TexCoord1fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord1iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 1);

	(*__glRenderTable->TexCoord1iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord1sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 1);

	(*__glRenderTable->TexCoord1sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord2dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);

	(*__glRenderTable->TexCoord2dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord2fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 2);

	(*__glRenderTable->TexCoord2fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord2iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 2);

	(*__glRenderTable->TexCoord2iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord2sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 2);

	(*__glRenderTable->TexCoord2sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord3dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTable->TexCoord3dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord3fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 3);

	(*__glRenderTable->TexCoord3fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord3iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->TexCoord3iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord3sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->TexCoord3sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord4dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTable->TexCoord4dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord4fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 4);

	(*__glRenderTable->TexCoord4fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord4iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 4);

	(*__glRenderTable->TexCoord4iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_TexCoord4sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 4);

	(*__glRenderTable->TexCoord4sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex2dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);

	(*__glRenderTable->Vertex2dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Vertex2fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 2);

	(*__glRenderTable->Vertex2fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex2iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 2);

	(*__glRenderTable->Vertex2iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Vertex2sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 2);

	(*__glRenderTable->Vertex2sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex3dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTable->Vertex3dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Vertex3fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Vertex3fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex3iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Vertex3iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Vertex3sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 3);

	(*__glRenderTable->Vertex3sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex4dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTable->Vertex4dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Vertex4fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Vertex4fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Vertex4iv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Vertex4iv)( 
		(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_Vertex4sv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_SHORT_ARRAY(pc + 0, 4);

	(*__glRenderTable->Vertex4sv)( 
		(GLshort  *)(pc + 0)
	);
}

void __glXDispSwap_ClipPlane(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 36);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 32);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTable->ClipPlane)( 
		*(GLenum   *)(pc + 32),
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_ColorMaterial(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->ColorMaterial)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4)
	);
}

void __glXDispSwap_CullFace(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->CullFace)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_Fogf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->Fogf)( 
		*(GLenum   *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_Fogfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	pname = *(GLenum *)(pc + 0);
	compsize = __glFogfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, compsize);

	(*__glRenderTable->Fogfv)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_Fogi(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->Fogi)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_Fogiv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	pname = *(GLenum *)(pc + 0);
	compsize = __glFogiv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT_ARRAY(pc + 4, compsize);

	(*__glRenderTable->Fogiv)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_FrontFace(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->FrontFace)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_Hint(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->Hint)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4)
	);
}

void __glXDispSwap_Lightf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->Lightf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Lightfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glLightfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->Lightfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Lighti(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->Lighti)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_Lightiv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glLightiv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->Lightiv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_LightModelf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->LightModelf)( 
		*(GLenum   *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_LightModelfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	pname = *(GLenum *)(pc + 0);
	compsize = __glLightModelfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, compsize);

	(*__glRenderTable->LightModelfv)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_LightModeli(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->LightModeli)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_LightModeliv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	pname = *(GLenum *)(pc + 0);
	compsize = __glLightModeliv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT_ARRAY(pc + 4, compsize);

	(*__glRenderTable->LightModeliv)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_LineStipple(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT(pc + 4);

	(*__glRenderTable->LineStipple)( 
		*(GLint    *)(pc + 0),
		*(GLushort *)(pc + 4)
	);
}

void __glXDispSwap_LineWidth(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);

	(*__glRenderTable->LineWidth)( 
		*(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_Materialf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->Materialf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Materialfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glMaterialfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->Materialfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Materiali(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->Materiali)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_Materialiv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glMaterialiv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->Materialiv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_PointSize(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);

	(*__glRenderTable->PointSize)( 
		*(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_PolygonMode(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->PolygonMode)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4)
	);
}

void __glXDispSwap_Scissor(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);

	(*__glRenderTable->Scissor)( 
		*(GLint    *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLsizei  *)(pc + 8),
		*(GLsizei  *)(pc + 12)
	);
}

void __glXDispSwap_ShadeModel(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ShadeModel)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_TexParameterf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->TexParameterf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexParameterfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexParameterfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexParameterfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexParameteri(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->TexParameteri)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_TexParameteriv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexParameteriv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexParameteriv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_TexEnvf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->TexEnvf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexEnvfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexEnvfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexEnvfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexEnvi(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->TexEnvi)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_TexEnviv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexEnviv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexEnviv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_TexGend(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_DOUBLE(pc + 0);

	(*__glRenderTable->TexGend)( 
		*(GLenum   *)(pc + 8),
		*(GLenum   *)(pc + 12),
		*(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_TexGendv(GLbyte *pc)
{
	GLenum pname;
	GLint cmdlen;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexGendv_size(pname);
	if (compsize < 0) compsize = 0;
	cmdlen = __GLX_PAD(8+compsize*8);

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, cmdlen);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexGendv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLdouble *)(pc + 8)
	);
}

void __glXDispSwap_TexGenf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->TexGenf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexGenfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexGenfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexGenfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_TexGeni(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->TexGeni)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_TexGeniv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glTexGeniv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->TexGeniv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_InitNames(GLbyte *pc)
{
	(*__glRenderTable->InitNames)( 
	);
}

void __glXDispSwap_LoadName(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->LoadName)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_PassThrough(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);

	(*__glRenderTable->PassThrough)( 
		*(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_PopName(GLbyte *pc)
{
	(*__glRenderTable->PopName)( 
	);
}

void __glXDispSwap_PushName(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->PushName)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_DrawBuffer(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->DrawBuffer)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_Clear(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->Clear)( 
		*(GLbitfield *)(pc + 0)
	);
}

void __glXDispSwap_ClearAccum(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	__GLX_SWAP_FLOAT(pc + 12);

	(*__glRenderTable->ClearAccum)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8),
		*(GLfloat  *)(pc + 12)
	);
}

void __glXDispSwap_ClearIndex(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);

	(*__glRenderTable->ClearIndex)( 
		*(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_ClearColor(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	__GLX_SWAP_FLOAT(pc + 12);

	(*__glRenderTable->ClearColor)( 
		*(GLclampf *)(pc + 0),
		*(GLclampf *)(pc + 4),
		*(GLclampf *)(pc + 8),
		*(GLclampf *)(pc + 12)
	);
}

void __glXDispSwap_ClearStencil(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ClearStencil)( 
		*(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_ClearDepth(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 8);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);

	(*__glRenderTable->ClearDepth)( 
		*(GLclampd *)(pc + 0)
	);
}

void __glXDispSwap_StencilMask(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->StencilMask)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_ColorMask(GLbyte *pc)
{
	(*__glRenderTable->ColorMask)( 
		*(GLboolean *)(pc + 0),
		*(GLboolean *)(pc + 1),
		*(GLboolean *)(pc + 2),
		*(GLboolean *)(pc + 3)
	);
}

void __glXDispSwap_DepthMask(GLbyte *pc)
{
	(*__glRenderTable->DepthMask)( 
		*(GLboolean *)(pc + 0)
	);
}

void __glXDispSwap_IndexMask(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->IndexMask)( 
		*(GLuint   *)(pc + 0)
	);
}

void __glXDispSwap_Accum(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->Accum)( 
		*(GLenum   *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_Disable(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->Disable)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_Enable(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->Enable)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_PopAttrib(GLbyte *pc)
{
	(*__glRenderTable->PopAttrib)( 
	);
}

void __glXDispSwap_PushAttrib(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->PushAttrib)( 
		*(GLbitfield *)(pc + 0)
	);
}

void __glXDispSwap_MapGrid1d(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 20);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);

	(*__glRenderTable->MapGrid1d)( 
		*(GLint    *)(pc + 16),
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8)
	);
}

void __glXDispSwap_MapGrid1f(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->MapGrid1f)( 
		*(GLint    *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_MapGrid2d(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 40);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 32);
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_INT(pc + 36);
	__GLX_SWAP_DOUBLE(pc + 16);
	__GLX_SWAP_DOUBLE(pc + 24);

	(*__glRenderTable->MapGrid2d)( 
		*(GLint    *)(pc + 32),
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLint    *)(pc + 36),
		*(GLdouble *)(pc + 16),
		*(GLdouble *)(pc + 24)
	);
}

void __glXDispSwap_MapGrid2f(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_FLOAT(pc + 16);
	__GLX_SWAP_FLOAT(pc + 20);

	(*__glRenderTable->MapGrid2f)( 
		*(GLint    *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLfloat  *)(pc + 16),
		*(GLfloat  *)(pc + 20)
	);
}

void __glXDispSwap_EvalCoord1dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 8);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 1);

	(*__glRenderTable->EvalCoord1dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_EvalCoord1fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 1);

	(*__glRenderTable->EvalCoord1fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_EvalCoord2dv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);

	(*__glRenderTable->EvalCoord2dv)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_EvalCoord2fv(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 2);

	(*__glRenderTable->EvalCoord2fv)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_EvalMesh1(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->EvalMesh1)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_EvalPoint1(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->EvalPoint1)( 
		*(GLint    *)(pc + 0)
	);
}

void __glXDispSwap_EvalMesh2(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);

	(*__glRenderTable->EvalMesh2)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16)
	);
}

void __glXDispSwap_EvalPoint2(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->EvalPoint2)( 
		*(GLint    *)(pc + 0),
		*(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_AlphaFunc(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->AlphaFunc)( 
		*(GLenum   *)(pc + 0),
		*(GLclampf *)(pc + 4)
	);
}

void __glXDispSwap_BlendFunc(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->BlendFunc)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4)
	);
}

void __glXDispSwap_LogicOp(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->LogicOp)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_StencilFunc(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->StencilFunc)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLuint   *)(pc + 8)
	);
}

void __glXDispSwap_StencilOp(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->StencilOp)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLenum   *)(pc + 8)
	);
}

void __glXDispSwap_DepthFunc(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->DepthFunc)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_PixelZoom(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->PixelZoom)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_PixelTransferf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->PixelTransferf)( 
		*(GLenum   *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_PixelTransferi(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->PixelTransferi)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_PixelMapfv(GLbyte *pc)
{
	GLint mapsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	mapsize = *(GLint *)(pc + 4);
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, mapsize);

	(*__glRenderTable->PixelMapfv)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_PixelMapuiv(GLbyte *pc)
{
	GLint mapsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	mapsize = *(GLint *)(pc + 4);
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, mapsize);

	(*__glRenderTable->PixelMapuiv)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		(GLuint   *)(pc + 8)
	);
}

void __glXDispSwap_PixelMapusv(GLbyte *pc)
{
	GLint mapsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	mapsize = *(GLint *)(pc + 4);
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT_ARRAY(pc + 8, mapsize);

	(*__glRenderTable->PixelMapusv)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		(GLushort *)(pc + 8)
	);
}

void __glXDispSwap_ReadBuffer(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ReadBuffer)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_CopyPixels(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);

	(*__glRenderTable->CopyPixels)( 
		*(GLint    *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLsizei  *)(pc + 8),
		*(GLsizei  *)(pc + 12),
		*(GLenum   *)(pc + 16)
	);
}

void __glXDispSwap_DepthRange(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 16);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);

	(*__glRenderTable->DepthRange)( 
		*(GLclampd *)(pc + 0),
		*(GLclampd *)(pc + 8)
	);
}

void __glXDispSwap_Frustum(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 48);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_DOUBLE(pc + 16);
	__GLX_SWAP_DOUBLE(pc + 24);
	__GLX_SWAP_DOUBLE(pc + 32);
	__GLX_SWAP_DOUBLE(pc + 40);

	(*__glRenderTable->Frustum)( 
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLdouble *)(pc + 16),
		*(GLdouble *)(pc + 24),
		*(GLdouble *)(pc + 32),
		*(GLdouble *)(pc + 40)
	);
}

void __glXDispSwap_LoadIdentity(GLbyte *pc)
{
	(*__glRenderTable->LoadIdentity)( 
	);
}

void __glXDispSwap_LoadMatrixf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 16);

	(*__glRenderTable->LoadMatrixf)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_LoadMatrixd(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 128);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 16);

	(*__glRenderTable->LoadMatrixd)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_MatrixMode(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->MatrixMode)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_MultMatrixf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_FLOAT_ARRAY(pc + 0, 16);

	(*__glRenderTable->MultMatrixf)( 
		(GLfloat  *)(pc + 0)
	);
}

void __glXDispSwap_MultMatrixd(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 128);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 16);

	(*__glRenderTable->MultMatrixd)( 
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_Ortho(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 48);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_DOUBLE(pc + 16);
	__GLX_SWAP_DOUBLE(pc + 24);
	__GLX_SWAP_DOUBLE(pc + 32);
	__GLX_SWAP_DOUBLE(pc + 40);

	(*__glRenderTable->Ortho)( 
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLdouble *)(pc + 16),
		*(GLdouble *)(pc + 24),
		*(GLdouble *)(pc + 32),
		*(GLdouble *)(pc + 40)
	);
}

void __glXDispSwap_PopMatrix(GLbyte *pc)
{
	(*__glRenderTable->PopMatrix)( 
	);
}

void __glXDispSwap_PushMatrix(GLbyte *pc)
{
	(*__glRenderTable->PushMatrix)( 
	);
}

void __glXDispSwap_Rotated(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 32);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_DOUBLE(pc + 16);
	__GLX_SWAP_DOUBLE(pc + 24);

	(*__glRenderTable->Rotated)( 
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLdouble *)(pc + 16),
		*(GLdouble *)(pc + 24)
	);
}

void __glXDispSwap_Rotatef(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	__GLX_SWAP_FLOAT(pc + 12);

	(*__glRenderTable->Rotatef)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8),
		*(GLfloat  *)(pc + 12)
	);
}

void __glXDispSwap_Scaled(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_DOUBLE(pc + 16);

	(*__glRenderTable->Scaled)( 
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLdouble *)(pc + 16)
	);
}

void __glXDispSwap_Scalef(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->Scalef)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Translated(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;


#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 24);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_DOUBLE(pc + 0);
	__GLX_SWAP_DOUBLE(pc + 8);
	__GLX_SWAP_DOUBLE(pc + 16);

	(*__glRenderTable->Translated)( 
		*(GLdouble *)(pc + 0),
		*(GLdouble *)(pc + 8),
		*(GLdouble *)(pc + 16)
	);
}

void __glXDispSwap_Translatef(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->Translatef)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_Viewport(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);

	(*__glRenderTable->Viewport)( 
		*(GLint    *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLsizei  *)(pc + 8),
		*(GLsizei  *)(pc + 12)
	);
}

void __glXDispSwap_PolygonOffset(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);

	(*__glRenderTable->PolygonOffset)( 
		*(GLfloat  *)(pc + 0),
		*(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_CopyTexImage1D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);
	__GLX_SWAP_INT(pc + 24);

	(*__glRenderTable->CopyTexImage1D)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLenum   *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16),
		*(GLsizei  *)(pc + 20),
		*(GLint    *)(pc + 24)
	);
}

void __glXDispSwap_CopyTexImage2D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);
	__GLX_SWAP_INT(pc + 24);
	__GLX_SWAP_INT(pc + 28);

	(*__glRenderTable->CopyTexImage2D)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLenum   *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16),
		*(GLsizei  *)(pc + 20),
		*(GLsizei  *)(pc + 24),
		*(GLint    *)(pc + 28)
	);
}

void __glXDispSwap_CopyTexSubImage1D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);

	(*__glRenderTable->CopyTexSubImage1D)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16),
		*(GLsizei  *)(pc + 20)
	);
}

void __glXDispSwap_CopyTexSubImage2D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);
	__GLX_SWAP_INT(pc + 24);
	__GLX_SWAP_INT(pc + 28);

	(*__glRenderTable->CopyTexSubImage2D)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16),
		*(GLint    *)(pc + 20),
		*(GLsizei  *)(pc + 24),
		*(GLsizei  *)(pc + 28)
	);
}

void __glXDispSwap_BindTexture(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->BindTexture)( 
		*(GLenum   *)(pc + 0),
		*(GLuint   *)(pc + 4)
	);
}

void __glXDispSwap_PrioritizeTextures(GLbyte *pc)
{
	GLsizei n;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	n = *(GLsizei *)(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 4, n);
	__GLX_SWAP_FLOAT_ARRAY(pc + 4+n*4, n);

	(*__glRenderTable->PrioritizeTextures)( 
		*(GLsizei  *)(pc + 0),
		(GLuint   *)(pc + 4),
		(GLclampf *)(pc + 4+n*4)
	);
}

void __glXDispSwap_Indexubv(GLbyte *pc)
{
	(*__glRenderTable->Indexubv)( 
		(GLubyte  *)(pc + 0)
	);
}

void __glXDispSwap_BlendColor(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	__GLX_SWAP_FLOAT(pc + 12);

	(*__glRenderTable->BlendColor)( 
		*(GLclampf *)(pc + 0),
		*(GLclampf *)(pc + 4),
		*(GLclampf *)(pc + 8),
		*(GLclampf *)(pc + 12)
	);
}

void __glXDispSwap_BlendEquation(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->BlendEquation)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_ColorTableParameterfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glColorTableParameterfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->ColorTableParameterfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_ColorTableParameteriv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glColorTableParameteriv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->ColorTableParameteriv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_CopyColorTable(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);

	(*__glRenderTable->CopyColorTable)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLsizei  *)(pc + 16)
	);
}

void __glXDispSwap_CopyColorSubTable(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);

	(*__glRenderTable->CopyColorSubTable)( 
		*(GLenum   *)(pc + 0),
		*(GLsizei  *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLsizei  *)(pc + 16)
	);
}

void __glXDispSwap_ConvolutionParameterf(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);

	(*__glRenderTable->ConvolutionParameterf)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_ConvolutionParameterfv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glConvolutionParameterfv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->ConvolutionParameterfv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLfloat  *)(pc + 8)
	);
}

void __glXDispSwap_ConvolutionParameteri(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->ConvolutionParameteri)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_ConvolutionParameteriv(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 4);
	pname = *(GLenum *)(pc + 4);
	compsize = __glConvolutionParameteriv_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 8, compsize);

	(*__glRenderTable->ConvolutionParameteriv)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		(GLint    *)(pc + 8)
	);
}

void __glXDispSwap_CopyConvolutionFilter1D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);

	(*__glRenderTable->CopyConvolutionFilter1D)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLsizei  *)(pc + 16)
	);
}

void __glXDispSwap_CopyConvolutionFilter2D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);

	(*__glRenderTable->CopyConvolutionFilter2D)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLsizei  *)(pc + 16),
		*(GLsizei  *)(pc + 20)
	);
}

void __glXDispSwap_Histogram(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);

	(*__glRenderTable->Histogram)( 
		*(GLenum   *)(pc + 0),
		*(GLsizei  *)(pc + 4),
		*(GLenum   *)(pc + 8),
		*(GLboolean *)(pc + 12)
	);
}

void __glXDispSwap_Minmax(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTable->Minmax)( 
		*(GLenum   *)(pc + 0),
		*(GLenum   *)(pc + 4),
		*(GLboolean *)(pc + 8)
	);
}

void __glXDispSwap_ResetHistogram(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ResetHistogram)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_ResetMinmax(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTable->ResetMinmax)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_CopyTexSubImage3D(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT(pc + 4);
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_INT(pc + 12);
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_INT(pc + 20);
	__GLX_SWAP_INT(pc + 24);
	__GLX_SWAP_INT(pc + 28);
	__GLX_SWAP_INT(pc + 32);

	(*__glRenderTable->CopyTexSubImage3D)( 
		*(GLenum   *)(pc + 0),
		*(GLint    *)(pc + 4),
		*(GLint    *)(pc + 8),
		*(GLint    *)(pc + 12),
		*(GLint    *)(pc + 16),
		*(GLint    *)(pc + 20),
		*(GLint    *)(pc + 24),
		*(GLsizei  *)(pc + 28),
		*(GLsizei  *)(pc + 32)
	);
}

void __glXDispSwap_ActiveTextureARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTableEXT->ActiveTextureARB)( 
		*(GLenum   *)(pc + 0)
	);
}

void __glXDispSwap_MultiTexCoord1dvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 12);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 8);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 1);

	(*__glRenderTableEXT->MultiTexCoord1dvARB)( 
		*(GLenum   *)(pc + 8),
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_MultiTexCoord1fvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, 1);

	(*__glRenderTableEXT->MultiTexCoord1fvARB)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord1ivARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 4, 1);

	(*__glRenderTableEXT->MultiTexCoord1ivARB)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord1svARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT_ARRAY(pc + 4, 1);

	(*__glRenderTableEXT->MultiTexCoord1svARB)( 
		*(GLenum   *)(pc + 0),
		(GLshort  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord2dvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 20);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 16);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 2);

	(*__glRenderTableEXT->MultiTexCoord2dvARB)( 
		*(GLenum   *)(pc + 16),
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_MultiTexCoord2fvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, 2);

	(*__glRenderTableEXT->MultiTexCoord2fvARB)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord2ivARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 4, 2);

	(*__glRenderTableEXT->MultiTexCoord2ivARB)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord2svARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT_ARRAY(pc + 4, 2);

	(*__glRenderTableEXT->MultiTexCoord2svARB)( 
		*(GLenum   *)(pc + 0),
		(GLshort  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord3dvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 28);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 24);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 3);

	(*__glRenderTableEXT->MultiTexCoord3dvARB)( 
		*(GLenum   *)(pc + 24),
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_MultiTexCoord3fvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, 3);

	(*__glRenderTableEXT->MultiTexCoord3fvARB)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord3ivARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 4, 3);

	(*__glRenderTableEXT->MultiTexCoord3ivARB)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord3svARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT_ARRAY(pc + 4, 3);

	(*__glRenderTableEXT->MultiTexCoord3svARB)( 
		*(GLenum   *)(pc + 0),
		(GLshort  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord4dvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

#ifdef __GLX_ALIGN64
	if ((unsigned long)(pc) & 7) {
	    __GLX_MEM_COPY(pc-4, pc, 36);
	    pc -= 4;
	}
#endif
	__GLX_SWAP_INT(pc + 32);
	__GLX_SWAP_DOUBLE_ARRAY(pc + 0, 4);

	(*__glRenderTableEXT->MultiTexCoord4dvARB)( 
		*(GLenum   *)(pc + 32),
		(GLdouble *)(pc + 0)
	);
}

void __glXDispSwap_MultiTexCoord4fvARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, 4);

	(*__glRenderTableEXT->MultiTexCoord4fvARB)( 
		*(GLenum   *)(pc + 0),
		(GLfloat  *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord4ivARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_INT_ARRAY(pc + 4, 4);

	(*__glRenderTableEXT->MultiTexCoord4ivARB)( 
		*(GLenum   *)(pc + 0),
		(GLint    *)(pc + 4)
	);
}

void __glXDispSwap_MultiTexCoord4svARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_SHORT_ARRAY(pc + 4, 4);

	(*__glRenderTableEXT->MultiTexCoord4svARB)( 
		*(GLenum   *)(pc + 0),
		(GLshort  *)(pc + 4)
	);
}


/*
 * Extensions
 */

void __glXDispSwap_PointParameterfARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_SWAP_INT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	(*__glRenderTableEXT->PointParameterfEXT)(
		*(GLenum *)(pc + 0),
		*(GLfloat *)(pc + 4)
	);
}

void __glXDispSwap_PointParameterfvARB(GLbyte *pc)
{
	GLenum pname;
	GLint compsize;
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_DECLARE_SWAP_ARRAY_VARIABLES;

	__GLX_SWAP_INT(pc + 0);
	pname = *(GLenum *)(pc + 0);
	compsize = __glPointParameterfvARB_size(pname);
	if (compsize < 0) compsize = 0;
	__GLX_SWAP_FLOAT_ARRAY(pc + 4, compsize);

	(*__glRenderTableEXT->PointParameterfvEXT)(
		*(GLenum *)(pc + 0),
		(GLfloat *)(pc + 4)
	);
}

void __glXDispSwap_ActiveStencilFaceEXT(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;

	__GLX_SWAP_INT(pc + 0);

	(*__glRenderTableEXT->ActiveStencilFaceEXT)(
		*(GLenum *)(pc + 0)
	);
}

void __glXDispSwap_WindowPos3fARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_FLOAT(pc + 4);
	__GLX_SWAP_FLOAT(pc + 8);
	(*__glRenderTableEXT->WindowPos3fMESA)(
		*(GLfloat *)(pc + 0),
		*(GLfloat *)(pc + 4),
		*(GLfloat *)(pc + 8)
	);
}

void __glXDispSwap_SampleCoverageARB(GLbyte *pc)
{
	__GLX_DECLARE_SWAP_VARIABLES;
	__GLX_SWAP_FLOAT(pc + 0);
	__GLX_SWAP_INT(pc + 4);

	(*__glRenderTableEXT->SampleCoverageARB)(
		*(GLfloat *)(pc + 0),
		*(GLboolean *)(pc + 4)
	);
}
