/* include_stack.h -- simple stack to help the lexer include files

   Copyright 2001 Carl Worth

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef INCLUDE_STACK_H
#define INCLUDE_STACK_H

struct include_stack
{
    char *filename;
    FILE *file;
    int line_num;
    YY_BUFFER_STATE buffer;
    struct include_stack *prev;
};
typedef struct include_stack include_stack_t;

int include_stack_init(void, char *filename);
void include_stack_push(include_stack_t *stack, include_stack_t *item);
include_stack_t *include_stack_pop(include_stack_t *stack);

#endif
