/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/param.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgen.h>
#include <ctype.h>
#include <errno.h>
#include <err.h>
#include <unistd.h>
#include <poll.h>
#include <pwd.h>
#include <time.h>
#include <limits.h>

#ifndef MAXLOGNAME
#define MAXLOGNAME _POSIX_LOGIN_NAME_MAX
#endif /* !MAXLOGNAME */

#define CRADLE_UI "cradle_ui"

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

static char home[MAXPATHLEN];		/* Home directory of user */
static char username[MAXLOGNAME];	/* Username: predicate match and expansion */

char *
freadline(char *line, int size, FILE *fp)
{
	char *p;

	if (fgets(line, size, fp) == NULL)
		return (NULL);

	if ((p = strchr(line, '\n')) == NULL)
		return (line);	/* just terminate */
	*p = '\0';

	return (line);
}

char *
strrpl(char *str, size_t size, char *match, char *value)
{
	char *p, *e;
	int len, rlen;

	p = str;
	e = p + strlen(p);
	len = strlen(match);

	/* Try to match against the variable */
	while ((p = strchr(p, match[0])) != NULL) {
		if (!strncmp(p, match, len) && !isalnum(p[len]))
			break;
		p += len;

		if (p >= e)
			return (NULL);
	}

	if (p == NULL)
		return (NULL);

	rlen = strlen(value);

	if (strlen(str) - len + rlen > size)
		return (NULL);

	memmove(p + rlen, p + len, strlen(p + len) + 1);
	memcpy(p, value, rlen);

	return (p);
}

void
free_list(void *data, void *arg)
{
	free(data);
}

int
make_policy(char **type, char **data, int count, char **presult, int derive)
{
	static char result[4096];
	char one[2048];
	int i;
	int nfilename, isfilename;

	result[0] = '\0';
	nfilename = 0;
	for (i = 0; i < count; i++) {
		isfilename = 0;
		/* Special case for non existing filenames */
		if (strstr(data[i], "<non-existent filename>") != NULL) {
			snprintf(result, sizeof(result),
			    "filename%s sub \"<non-existent filename>\" then deny[enoent]", i ? "[1]" : "");
			break;
		}

		if (!strcmp(type[i], "uid") || !strcmp(type[i], "gid") ||
		    !strcmp(type[i], "argv"))
			continue;

		/* Special case for system calls with more than one filename */
		if (!strcmp(type[i], "filename")) {
			isfilename = 1;
			nfilename++;
		}
		
		if (strlen(result)) {
			if (strlcat(result, " and ", sizeof(result)) >= sizeof(result))
				return (-1);
		}

		/* Special treatment for filenames */
		if (isfilename) {
			char filename[2048];
			char *operator = "eq";

			if (derive) {
				operator = "match";

				snprintf(filename, sizeof(filename),
				    "%s/*", dirname(data[i]));
			} else
				strlcpy(filename, data[i], sizeof(filename));

			/* Make useful replacements */
			while (strrpl(filename, sizeof(filename),
				   home, "$HOME") != NULL)
				;
			while (strrpl(filename, sizeof(filename),
				   username, "$USER") != NULL)
				;

			snprintf(one, sizeof(one), "%s%s %s \"%s\"",
			    type[i], isfilename && nfilename == 2 ? "[1]" : "",
			    operator, filename);
		} else {
			snprintf(one, sizeof(one), "%s eq \"%s\"",
			    type[i], data[i]);
		}

		if (strlcat(result, one, sizeof(result)) >= sizeof(result))
			return (-1);;
	}

	if (!strlen(result))
		return (-1);

	/* Normal termination */
	if (i == count)
		strlcat(result, " then permit", sizeof(result));

	*presult = result;
	return (nfilename);
}

#define MAX_SYSCALLARGS	10

GList *
make_policy_suggestion(char *info)
{
	GList *items = NULL;
	char line[4096], *next, *p, *syscall;
	char *type[MAX_SYSCALLARGS], *data[MAX_SYSCALLARGS];
	int count = 0, res;

	/* Prepare parsing of info line */
	strlcpy(line, info, sizeof(line));

	next = line;
	syscall = strsep(&next, ",");

	/* See if we can make a suggestion for this system call */
	if (next == NULL)
		goto out;
	next++;
	if (!strncmp(next, "args: ", 6)) {
		count = -1;
		goto out;
	}

	while (next != NULL) {
		p = next;

		next = strstr(next, ", ");
		if (next != NULL) {
			*next = '\0';
			next += 2;
		}

		type[count] = strsep(&p, ":");
		/* Something got messed up here */
		if (p == NULL)
			goto out;
		data[count] = p + 1;

		count++;
	}

	res = make_policy(type, data, count, &p, 0);
	if (res != -1)
		items = g_list_append(items, strdup(p));

	if (res > 0) {
		res = make_policy(type, data, count, &p, 1);
		if (res != -1)
			items = g_list_append(items, strdup(p));
	}
			
 out:
	/* Simples policy */
	p = count == -1 ? "permit" : "true then permit";
	items = g_list_append(items, strdup(p));

	return (items);
}

void
parameters(void)
{
	struct passwd *pw;
	uid_t uid = getuid();

	/* Find out current username. */
	if ((pw = getpwuid(uid)) == NULL)
		snprintf(username, sizeof(username), "uid %u", uid);
	else
		snprintf(username, sizeof(username), "%s", pw->pw_name);

	strlcpy(home, pw->pw_dir, sizeof(home));
}

GtkStyle *
make_color(GtkStyle *default_style, int hexred, int hexgreen, int hexblue)
{
	GdkColormap *cmap;
	GdkColor color;
	GtkStyle *style;

	cmap = gdk_colormap_get_system();

	color.red = hexred;
	color.green = hexgreen;
	color.blue = hexblue;
	if (!gdk_color_alloc(cmap, &color)) {
		g_error("Could not allocate color");
	}

	style = gtk_style_copy(default_style);
	style->fg[GTK_STATE_NORMAL] = color;

	return (style);
}

GtkWidget *filterreview;
GtkWidget *wizard;
GtkWidget *wizardbutton;
int nfilters;

int
main (int argc, char *argv[])
{
	struct pollfd pfd;
	char line[4096], *p;
	char *name, *id, *polname, *filters;
	int nfilters, res;
	time_t curtime;
	GList *items = NULL;

	GtkWidget *systracewin;
	GtkWidget *processname;
	GtkWidget *policyname;
	GtkWidget *processid;
	GtkWidget *syscallinfo;
	GtkWidget *statusline;
	GtkWidget *timeline;
	GtkWidget *reviewbutton;
	GtkWidget *detachlabel;
	GtkWidget *filterentry;

	GtkStyle *default_style, *red_style;

	/* Set up required parameters */
	parameters();

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
	systracewin = create_systracewin ();
	filterreview = create_filterreview();
	wizard = create_wizard();

	processname = lookup_widget(GTK_WIDGET(systracewin), "processname");
	processid = lookup_widget(GTK_WIDGET(systracewin), "processid");
	policyname = lookup_widget(GTK_WIDGET(systracewin), "policyname");
	syscallinfo = lookup_widget(GTK_WIDGET(systracewin), "syscallinfo");
	statusline = lookup_widget(GTK_WIDGET(systracewin), "statusline");
	timeline = lookup_widget(GTK_WIDGET(systracewin), "timeline");
	reviewbutton = lookup_widget(GTK_WIDGET(systracewin), "reviewbutton");
	wizardbutton = lookup_widget(GTK_WIDGET(systracewin), "wizardbutton");
	detachlabel = lookup_widget(GTK_WIDGET(systracewin), "detachlabel");
	filterentry = lookup_widget(GTK_WIDGET(systracewin), "filterentry");
	default_style = gtk_widget_get_style(processname);
	red_style = make_color(default_style, 0xd000, 0x1000, 0);
	red_style->font = gdk_font_load("-*-helvetica-bold-r-normal--*-140-*-*-*-*-iso8859-1");
	gtk_widget_set_style(processname, red_style);
	gtk_widget_set_style(processid, red_style);
	gtk_widget_set_style(policyname, red_style);
	gtk_widget_set_style(syscallinfo, red_style);

	/* Return key is not supposed to pop it up */
	gtk_combo_disable_activate(GTK_COMBO(filterentry));

	/* Connect to cradle server if requested */
	if (argc == 2 && strcmp(argv[1], "-C") == 0) {
		struct sockaddr_un sun;
		int s;
		char path[MAXPATHLEN];

		snprintf(path, sizeof(path), "/tmp/systrace-%d/%s",
		    getuid(), CRADLE_UI);

		if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1)
			err(1, "socket()");

		memset(&sun, 0, sizeof (sun));
		sun.sun_family = AF_UNIX;

		if (strlcpy(sun.sun_path, path, sizeof(sun.sun_path)) >=
		    sizeof(sun.sun_path))
			errx(1, "Path too long: %s", path);

		if (connect(s, (struct sockaddr *)&sun, sizeof(sun)) == -1)
			err(1, "connect()");

		if (dup2(s, fileno(stdin)) == -1)
			err(1, "dup2");
		if (dup2(s, fileno(stdout)) == -1)
			err(1, "dup2");
	}

	/* Make IO line buffered */
	setvbuf(stdin, NULL, _IONBF, 0);
	setvbuf(stdout, NULL, _IONBF, 0);
	while (1) {
		/* See if we can read from the file descriptor */
		memset(&pfd, 0, sizeof(pfd));
		pfd.fd = fileno(stdin);
		pfd.events = POLLIN;
		res = poll(&pfd, 1, 1000);
		if (res == -1) {
			if (errno == EINTR || errno == EAGAIN)
				break;
		} else if (res == 0) {
			while (gtk_events_pending())
				gtk_main_iteration();
			continue;
		}

		if (freadline(line, sizeof(line), stdin) == NULL)
			break;
		p = line;
		name = strsep(&p, ",");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		p++;
		strsep(&p, " ");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		id = strsep(&p, "(");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		strsep(&p, ":");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		p++;
		polname = strsep(&p, ",");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		strsep(&p, ":");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		p++;
		filters = strsep(&p, ",");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		nfilters = atoi(filters);
		strsep(&p, ":");
		if (p == NULL || *p == '\0')
			errx(1, "Bad input line");
		p++;

		gtk_label_set_text(GTK_LABEL(processname), name);
		gtk_label_set_text(GTK_LABEL(processid), id);
		gtk_label_set_text(GTK_LABEL(policyname), polname);
		gtk_label_set_text(GTK_LABEL(syscallinfo), p);
		gtk_label_set_text(GTK_LABEL(statusline), "");

		items = make_policy_suggestion(p);

		curtime = time(NULL);
		snprintf(line, sizeof(line), "%.25s", ctime(&curtime));
		gtk_label_set_text(GTK_LABEL(timeline), line);

		if (nfilters) {
			gtk_widget_set_sensitive(wizardbutton, 0);
			gtk_widget_set_sensitive(reviewbutton, 1);
			gtk_label_set_text(GTK_LABEL(detachlabel), "Automatic");
		} else {
			gtk_widget_set_sensitive(wizardbutton, 1);
			gtk_widget_set_sensitive(reviewbutton, 0);
			gtk_label_set_text(GTK_LABEL(detachlabel), "Detach");
		}

		gtk_widget_show (systracewin);

		gtk_combo_set_popdown_strings (GTK_COMBO(filterentry), items);
		g_list_foreach(items, free_list, NULL);
		g_list_free(items);

		do {
			gtk_main ();
			while (freadline(line, sizeof(line), stdin)) {
				if (!strcmp(line, "OKAY"))
					goto done;
				if (!strcmp(line, "WRONG"))
					break;
				gtk_label_set_text(GTK_LABEL(statusline), line);
			}
		} while (1);

	done:
		gtk_widget_hide (systracewin);

		while (gtk_events_pending())
			gtk_main_iteration();
	}
	return 0;
}

