The "quota2" implements a named counter which can be increased or decreased
on a per-match basis. Available modes are packet counting or byte counting.
The value of the counter can be read and reset through procfs, thereby making
this match a minimalist accounting tool.
.PP
When counting down from the initial quota, the counter will stop at 0 and
the match will return false, just like the original "quota" match. In growing
(upcounting) mode, it will always return true.
.TP
\fB\-\-grow\fP
Count upwards instead of downwards.
.TP
\fB\-\-name\fP \fIname\fP
Assign the counter a specific name. This option must be present, as an empty
name is not allowed. Names starting with a dot or names containing a slash are
prohibited.
.TP
[\fB!\fP] \fB\-\-quota\fP \fIiq\fP
Specify the initial quota for this counter. If the counter already exists,
it is not reset. An "!" may be used to invert the result of the match. The
negation has no effect when \fB\-\-grow\fP is used.
.TP
\fB\-\-packets\fP
Count packets instead of bytes that passed the quota2 match.
.PP
Because counters in quota2 can be shared, you can combine them for various
purposes, for example, a bytebucket filter that only lets as much traffic go
out as has come in:
.PP
\-A INPUT \-p tcp \-\-dport 6881 \-m quota \-\-name bt \-\-grow;
\-A OUTPUT \-p tcp \-\-sport 6881 \-m quota \-\-name bt;
