/*
 *   Copyright (c) 2012, Michael Lehn
 *
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *   1) Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2) Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in
 *      the documentation and/or other materials provided with the
 *      distribution.
 *   3) Neither the name of the FLENS development group nor the names of
 *      its contributors may be used to endorse or promote products derived
 *      from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CXXLAPACK_INTERFACE_INTERFACE_H
#define CXXLAPACK_INTERFACE_INTERFACE_H 1

#include <complex>

#include "xflens/cxxlapack/interface/bbcsd.h"
#include "xflens/cxxlapack/interface/bdsdc.h"
#include "xflens/cxxlapack/interface/bdsqr.h"
#include "xflens/cxxlapack/interface/cgesv.h"
#include "xflens/cxxlapack/interface/chla_transtype.h"
#include "xflens/cxxlapack/interface/cposv.h"
#include "xflens/cxxlapack/interface/disna.h"
#include "xflens/cxxlapack/interface/dspcon.h"
#include "xflens/cxxlapack/interface/gbbrd.h"
#include "xflens/cxxlapack/interface/gbcon.h"
#include "xflens/cxxlapack/interface/gbequb.h"
#include "xflens/cxxlapack/interface/gbequ.h"
#include "xflens/cxxlapack/interface/gbrfs.h"
#include "xflens/cxxlapack/interface/gbsv.h"
#include "xflens/cxxlapack/interface/gbsvx.h"
#include "xflens/cxxlapack/interface/gbtf2.h"
#include "xflens/cxxlapack/interface/gbtrf.h"
#include "xflens/cxxlapack/interface/gbtrs.h"
#include "xflens/cxxlapack/interface/gebak.h"
#include "xflens/cxxlapack/interface/gebal.h"
#include "xflens/cxxlapack/interface/gebd2.h"
#include "xflens/cxxlapack/interface/gebrd.h"
#include "xflens/cxxlapack/interface/gecon.h"
#include "xflens/cxxlapack/interface/geequb.h"
#include "xflens/cxxlapack/interface/geequ.h"
#include "xflens/cxxlapack/interface/gees.h"
#include "xflens/cxxlapack/interface/geesx.h"
#include "xflens/cxxlapack/interface/geev.h"
#include "xflens/cxxlapack/interface/geevx.h"
#include "xflens/cxxlapack/interface/gegs.h"
#include "xflens/cxxlapack/interface/gegv.h"
#include "xflens/cxxlapack/interface/gehd2.h"
#include "xflens/cxxlapack/interface/gehrd.h"
#include "xflens/cxxlapack/interface/gejsv.h"
#include "xflens/cxxlapack/interface/gelq2.h"
#include "xflens/cxxlapack/interface/gelqf.h"
#include "xflens/cxxlapack/interface/gelsd.h"
#include "xflens/cxxlapack/interface/gels.h"
#include "xflens/cxxlapack/interface/gelss.h"
#include "xflens/cxxlapack/interface/gelsx.h"
#include "xflens/cxxlapack/interface/gelsy.h"
#include "xflens/cxxlapack/interface/geql2.h"
#include "xflens/cxxlapack/interface/geqlf.h"
#include "xflens/cxxlapack/interface/geqp3.h"
#include "xflens/cxxlapack/interface/geqpf.h"
#include "xflens/cxxlapack/interface/geqr2.h"
#include "xflens/cxxlapack/interface/geqr2p.h"
#include "xflens/cxxlapack/interface/geqrf.h"
#include "xflens/cxxlapack/interface/geqrfp.h"
#include "xflens/cxxlapack/interface/gerfs.h"
#include "xflens/cxxlapack/interface/gerq2.h"
#include "xflens/cxxlapack/interface/gerqf.h"
#include "xflens/cxxlapack/interface/gesc2.h"
#include "xflens/cxxlapack/interface/gesdd.h"
#include "xflens/cxxlapack/interface/gesvd.h"
#include "xflens/cxxlapack/interface/gesv.h"
#include "xflens/cxxlapack/interface/gesvj.h"
#include "xflens/cxxlapack/interface/gesvx.h"
#include "xflens/cxxlapack/interface/getc2.h"
#include "xflens/cxxlapack/interface/getf2.h"
#include "xflens/cxxlapack/interface/getrf.h"
#include "xflens/cxxlapack/interface/getri.h"
#include "xflens/cxxlapack/interface/getrs.h"
#include "xflens/cxxlapack/interface/ggbak.h"
#include "xflens/cxxlapack/interface/ggbal.h"
#include "xflens/cxxlapack/interface/gges.h"
#include "xflens/cxxlapack/interface/ggesx.h"
#include "xflens/cxxlapack/interface/ggev.h"
#include "xflens/cxxlapack/interface/ggevx.h"
#include "xflens/cxxlapack/interface/ggglm.h"
#include "xflens/cxxlapack/interface/gghrd.h"
#include "xflens/cxxlapack/interface/gglse.h"
#include "xflens/cxxlapack/interface/ggqrf.h"
#include "xflens/cxxlapack/interface/ggrqf.h"
#include "xflens/cxxlapack/interface/ggsvd.h"
#include "xflens/cxxlapack/interface/ggsvp.h"
#include "xflens/cxxlapack/interface/gsvj0.h"
#include "xflens/cxxlapack/interface/gsvj1.h"
#include "xflens/cxxlapack/interface/gtcon.h"
#include "xflens/cxxlapack/interface/gtrfs.h"
#include "xflens/cxxlapack/interface/gtsv.h"
#include "xflens/cxxlapack/interface/gtsvx.h"
#include "xflens/cxxlapack/interface/gttrf.h"
#include "xflens/cxxlapack/interface/gttrs.h"
#include "xflens/cxxlapack/interface/gtts2.h"
#include "xflens/cxxlapack/interface/hbevd.h"
#include "xflens/cxxlapack/interface/hbev.h"
#include "xflens/cxxlapack/interface/hbevx.h"
#include "xflens/cxxlapack/interface/hbgst.h"
#include "xflens/cxxlapack/interface/hbgvd.h"
#include "xflens/cxxlapack/interface/hbgv.h"
#include "xflens/cxxlapack/interface/hbgvx.h"
#include "xflens/cxxlapack/interface/hbtrd.h"
#include "xflens/cxxlapack/interface/hecon.h"
#include "xflens/cxxlapack/interface/heequb.h"
#include "xflens/cxxlapack/interface/heevd.h"
#include "xflens/cxxlapack/interface/heev.h"
#include "xflens/cxxlapack/interface/heevr.h"
#include "xflens/cxxlapack/interface/heevx.h"
#include "xflens/cxxlapack/interface/hegs2.h"
#include "xflens/cxxlapack/interface/hegst.h"
#include "xflens/cxxlapack/interface/hegvd.h"
#include "xflens/cxxlapack/interface/hegv.h"
#include "xflens/cxxlapack/interface/hegvx.h"
#include "xflens/cxxlapack/interface/herfs.h"
#include "xflens/cxxlapack/interface/hesv.h"
#include "xflens/cxxlapack/interface/hesvx.h"
#include "xflens/cxxlapack/interface/heswapr.h"
#include "xflens/cxxlapack/interface/hetd2.h"
#include "xflens/cxxlapack/interface/hetf2.h"
#include "xflens/cxxlapack/interface/hetrd.h"
#include "xflens/cxxlapack/interface/hetrf.h"
#include "xflens/cxxlapack/interface/hetri2.h"
#include "xflens/cxxlapack/interface/hetri2x.h"
#include "xflens/cxxlapack/interface/hetri.h"
#include "xflens/cxxlapack/interface/hetrs2.h"
#include "xflens/cxxlapack/interface/hetrs.h"
#include "xflens/cxxlapack/interface/hfrk.h"
#include "xflens/cxxlapack/interface/hgeqz.h"
#include "xflens/cxxlapack/interface/hpcon.h"
#include "xflens/cxxlapack/interface/hpevd.h"
#include "xflens/cxxlapack/interface/hpev.h"
#include "xflens/cxxlapack/interface/hpevx.h"
#include "xflens/cxxlapack/interface/hpgst.h"
#include "xflens/cxxlapack/interface/hpgvd.h"
#include "xflens/cxxlapack/interface/hpgv.h"
#include "xflens/cxxlapack/interface/hpgvx.h"
#include "xflens/cxxlapack/interface/hprfs.h"
#include "xflens/cxxlapack/interface/hpsv.h"
#include "xflens/cxxlapack/interface/hpsvx.h"
#include "xflens/cxxlapack/interface/hptrd.h"
#include "xflens/cxxlapack/interface/hptrf.h"
#include "xflens/cxxlapack/interface/hptri.h"
#include "xflens/cxxlapack/interface/hptrs.h"
#include "xflens/cxxlapack/interface/hsein.h"
#include "xflens/cxxlapack/interface/hseqr.h"
#include "xflens/cxxlapack/interface/ieeeck.h"
#include "xflens/cxxlapack/interface/ilalc.h"
#include "xflens/cxxlapack/interface/ilalr.h"
#include "xflens/cxxlapack/interface/laprec.h"
#include "xflens/cxxlapack/interface/ilaslc.h"
#include "xflens/cxxlapack/interface/ilaslr.h"
#include "xflens/cxxlapack/interface/latrans.h"
#include "xflens/cxxlapack/interface/lauplo.h"
#include "xflens/cxxlapack/interface/ilaver.h"
#include "xflens/cxxlapack/interface/ilazlc.h"
#include "xflens/cxxlapack/interface/ilazlr.h"
#include "xflens/cxxlapack/interface/interface.h"
#include "xflens/cxxlapack/interface/isnan.h"
#include "xflens/cxxlapack/interface/izmax1.h"
#include "xflens/cxxlapack/interface/labad.h"
#include "xflens/cxxlapack/interface/labrd.h"
#include "xflens/cxxlapack/interface/lacgv.h"
#include "xflens/cxxlapack/interface/lacn2.h"
#include "xflens/cxxlapack/interface/lacon.h"
#include "xflens/cxxlapack/interface/lacp2.h"
#include "xflens/cxxlapack/interface/lacpy.h"
#include "xflens/cxxlapack/interface/lacrm.h"
#include "xflens/cxxlapack/interface/lacrt.h"
#include "xflens/cxxlapack/interface/ladiv.h"
#include "xflens/cxxlapack/interface/lae2.h"
#include "xflens/cxxlapack/interface/laebz.h"
#include "xflens/cxxlapack/interface/laed0.h"
#include "xflens/cxxlapack/interface/laed1.h"
#include "xflens/cxxlapack/interface/laed2.h"
#include "xflens/cxxlapack/interface/laed3.h"
#include "xflens/cxxlapack/interface/laed4.h"
#include "xflens/cxxlapack/interface/laed5.h"
#include "xflens/cxxlapack/interface/laed6.h"
#include "xflens/cxxlapack/interface/laed7.h"
#include "xflens/cxxlapack/interface/laed8.h"
#include "xflens/cxxlapack/interface/laed9.h"
#include "xflens/cxxlapack/interface/laeda.h"
#include "xflens/cxxlapack/interface/laein.h"
#include "xflens/cxxlapack/interface/laesy.h"
#include "xflens/cxxlapack/interface/laev2.h"
#include "xflens/cxxlapack/interface/laexc.h"
#include "xflens/cxxlapack/interface/lag2c.h"
#include "xflens/cxxlapack/interface/lag2d.h"
#include "xflens/cxxlapack/interface/lag2.h"
#include "xflens/cxxlapack/interface/lag2s.h"
#include "xflens/cxxlapack/interface/lag2z.h"
#include "xflens/cxxlapack/interface/la_gbamv.h"
#include "xflens/cxxlapack/interface/la_gbrcond_c.h"
#include "xflens/cxxlapack/interface/la_gbrcond.h"
#include "xflens/cxxlapack/interface/la_gbrcond_x.h"
#include "xflens/cxxlapack/interface/la_gbrpvgrw.h"
#include "xflens/cxxlapack/interface/la_geamv.h"
#include "xflens/cxxlapack/interface/la_gercond_c.h"
#include "xflens/cxxlapack/interface/la_gercond.h"
#include "xflens/cxxlapack/interface/la_gercond_x.h"
#include "xflens/cxxlapack/interface/lags2.h"
#include "xflens/cxxlapack/interface/lagtf.h"
#include "xflens/cxxlapack/interface/lagtm.h"
#include "xflens/cxxlapack/interface/lagts.h"
#include "xflens/cxxlapack/interface/lagv2.h"
#include "xflens/cxxlapack/interface/lahef.h"
#include "xflens/cxxlapack/interface/la_heramv.h"
#include "xflens/cxxlapack/interface/la_hercond_c.h"
#include "xflens/cxxlapack/interface/la_hercond_x.h"
#include "xflens/cxxlapack/interface/la_herpvgrw.h"
#include "xflens/cxxlapack/interface/lahqr.h"
#include "xflens/cxxlapack/interface/lahr2.h"
#include "xflens/cxxlapack/interface/lahrd.h"
#include "xflens/cxxlapack/interface/laic1.h"
#include "xflens/cxxlapack/interface/laisnan.h"
#include "xflens/cxxlapack/interface/la_lin_berr.h"
#include "xflens/cxxlapack/interface/laln2.h"
#include "xflens/cxxlapack/interface/lals0.h"
#include "xflens/cxxlapack/interface/lalsa.h"
#include "xflens/cxxlapack/interface/lalsd.h"
#include "xflens/cxxlapack/interface/lamch.h"
#include "xflens/cxxlapack/interface/lamrg.h"
#include "xflens/cxxlapack/interface/laneg.h"
#include "xflens/cxxlapack/interface/langb.h"
#include "xflens/cxxlapack/interface/lange.h"
#include "xflens/cxxlapack/interface/langt.h"
#include "xflens/cxxlapack/interface/lanhb.h"
#include "xflens/cxxlapack/interface/lanhe.h"
#include "xflens/cxxlapack/interface/lanhf.h"
#include "xflens/cxxlapack/interface/lanhp.h"
#include "xflens/cxxlapack/interface/lanhs.h"
#include "xflens/cxxlapack/interface/lanht.h"
#include "xflens/cxxlapack/interface/lansb.h"
#include "xflens/cxxlapack/interface/lansf.h"
#include "xflens/cxxlapack/interface/lansp.h"
#include "xflens/cxxlapack/interface/lanst.h"
#include "xflens/cxxlapack/interface/lansy.h"
#include "xflens/cxxlapack/interface/lantb.h"
#include "xflens/cxxlapack/interface/lantp.h"
#include "xflens/cxxlapack/interface/lantr.h"
#include "xflens/cxxlapack/interface/lanv2.h"
#include "xflens/cxxlapack/interface/lapll.h"
#include "xflens/cxxlapack/interface/lapmr.h"
#include "xflens/cxxlapack/interface/lapmt.h"
#include "xflens/cxxlapack/interface/la_porcond_c.h"
#include "xflens/cxxlapack/interface/la_porcond.h"
#include "xflens/cxxlapack/interface/la_porcond_x.h"
#include "xflens/cxxlapack/interface/la_porpvgrw.h"
#include "xflens/cxxlapack/interface/lapy2.h"
#include "xflens/cxxlapack/interface/lapy3.h"
#include "xflens/cxxlapack/interface/laqgb.h"
#include "xflens/cxxlapack/interface/laqge.h"
#include "xflens/cxxlapack/interface/laqhb.h"
#include "xflens/cxxlapack/interface/laqhe.h"
#include "xflens/cxxlapack/interface/laqhp.h"
#include "xflens/cxxlapack/interface/laqp2.h"
#include "xflens/cxxlapack/interface/laqps.h"
#include "xflens/cxxlapack/interface/laqr0.h"
#include "xflens/cxxlapack/interface/laqr1.h"
#include "xflens/cxxlapack/interface/laqr2.h"
#include "xflens/cxxlapack/interface/laqr3.h"
#include "xflens/cxxlapack/interface/laqr4.h"
#include "xflens/cxxlapack/interface/laqr5.h"
#include "xflens/cxxlapack/interface/laqsb.h"
#include "xflens/cxxlapack/interface/laqsp.h"
#include "xflens/cxxlapack/interface/laqsy.h"
#include "xflens/cxxlapack/interface/laqtr.h"
#include "xflens/cxxlapack/interface/lar1v.h"
#include "xflens/cxxlapack/interface/lar2v.h"
#include "xflens/cxxlapack/interface/larcm.h"
#include "xflens/cxxlapack/interface/larfb.h"
#include "xflens/cxxlapack/interface/larfg.h"
#include "xflens/cxxlapack/interface/larfgp.h"
#include "xflens/cxxlapack/interface/larf.h"
#include "xflens/cxxlapack/interface/larft.h"
#include "xflens/cxxlapack/interface/larfx.h"
#include "xflens/cxxlapack/interface/largv.h"
#include "xflens/cxxlapack/interface/larnv.h"
#include "xflens/cxxlapack/interface/la_rpvgrw.h"
#include "xflens/cxxlapack/interface/larra.h"
#include "xflens/cxxlapack/interface/larrb.h"
#include "xflens/cxxlapack/interface/larrc.h"
#include "xflens/cxxlapack/interface/larrd.h"
#include "xflens/cxxlapack/interface/larre.h"
#include "xflens/cxxlapack/interface/larrf.h"
#include "xflens/cxxlapack/interface/larrj.h"
#include "xflens/cxxlapack/interface/larrk.h"
#include "xflens/cxxlapack/interface/larrr.h"
#include "xflens/cxxlapack/interface/larrv.h"
#include "xflens/cxxlapack/interface/larscl2.h"
#include "xflens/cxxlapack/interface/lartg.h"
#include "xflens/cxxlapack/interface/lartgp.h"
#include "xflens/cxxlapack/interface/lartgs.h"
#include "xflens/cxxlapack/interface/lartv.h"
#include "xflens/cxxlapack/interface/laruv.h"
#include "xflens/cxxlapack/interface/larzb.h"
#include "xflens/cxxlapack/interface/larz.h"
#include "xflens/cxxlapack/interface/larzt.h"
#include "xflens/cxxlapack/interface/las2.h"
#include "xflens/cxxlapack/interface/lascl2.h"
#include "xflens/cxxlapack/interface/lascl.h"
#include "xflens/cxxlapack/interface/lasd0.h"
#include "xflens/cxxlapack/interface/lasd1.h"
#include "xflens/cxxlapack/interface/lasd2.h"
#include "xflens/cxxlapack/interface/lasd3.h"
#include "xflens/cxxlapack/interface/lasd4.h"
#include "xflens/cxxlapack/interface/lasd5.h"
#include "xflens/cxxlapack/interface/lasd6.h"
#include "xflens/cxxlapack/interface/lasd7.h"
#include "xflens/cxxlapack/interface/lasd8.h"
#include "xflens/cxxlapack/interface/lasda.h"
#include "xflens/cxxlapack/interface/lasdq.h"
#include "xflens/cxxlapack/interface/lasdt.h"
#include "xflens/cxxlapack/interface/laset.h"
#include "xflens/cxxlapack/interface/lasq1.h"
#include "xflens/cxxlapack/interface/lasq2.h"
#include "xflens/cxxlapack/interface/lasq3.h"
#include "xflens/cxxlapack/interface/lasq4.h"
#include "xflens/cxxlapack/interface/lasq5.h"
#include "xflens/cxxlapack/interface/lasq6.h"
#include "xflens/cxxlapack/interface/lasr.h"
#include "xflens/cxxlapack/interface/lasrt.h"
#include "xflens/cxxlapack/interface/lassq.h"
#include "xflens/cxxlapack/interface/lasv2.h"
#include "xflens/cxxlapack/interface/laswp.h"
#include "xflens/cxxlapack/interface/lasy2.h"
#include "xflens/cxxlapack/interface/la_syamv.h"
#include "xflens/cxxlapack/interface/lasyf.h"
#include "xflens/cxxlapack/interface/la_syrcond_c.h"
#include "xflens/cxxlapack/interface/la_syrcond.h"
#include "xflens/cxxlapack/interface/la_syrcond_x.h"
#include "xflens/cxxlapack/interface/la_syrpvgrw.h"
#include "xflens/cxxlapack/interface/lat2c.h"
#include "xflens/cxxlapack/interface/lat2s.h"
#include "xflens/cxxlapack/interface/latbs.h"
#include "xflens/cxxlapack/interface/latdf.h"
#include "xflens/cxxlapack/interface/latps.h"
#include "xflens/cxxlapack/interface/latrd.h"
#include "xflens/cxxlapack/interface/latrs.h"
#include "xflens/cxxlapack/interface/latrz.h"
#include "xflens/cxxlapack/interface/latzm.h"
#include "xflens/cxxlapack/interface/lauu2.h"
#include "xflens/cxxlapack/interface/lauum.h"
#include "xflens/cxxlapack/interface/la_wwaddw.h"
#include "xflens/cxxlapack/interface/lsame.h"
#include "xflens/cxxlapack/interface/lsamen.h"
#include "xflens/cxxlapack/interface/opgtr.h"
#include "xflens/cxxlapack/interface/opmtr.h"
#include "xflens/cxxlapack/interface/orbdb.h"
#include "xflens/cxxlapack/interface/orcsd.h"
#include "xflens/cxxlapack/interface/org2l.h"
#include "xflens/cxxlapack/interface/org2r.h"
#include "xflens/cxxlapack/interface/orgbr.h"
#include "xflens/cxxlapack/interface/orghr.h"
#include "xflens/cxxlapack/interface/orgl2.h"
#include "xflens/cxxlapack/interface/orglq.h"
#include "xflens/cxxlapack/interface/orgql.h"
#include "xflens/cxxlapack/interface/orgqr.h"
#include "xflens/cxxlapack/interface/orgr2.h"
#include "xflens/cxxlapack/interface/orgrq.h"
#include "xflens/cxxlapack/interface/orgtr.h"
#include "xflens/cxxlapack/interface/orm2l.h"
#include "xflens/cxxlapack/interface/orm2r.h"
#include "xflens/cxxlapack/interface/ormbr.h"
#include "xflens/cxxlapack/interface/ormhr.h"
#include "xflens/cxxlapack/interface/orml2.h"
#include "xflens/cxxlapack/interface/ormlq.h"
#include "xflens/cxxlapack/interface/ormql.h"
#include "xflens/cxxlapack/interface/ormqr.h"
#include "xflens/cxxlapack/interface/ormr2.h"
#include "xflens/cxxlapack/interface/ormr3.h"
#include "xflens/cxxlapack/interface/ormrq.h"
#include "xflens/cxxlapack/interface/ormrz.h"
#include "xflens/cxxlapack/interface/ormtr.h"
#include "xflens/cxxlapack/interface/pbcon.h"
#include "xflens/cxxlapack/interface/pbequ.h"
#include "xflens/cxxlapack/interface/pbrfs.h"
#include "xflens/cxxlapack/interface/pbstf.h"
#include "xflens/cxxlapack/interface/pbsv.h"
#include "xflens/cxxlapack/interface/pbsvx.h"
#include "xflens/cxxlapack/interface/pbtf2.h"
#include "xflens/cxxlapack/interface/pbtrf.h"
#include "xflens/cxxlapack/interface/pbtrs.h"
#include "xflens/cxxlapack/interface/pftrf.h"
#include "xflens/cxxlapack/interface/pftri.h"
#include "xflens/cxxlapack/interface/pftrs.h"
#include "xflens/cxxlapack/interface/pocon.h"
#include "xflens/cxxlapack/interface/poequb.h"
#include "xflens/cxxlapack/interface/poequ.h"
#include "xflens/cxxlapack/interface/porfs.h"
#include "xflens/cxxlapack/interface/posv.h"
#include "xflens/cxxlapack/interface/posvx.h"
#include "xflens/cxxlapack/interface/potf2.h"
#include "xflens/cxxlapack/interface/potrf.h"
#include "xflens/cxxlapack/interface/potri.h"
#include "xflens/cxxlapack/interface/potrs.h"
#include "xflens/cxxlapack/interface/ppcon.h"
#include "xflens/cxxlapack/interface/ppequ.h"
#include "xflens/cxxlapack/interface/pprfs.h"
#include "xflens/cxxlapack/interface/ppsv.h"
#include "xflens/cxxlapack/interface/ppsvx.h"
#include "xflens/cxxlapack/interface/pptrf.h"
#include "xflens/cxxlapack/interface/pptri.h"
#include "xflens/cxxlapack/interface/pptrs.h"
#include "xflens/cxxlapack/interface/pstf2.h"
#include "xflens/cxxlapack/interface/pstrf.h"
#include "xflens/cxxlapack/interface/ptcon.h"
#include "xflens/cxxlapack/interface/pteqr.h"
#include "xflens/cxxlapack/interface/ptrfs.h"
#include "xflens/cxxlapack/interface/ptsv.h"
#include "xflens/cxxlapack/interface/ptsvx.h"
#include "xflens/cxxlapack/interface/pttrf.h"
#include "xflens/cxxlapack/interface/pttrs.h"
#include "xflens/cxxlapack/interface/ptts2.h"
#include "xflens/cxxlapack/interface/rot.h"
#include "xflens/cxxlapack/interface/rscl.h"
#include "xflens/cxxlapack/interface/sbevd.h"
#include "xflens/cxxlapack/interface/sbev.h"
#include "xflens/cxxlapack/interface/sbevx.h"
#include "xflens/cxxlapack/interface/sbgst.h"
#include "xflens/cxxlapack/interface/sbgvd.h"
#include "xflens/cxxlapack/interface/sbgv.h"
#include "xflens/cxxlapack/interface/sbgvx.h"
#include "xflens/cxxlapack/interface/sbtrd.h"
#include "xflens/cxxlapack/interface/sfrk.h"
#include "xflens/cxxlapack/interface/sgesv.h"
#include "xflens/cxxlapack/interface/spevd.h"
#include "xflens/cxxlapack/interface/spev.h"
#include "xflens/cxxlapack/interface/spevx.h"
#include "xflens/cxxlapack/interface/spgst.h"
#include "xflens/cxxlapack/interface/spgvd.h"
#include "xflens/cxxlapack/interface/spgv.h"
#include "xflens/cxxlapack/interface/spgvx.h"
#include "xflens/cxxlapack/interface/spmv.h"
#include "xflens/cxxlapack/interface/sposv.h"
#include "xflens/cxxlapack/interface/sprfs.h"
#include "xflens/cxxlapack/interface/spr.h"
#include "xflens/cxxlapack/interface/spsv.h"
#include "xflens/cxxlapack/interface/spsvx.h"
#include "xflens/cxxlapack/interface/sptrd.h"
#include "xflens/cxxlapack/interface/sptrf.h"
#include "xflens/cxxlapack/interface/sptri.h"
#include "xflens/cxxlapack/interface/sptrs.h"
#include "xflens/cxxlapack/interface/stebz.h"
#include "xflens/cxxlapack/interface/stedc.h"
#include "xflens/cxxlapack/interface/stegr.h"
#include "xflens/cxxlapack/interface/stein.h"
#include "xflens/cxxlapack/interface/stemr.h"
#include "xflens/cxxlapack/interface/steqr.h"
#include "xflens/cxxlapack/interface/sterf.h"
#include "xflens/cxxlapack/interface/stevd.h"
#include "xflens/cxxlapack/interface/stev.h"
#include "xflens/cxxlapack/interface/stevr.h"
#include "xflens/cxxlapack/interface/stevx.h"
#include "xflens/cxxlapack/interface/sycon.h"
#include "xflens/cxxlapack/interface/syconv.h"
#include "xflens/cxxlapack/interface/syequb.h"
#include "xflens/cxxlapack/interface/syevd.h"
#include "xflens/cxxlapack/interface/syev.h"
#include "xflens/cxxlapack/interface/syevr.h"
#include "xflens/cxxlapack/interface/syevx.h"
#include "xflens/cxxlapack/interface/sygs2.h"
#include "xflens/cxxlapack/interface/sygst.h"
#include "xflens/cxxlapack/interface/sygvd.h"
#include "xflens/cxxlapack/interface/sygv.h"
#include "xflens/cxxlapack/interface/sygvx.h"
#include "xflens/cxxlapack/interface/symv.h"
#include "xflens/cxxlapack/interface/syrfs.h"
#include "xflens/cxxlapack/interface/syr.h"
#include "xflens/cxxlapack/interface/sysv.h"
#include "xflens/cxxlapack/interface/sysvx.h"
#include "xflens/cxxlapack/interface/syswapr.h"
#include "xflens/cxxlapack/interface/sytd2.h"
#include "xflens/cxxlapack/interface/sytf2.h"
#include "xflens/cxxlapack/interface/sytrd.h"
#include "xflens/cxxlapack/interface/sytrf.h"
#include "xflens/cxxlapack/interface/sytri2.h"
#include "xflens/cxxlapack/interface/sytri2x.h"
#include "xflens/cxxlapack/interface/sytri.h"
#include "xflens/cxxlapack/interface/sytrs2.h"
#include "xflens/cxxlapack/interface/sytrs.h"
#include "xflens/cxxlapack/interface/tbcon.h"
#include "xflens/cxxlapack/interface/tbrfs.h"
#include "xflens/cxxlapack/interface/tbtrs.h"
#include "xflens/cxxlapack/interface/tfsm.h"
#include "xflens/cxxlapack/interface/tftri.h"
#include "xflens/cxxlapack/interface/tfttp.h"
#include "xflens/cxxlapack/interface/tfttr.h"
#include "xflens/cxxlapack/interface/tgevc.h"
#include "xflens/cxxlapack/interface/tgex2.h"
#include "xflens/cxxlapack/interface/tgexc.h"
#include "xflens/cxxlapack/interface/tgsen.h"
#include "xflens/cxxlapack/interface/tgsja.h"
#include "xflens/cxxlapack/interface/tgsna.h"
#include "xflens/cxxlapack/interface/tgsy2.h"
#include "xflens/cxxlapack/interface/tgsyl.h"
#include "xflens/cxxlapack/interface/tpcon.h"
#include "xflens/cxxlapack/interface/tprfs.h"
#include "xflens/cxxlapack/interface/tptri.h"
#include "xflens/cxxlapack/interface/tptrs.h"
#include "xflens/cxxlapack/interface/tpttf.h"
#include "xflens/cxxlapack/interface/tpttr.h"
#include "xflens/cxxlapack/interface/trcon.h"
#include "xflens/cxxlapack/interface/trevc.h"
#include "xflens/cxxlapack/interface/trexc.h"
#include "xflens/cxxlapack/interface/trrfs.h"
#include "xflens/cxxlapack/interface/trsen.h"
#include "xflens/cxxlapack/interface/trsna.h"
#include "xflens/cxxlapack/interface/trsyl.h"
#include "xflens/cxxlapack/interface/trti2.h"
#include "xflens/cxxlapack/interface/trtri.h"
#include "xflens/cxxlapack/interface/trtrs.h"
#include "xflens/cxxlapack/interface/trttf.h"
#include "xflens/cxxlapack/interface/trttp.h"
#include "xflens/cxxlapack/interface/tzrqf.h"
#include "xflens/cxxlapack/interface/tzrzf.h"
#include "xflens/cxxlapack/interface/unbdb.h"
#include "xflens/cxxlapack/interface/uncsd.h"
#include "xflens/cxxlapack/interface/ung2l.h"
#include "xflens/cxxlapack/interface/ung2r.h"
#include "xflens/cxxlapack/interface/ungbr.h"
#include "xflens/cxxlapack/interface/unghr.h"
#include "xflens/cxxlapack/interface/ungl2.h"
#include "xflens/cxxlapack/interface/unglq.h"
#include "xflens/cxxlapack/interface/ungql.h"
#include "xflens/cxxlapack/interface/ungqr.h"
#include "xflens/cxxlapack/interface/ungr2.h"
#include "xflens/cxxlapack/interface/ungrq.h"
#include "xflens/cxxlapack/interface/ungtr.h"
#include "xflens/cxxlapack/interface/unm2l.h"
#include "xflens/cxxlapack/interface/unm2r.h"
#include "xflens/cxxlapack/interface/unmbr.h"
#include "xflens/cxxlapack/interface/unmhr.h"
#include "xflens/cxxlapack/interface/unml2.h"
#include "xflens/cxxlapack/interface/unmlq.h"
#include "xflens/cxxlapack/interface/unmql.h"
#include "xflens/cxxlapack/interface/unmqr.h"
#include "xflens/cxxlapack/interface/unmr2.h"
#include "xflens/cxxlapack/interface/unmr3.h"
#include "xflens/cxxlapack/interface/unmrq.h"
#include "xflens/cxxlapack/interface/unmrz.h"
#include "xflens/cxxlapack/interface/unmtr.h"
#include "xflens/cxxlapack/interface/upgtr.h"
#include "xflens/cxxlapack/interface/upmtr.h"
#include "xflens/cxxlapack/interface/zsum1.h"

#endif // CXXLAPACK_INTERFACE_INTERFACE_H
