#! /usr/bin/perl -w


# Ham Radio Country info module ctyinfo.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C)  2006
#       Rein Couperus PA0R (rein at couperus.com)
# 
# *    ctyinfo.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    ctyinfo.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 03-04-06

#####################################################
=head1 Data description

Function: getinfo()

Input:
$call

Output:
@infoarray, country info array, holding:
	0 - Name
	1 - CQ zone
	2 - ITU zone
	3 - Continent
	4 - Latitude
	5 - Longitude
	6 - time difference
	7 - basic cty prefix
	8 - prefix
	9 - district
	10 - ctyindex
	11 - distance
	12 - azimuth

ctyinfo.pm uses cty.dat as data input file.
	
=cut

####################################################

use rules;

# some globals:
my %ctycall = ();
my %cqzonehash = ();
my %ituzonehash= ();
my @info = ();
$pi=3.14159265;

#test_info();


$test = 1;

####### end module #################################

####################################################
sub getctymultinfo {
####################################################
return @info;
}




{ # start block
	my @infoarray=();
####################################################
sub getinfo { # out = @infoarray
####################################################
#use:		@outprint = getinfo($call); 
####################################################
	my $call = shift @_;
		$call =~ tr/a-z/A-Z/;
		my $frag = getctyfmcall($call);
		my $district = getdistrict($frag);
		my $ctyindex = getcty($frag);
		my $prefix = getpfx($frag);
	
	$infoarray[0] = $info[$ctyindex][0];
	$infoarray[1] = $info[$ctyindex][1];
	$infoarray[2] = $info[$ctyindex][2];
	$infoarray[3] = $info[$ctyindex][3];
	$infoarray[4] = $info[$ctyindex][4];
	$infoarray[5] = $info[$ctyindex][5];
	$infoarray[6] = $info[$ctyindex][6];
	$infoarray[7] = $info[$ctyindex][7];
	$infoarray[8] = $prefix;
	$infoarray[9] = $district;
	$infoarray[10] = $ctyindex;
	$infoarray[11] = $info[$ctyindex][11];
	$infoarray[12] = $info[$ctyindex][12];
	
	my $cqzone = getcq($call);
	if ($cqzone) { $infoarray[1] = $cqzone; }
	my $ituzone = getitu($call);
	if ($ituzone) { $infoarray[2] = $ituzone; }

	return @infoarray;
}
} # end block

####################################################
sub getcty { # out = cntrynr for $info[x][0...8]
####################################################
	my $call = shift @_;
	my $out_index = -1;
	for ($i = 1; $i <= length($call) ; $i++) {
	
		$testcall = substr($call, 0, $i);
		if (defined ($ctycall{$testcall})) {
			$out_index = $ctycall{$testcall};
		} 
	}
	return $out_index;	

}

####################################################
sub getcq { # out = cq zone for $cqzonehash{$call}
####################################################
	my $call = shift @_;
	my $out_index = "";
	if (length ($call) < 4) {
		return "";
	}
	for ($i = 3; $i <= length($call) ; $i++) {
	
		$testcall = substr($call, 0, $i);
		if (defined ($cqzonehash{$testcall})) {
			$out_index = $cqzonehash{$testcall};
		}
	} 
	return $out_index;
}

####################################################
sub getitu { # out = cq zone for $cqzonehash{$call}
####################################################
	my $call = shift @_;
	my $out_index = "";
	if (length ($call) < 4) {
		return "";
	}
	for ($i = 3; $i <= length($call) ; $i++) {
	
		$testcall = substr($call, 0, $i);
		if (defined ($ituzonehash{$testcall})) {
			$out_index = $ituzonehash{$testcall};
		}
	} 
	return $out_index;
}

##########################################
sub getctyfmcall { 
##########################################
# PA/DJ0LN/P = PA
# PA/DJ0LN/QRP = PA
# PA/DJ0LN/M = PA
# PA/DJ0LN/MM = PA
# PA/DJ0LN = PA
# DJ0LN/PA = PA
# VE3EJ/8 = VE
##########################################
my $call = shift @_;
my @clfrags = split '/', $call;
my $ctyfrag = '';
my $fragnr = @clfrags;

	if ($fragnr == 3) {
		return $clfrags[0]; 
	} elsif ($fragnr == 2) {
		if (length ($clfrags[1]) == 1) {
			return $call;
		}
		if ($clfrags[1] eq "MM" ||
			$clfrags[1] eq "AM" ||
			$clfrags[1] eq "QRP") {
			return $call;	
		}
		if (length ($clfrags[0]) > length ($clfrags[1])) {
			return $clfrags[1];
		} else {
			return $clfrags[0];
		}
	} else {
		return $call;
	}
}

###########################################
sub getdistrict {
###########################################
	$call = shift @_;
	if ($call =~ /.+\/(\d)/) {
		return $1;
	}
	
	if ($call =~ /\w*(\d)/) {
			return $1;
	}
	return "0";	
}

###########################################
sub getpfx {
###########################################
	$call = shift @_;
	my $prefix = "";
	
	if ($call =~ /^(\d*\w+\d)/) {
		$prefix = $1;
	} elsif ($call =~ /^(\d*\w+)/) {
		$prefix = $1 . "0";
	}
	return $prefix;

}
##########################################
sub initialize_ctydat {
##########################################

my $countrycntr = -1;
my @getcountries = ();
$Ctydatfile = "$ENV{HOME}/.xtlf/cty.dat";
eval {
	open ($fh, $Ctydatfile) or die "Cannot find cty.dat file!";
	@getcountries = <$fh>;
	close ($fh);
};
if ($@) {
	print "$@";
}

	foreach my $line (@getcountries) {
		if ($line =~ /(.*):\s*(\d*):\s*(\d*):\s*(\w\w):\s*(-*\d*\.\d*):\s*(-*\d*\.\d*):\s*(-*\d*\.\d*):\s*(.*):/) {
				$countrycntr++;
				$info[$countrycntr][0] = $1;
				$info[$countrycntr][1] = $2;
				$info[$countrycntr][2] = $3;
				$info[$countrycntr][3] = $4;
				$info[$countrycntr][4] = $5;
				$info[$countrycntr][5] = $6;
				$info[$countrycntr][6] = $7;
				$info[$countrycntr][7] = $8;
				$frag = $8;
				
		}elsif ($line =~ /\s\s\s\s(.*)\;*/) {
				my $line = $1;
				chop $line;
				@frags = split ',', $line;
				foreach $frag (@frags) {
					if ($frag =~ /((\w*)\((\d*)\)\[(\d*)\])/) {
						$frag = $2;
						$cqzonehash{$frag} = $3;
						$ituzonehash{$frag} = $4;
					} elsif ($frag =~ /(\w*)\((\d*)\)/) {
						$frag = $1;
						$cqzonehash{$frag} = $2;
					} elsif ($frag =~ /(\w*)\[(\d*)\]/) {
						$frag = $1;
						$ituzonehash{$frag} = $2;
					} 
					
					$ctycall{$frag} = $countrycntr;
					
					select undef, undef, undef, 0.001;
				}
		}

		
	}
	
#	if ($Mycall eq "") {

		my $input = "";
		eval {
			my @messages = ();
			open ($fh, "$ENV{HOME}/.xtlf/config") or die "Cannot find config\n";
			while (<$fh>) {
				if (/=(~*)(.*)/) {
					if ($1) {
						$input = "$ENV{HOME}" . $2;
					} else {
						$input = $2;
					}
					push @messages, $input;
				}
			}
			close ($fh);
			
			$Mycall = $messages[0];
			$logfile = $messages[1];
			$Ctydatfile = $messages[2];
			$Callmasterfile = $messages[3];
			$Rtty_infile = $messages[4];
			$Rtty_outfile = $messages[5];

		};
		if ($@) {
			print $@;
		}

#	}
	
	my @owninfo = getinfo($Mycall);
	my $Mylatitude = $owninfo[4];
	my $Mylongitude = $owninfo[5];

	for ($i = 0; $i <=  $countrycntr; $i++) {
		my $latitude = $info[$i][4];
		my $longitude = $info[$i][5];
		($info[$i][11], $info[$i][12]) = getdistance($Mylatitude,$Mylongitude, $latitude, $longitude);
	}

}

##############################################################
sub getdistance {
##############################################################
my ($mylatitude,$mylongitude, $latitude, $longitude) = @_;

	$lat1 = $mylatitude /360 * 2 * $pi;
	$long1 = $mylongitude / 360 * -2 * $pi;
	$lat2 = $latitude / 360 * 2 * $pi;
	$long2 = $longitude / 360 * -2 * $pi;

$dist = great_circle_distance($lat1,$long1,$lat2,$long2);

$head = initial_heading($lat1,$long1,$lat2,$long2);

return (int ($dist / 1000), int($head * 360 / (2 * $pi)));
}


##################################################################
# given coordinates of two places in radians, compute distance in meters
sub great_circle_distance {
##################################################################
    my ($lat1,$long1,$lat2,$long2) = @_;

    # approx radius of Earth in meters.  True radius varies from
    # 6357km (polar) to 6378km (equatorial).
    my $earth_radius = 6367000;

    my $dlon = $long2 - $long1;
    my $dlat = $lat2 - $lat1;
    my $a = (sin($dlat / 2)) ** 2 
	    + cos($lat1) * cos($lat2) * (sin($dlon / 2)) ** 2;
    my $d = 2 * atan2(sqrt($a), sqrt(1 - $a));

    # This is a simpler formula, but it's subject to rounding errors
    # for small distances.  See http://www.census.gov/cgi-bin/geo/gisfaq?Q5.1
    # my $d = &acos2(sin($lat1) * sin($lat2)
    #               + cos($lat1) * cos($lat2) * cos($long1-$long2));

    return $earth_radius * $d;
}

###################################################################
# compute the initial bearing (in radians) to get from lat1/long1 to lat2/long2
sub initial_heading {
###################################################################
    my ($lat1,$long1,$lat2,$long2) = @_;

	if ($lat1 == $lat2 && $long1 == $long2) {
		return 0;
	}

    # note that this is the same $d calculation as above.  
    # duplicated for clarity.
    my $dlon = $long2 - $long1;
    my $dlat = $lat2 - $lat1;
    my $a = (sin($dlat / 2)) ** 2 
	    + cos($lat1) * cos($lat2) * (sin($dlon / 2)) ** 2;
    my $d = 2 * atan2(sqrt($a), sqrt(1 - $a));
    
#    eval {
	    my $heading = acos2((sin($lat2) - sin($lat1) * cos($d)) / (sin($d) * cos($lat1)));
#    };
    
    if (sin($long2 - $long1) < 0) {
	$heading = 2 * $pi - $heading;
    }
    return $heading;
}
##################################################################

# return an angle in radians, between 0 and pi, whose cosine is x
sub acos2 {
    my($x) = @_;
    die "bad acos argument ($x)\n" if (abs($x) > 1.0);
    return atan2(sqrt(1 - $x * $x), $x);
}


##########################################
sub test_info {
##########################################
	while (1) {
		print "Enter Call:";
		my $call = <STDIN>;
		chomp $call;
		if ($call eq "q") {
			last;
		} else {
			my @outprint  = getinfo($call);
			
			print "Country  : $outprint[0]\n"; 
			print "CQ zone  : $outprint[1]\n"; 
			print "ITU zone : $outprint[2]\n"; 
			print "Continent: $outprint[3]\n"; 
			print "Latitude : $outprint[4]\n"; 
			print "Longitude: $outprint[5]\n"; 
			print "Time diff: $outprint[6]\n"; 
			print "Cty pfx  : $outprint[7]\n"; 
			print "PFX      : $outprint[8]\n"; 
			print "District : $outprint[9]\n\n"; 
		}
	}
}
1;
##########################################
