# Ham Radio Country info module qso.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    qso.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    qso.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 07-04-06

use Switch;

################# qso numbers per band ################
{ # start qso block

	$qsos_160 = 0;
	$qsos_80 = 0;
	$qsos_40 = 0;
	$qsos_20 = 0;
	$qsos_15 = 0;
	$qsos_10 = 0;
	$qsos_all = 0;

#############################################
sub init_qso {
#############################################
	$qsos_160 = 0;
	$qsos_80 = 0;
	$qsos_40 = 0;
	$qsos_20 = 0;
	$qsos_15 = 0;
	$qsos_10 = 0;
	$qsos_all = 0;

}

#############################################
sub addqso {
#############################################
	$band = shift @_;
	
	switch ($band) {
	case 160 { $qsos_160++; }
	case  80 { $qsos_80++; }
	case  40 { $qsos_40++; }
	case  20 { $qsos_20++; }
	case  15 { $qsos_15++; }
	case  10 { $qsos_10++; }
	}
}


############################################
sub delqso {
############################################

}

############################################
sub countqso {
############################################
 my @out = ();
 
 	push @out, $qsos_160;
 	push @out, $qsos_80;
 	push @out, $qsos_40;
 	push @out, $qsos_20;
 	push @out, $qsos_15;
 	push @out, $qsos_10;
 	
 	return @out;	
}
} # end block 

{ # start cw qso block


	$cwqsos_160 = 0;
	$cwqsos_80 = 0;
	$cwqsos_40 = 0;
	$cwqsos_20 = 0;
	$cwqsos_15 = 0;
	$cwqsos_10 = 0;
	$cwqsos_all = 0;

#############################################
sub addcwqso {
#############################################
	$band = shift @_;
	
	switch ($band) {
	case 160 { $cwqsos_160++; }
	case  80 { $cwqsos_80++; }
	case  40 { $cwqsos_40++; }
	case  20 { $cwqsos_20++; }
	case  15 { $cwqsos_15++; }
	case  10 { $cwqsos_10++; }
	}
}
############################################
sub countcwqso {
############################################
 my @out = ();
 
 	push @out, $cwqsos_160;
 	push @out, $cwqsos_80;
 	push @out, $cwqsos_40;
 	push @out, $cwqsos_20;
 	push @out, $cwqsos_15;
 	push @out, $cwqsos_10;
 	
 	return @out;	
}
#############################################
sub init_cwqso {
#############################################
	$cwqsos_160 = 0;
	$cwqsos_80 = 0;
	$cwqsos_40 = 0;
	$cwqsos_20 = 0;
	$cwqsos_15 = 0;
	$cwqsos_10 = 0;
	$cwqsos_all = 0;
}


} # end block 


{ # start ssb qso block

	$ssbqsos_160 = 0;
	$ssbqsos_80 = 0;
	$ssbqsos_40 = 0;
	$ssbqsos_20 = 0;
	$ssbqsos_15 = 0;
	$ssbqsos_10 = 0;
	$ssbqsos_all = 0;

#############################################
sub addssbqso {
#############################################
	$band = shift @_;
	
	switch ($band) {
	case 160 { $ssbqsos_160++; }
	case  80 { $ssbqsos_80++; }
	case  40 { $ssbqsos_40++; }
	case  20 { $ssbqsos_20++; }
	case  15 { $ssbqsos_15++; }
	case  10 { $ssbqsos_10++; }
	}
}
############################################
sub countssbqso {
############################################
 my @out = ();
 
 	push @out, $ssbqsos_160;
 	push @out, $ssbqsos_80;
 	push @out, $ssbqsos_40;
 	push @out, $ssbqsos_20;
 	push @out, $ssbqsos_15;
 	push @out, $ssbqsos_10;
 	
 	return @out;	
}
#############################################
sub init_ssbqso {
#############################################
	$ssbqsos_160 = 0;
	$ssbqsos_80 = 0;
	$ssbqsos_40 = 0;
	$ssbqsos_20 = 0;
	$ssbqsos_15 = 0;
	$ssbqsos_10 = 0;
	$ssbqsos_all = 0;
}


} # end block 

1;
