#! /usr/bin/perl -w


# Ham Radio Contest Multiplier module yudx.pm by DJ1YFK

# This program is published under the GPL license.
#   Copyright (C) 2006
#       Fabian Kurz, DJ1YFK
# 
# *    yudx.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    yudx.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 07-04-06

use rules;

my %yupfxes;		# hash, example  $yupfxes{"YU7"}{"80"} = 1 (QSOs)

############## Receives a callsign and band, returns the Prefix, if it's a
# new YU-Prefix ############################################################
sub addyupfxmult {
		my  $call = shift;
		$call =~ s/\/(P|M|QRP)$//g;						# remove /P etc
		my $band = shift;
		
	if ($call =~ /^(YT|YU|YZ|4N|4O)/) {					# YU Callsign
		$call =~ /^([Y4][TUZNO]\d{1,5})/;
		my $pfx = $1;
		if (defined($yupfxes{$pfx}{$band})) {
			$yupfxes{$pfx}{$band}++;
			return '';									# no new pfx
		}
		else {
			$yupfxes{$pfx}{$band}=1;
			return $pfx;
		}
	}
	else { return '';}
}

############## Receives a callsign and band, deleted the prefix from the 
# hash, if YU-Prefix #####################################################
# is this needed? delcqzones is implemented, but never used anywhere? 

sub delyupfxmult {
		my  $call = shift;
		$call =~ s/\/(P|M|QRP)$//g;						# remove /P etc
		my $band = shift;
		
	if ($call =~ /^((YT|YU|YZ|4N|4O)\d+)[A-Z]+$/) {		# YU Callsign
		my $pfx = $1;
		if (defined($yupfxes{$pfx}{$band})) {
			$yupfxes{$pfx}{$band}--;					# remove from hash
			return 1;
		}
	}
	return 0;
}
##########################################################################
sub init_yupfx {
##########################################################################
%yupfxes = ();	
}
##########################################################################
# counts the prefixes, returns an array with nr of pfxes for each band 
#
# The yupfxes-hash looks like this for example. Wanted: PFX/band, saved in
# "pfxnr" hash. 
#
# $yupfxes | 160 |  80 |  40 |  20 | ...
# ---------+-----+-----+-----+-----+
#  YU1     |  50 |  13 |  56 |  45 |
#  YU7     |   1 |   0 |   3 |   0 |
#  YZ1     |   0 |   1 |   3 |   4 |
# ---------+-----+-----+-----+-----+
# PFXs     |  2  |   2 |   3 |   2 |
# 

sub count_yupfxes {
	my @pfxnr; 			# keys=bands, values= nr of prefixes on the band  
		
	for (10,15,20,40,80,160) { $pfxnr[$_] =0;}		# initialize pfx array

	while (my ($pfx, $band) = each %yupfxes) {
		foreach my $bnd (keys %$band) {
			if ($band->{$bnd}) {        # QSO on this band (cud be deleted=0!)
				$pfxnr[$bnd]++;
			}
		}
	}

	return ($pfxnr[160],$pfxnr[80],$pfxnr[40],$pfxnr[20],$pfxnr[15],$pfxnr[10]);
}

1;
