/****************************************************************************
 *
 * 			camera.h: Camera implementation api
 *      This is part of the yafray package
 *      Copyright (C) 2002  Alejandro Conty Estvez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef __CAMERA_H
#define __CAMERA_H

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include "vector3d.h"
#include "matrix4.h"
#include "mcqmc.h"
#include<vector>

__BEGIN_YAFRAY

class camera_t
{
	public:
		camera_t(const point3d_t &pos,const point3d_t &look,
			const point3d_t &up,int _resx,int _resy,PFLOAT df=1, PFLOAT ap=0, bool useq=false);
		~camera_t() {};
		int resX() const {return resx;};
		int resY() const {return resy;};
		const point3d_t & position() const {return _position;};
		vector3d_t shootRay(PFLOAT px, PFLOAT py);
		PFLOAT getFocal()const { return focal_distance; };
	protected:
		point3d_t _eye, _position;
		PFLOAT focal_distance;
		vector3d_t vto, vup, vright;
		int resx, resy;
		PFLOAT xXr, yYr, yratio;
		PFLOAT fdist, aperture;
		bool use_qmc;
		Halton HSEQ1, HSEQ2;
};

matrix4x4_t ZtoRay(const vector3d_t & ray,const vector3d_t &up);

__END_YAFRAY

#endif

