/****************************************************************************
 *
 * 			mesh.h: Mesh object api 
 *      This is part of the yafray package
 *      Copyright (C) 2002  Alejandro Conty Estvez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *      
 */
#ifndef __MESH_H
#define __MESH_H

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include "object3d.h"
#include "vector3d.h"
#include "triangle.h"
#include <vector>


__BEGIN_YAFRAY

struct mray_t
{
	point3d_t from;
	vector3d_t ray;
};


struct rayCross_f
{
	bool operator() (const mray_t &m,const bound_t &b) {return b.cross(m.from,m.ray);};
};


class meshObject_t : public object3d_t
{
	public:
		meshObject_t(std::vector<point3d_t> *ver, std::vector<vector3d_t> *nor,
				std::vector<triangle_t> *ts, std::vector<GFLOAT> *fuv=NULL, std::vector<CFLOAT> *fvcol=NULL);
		meshObject_t(const matrix4x4_t &M, std::vector<point3d_t> *ver,
				std::vector<vector3d_t> *nor, std::vector<triangle_t> *ts,
				std::vector<GFLOAT> *fuv=NULL, std::vector<CFLOAT> *fvcol=NULL);
		meshObject_t()
		{ vertices=NULL;  normals=NULL;  triangles=NULL;  unt=true;
			shader=NULL;  facesuv=NULL;  faces_vcol=NULL;
			tree=NULL;
			hasorco=false;
		}
		void hasOrco(bool b) {hasorco=b;};
		void autoSmooth(PFLOAT angle);
		virtual ~meshObject_t();
		virtual int type() const {return MESH;};
		virtual void transform(const matrix4x4_t &m);
		virtual point3d_t toObject(const point3d_t &p)const;
		virtual vector3d_t toObjectRot(const vector3d_t &v) const;
		virtual point3d_t toObjectOrco(const point3d_t &p) const;
		virtual bool shoot(renderState_t &state,surfacePoint_t &where,const point3d_t &from,
				const vector3d_t &ray,bool shadow=false,PFLOAT dis=-1) const;
		virtual bound_t getBound() const {return bound;};
	protected:
		void recalcBound();
		std::vector<point3d_t> *vertices;
		std::vector<vector3d_t> *normals;
		std::vector<triangle_t> *triangles;
		std::vector<GFLOAT> *facesuv;
		std::vector<CFLOAT> *faces_vcol;
		bound_t bound;
		bool unt,hasorco;
		// backRot -> rotation only matrix
		// backOrco -> orco matrix for texture mapping
		matrix4x4_t back, backRot, backOrco;
		gBoundTreeNode_t<triangle_t *> *tree;
};

__END_YAFRAY
#endif
