//---------------------------------------------------------------------------
// Improved Perlin noise, based on Java reference code by Ken Perlin himself.

#ifndef __NOISE_H
#define __NOISE_H

#include <math.h>
#include "vector3d.h"

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

__BEGIN_YAFRAY

class newPerlin_t
{
public:
  newPerlin_t() { init(); }
  ~newPerlin_t() {}
  PFLOAT noise(const point3d_t &pt) const;
  /// four dimensional version, ignored for now
  /*
  PFLOAT noise(PFLOAT x, PFLOAT y, PFLOAT z, PFLOAT w)
  {
    int X = int(x) & 255,		// FIND UNIT HYPERCUBE
        Y = int(y) & 255,		// THAT CONTAINS POINT.
        Z = int(z) & 255,
        W = int(w) & 255;
    x -= floor(x);			// FIND RELATIVE X,Y,Z,W
    y -= floor(y);			// OF POINT IN CUBE.
    z -= floor(z);
    w -= floor(w);
    PFLOAT a = fade(x),			// COMPUTE FADE CURVES
           b = fade(y),			// FOR EACH OF X,Y,Z,W.
           c = fade(z),
           d = fade(w);
    int A = p[X  ]+Y, AA = p[A]+Z, AB = p[A+1]+Z,	// HASH COORDINATES OF
        B = p[X+1]+Y, BA = p[B]+Z, BB = p[B+1]+Z,	// THE 16 CORNERS OF
        AAA = p[AA]+W, AAB = p[AA+1]+W,			// THE HYPERCUBE.
        ABA = p[AB]+W, ABB = p[AB+1]+W,
        BAA = p[BA]+W, BAB = p[BA+1]+W,
        BBA = p[BB]+W, BBB = p[BB+1]+W;

    return lerp(d,					// INTERPOLATE DOWN.
        lerp(c,lerp(b,lerp(a,grad(p[AAA  ], x  , y  , z  , w),
                             grad(p[BAA  ], x-1, y  , z  , w)),
                      lerp(a,grad(p[ABA  ], x  , y-1, z  , w),
                             grad(p[BBA  ], x-1, y-1, z  , w))),

               lerp(b,lerp(a,grad(p[AAB  ], x  , y  , z-1, w),
                             grad(p[BAB  ], x-1, y  , z-1, w)),
                      lerp(a,grad(p[ABB  ], x  , y-1, z-1, w),
                             grad(p[BBB  ], x-1, y-1, z-1, w)))),

        lerp(c,lerp(b,lerp(a,grad(p[AAA+1], x  , y  , z  , w-1),
                             grad(p[BAA+1], x-1, y  , z  , w-1)),
                      lerp(a,grad(p[ABA+1], x  , y-1, z  , w-1),
                             grad(p[BBA+1], x-1, y-1, z  , w-1))),

               lerp(b,lerp(a,grad(p[AAB+1], x  , y  , z-1, w-1),
                             grad(p[BAB+1], x-1, y  , z-1, w-1)),
                      lerp(a,grad(p[ABB+1], x  , y-1, z-1, w-1),
                             grad(p[BBB+1], x-1, y-1, z-1, w-1)))));
  }
  */
  void init();
  // basic turbulence, half amplitude, double frequency defaults
  // returns value in range (0,1)
  CFLOAT turbulence(const point3d_t &pt, int oct, bool hard=false) const;
  // basic turbulence, variable amplitude & frequency scale
  // returns value in range (0,1)
  CFLOAT turbulence2(const point3d_t &pt, int oct, bool hard=false, 
			PFLOAT ampscale=0.5, PFLOAT freqscale=2.0) const;
protected:
  PFLOAT fade(PFLOAT t) const { return t * t * t * (t * (t * 6 - 15) + 10); }
  PFLOAT lerp(PFLOAT t, PFLOAT a, PFLOAT b) const { return a + t * (b - a); }
  PFLOAT grad(int hash, PFLOAT x, PFLOAT y, PFLOAT z) const
  {
    int h = hash & 15;				// CONVERT LO 4 BITS OF HASH CODE
    PFLOAT u = h<8||h==12||h==13 ? x : y,	// INTO 12 GRADIENT DIRECTIONS.
           v = h<4||h==12||h==13 ? y : z;
    return ((h&1) == 0 ? u : -u) + ((h&2) == 0 ? v : -v);
  }
  // only used in four dimensional counterpart, not used for now
  /*
  PFLOAT grad(int hash, PFLOAT x, PFLOAT y, PFLOAT z, PFLOAT w)
  {
    int h = hash & 31;			// CONVERT LO 5 BITS OF HASH TO 32 GRAD DIRECTIONS.
    PFLOAT a=y,b=z,c=w;			// X,Y,Z
    switch (h >> 3) {			// OR, DEPENDING ON HIGH ORDER 2 BITS:
      case 1: a=w; b=x; c=y; break;	// W,X,Y
      case 2: a=z; b=w; c=x; break;	// Z,W,X
      case 3: a=y; b=z; c=w; break;	// Y,Z,W
    }
    return ((h&4)==0 ? -a:a) + ((h&2)==0 ? -b:b) + ((h&1)==0 ? -c:c);
  }
  */
  // data tables
  //unsigned int permutation[256];
  unsigned int p[512];
};

__END_YAFRAY
//---------------------------------------------------------------------------
#endif  //__NOISE_H
