#ifndef __TOOLS_H
#define __TOOLS_H

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<map>
#include"ccthreads.h"
#include"color.h"
#include"vector3d.h"

__BEGIN_YAFRAY

template<class T>
inline bool validFloat(const T &f)
{
	  return (f<std::numeric_limits<T>::infinity()) &&
          (f>=0);
          //(f>-std::numeric_limits<T>::infinity());
}

inline bool valid(const color_t &c)
{
	return validFloat(c.getRed()) && validFloat(c.getGreen()) && validFloat(c.getBlue());
}

inline bool valid(const vector3d_t &c)
{
	return validFloat(c.x) && validFloat(c.y) && validFloat(c.y);
}

template<class S, class D>
class Conversion
{
	protected:
		typedef int small;
		class big   {int a[2];};
		static small test(D);
		static big test(...);
		static S dummy();
	public:
		static const bool exists=(sizeof(test(dummy()))==sizeof(small));
};

class context_t
{
	public:

		class destructible
		{
			public:
				virtual ~destructible() {};
		};
	protected:
		
		template<class T,bool fits,bool des>
		struct back
		{
				static void store(const T &,T ,std::map<void *,double> &,
						std::map<void *,destructible *> &);
				static T get(const T &,const std::map<void *,double> &,bool present,
						const std::map<void *,destructible *> &);
		};
		template<class T>
		struct back<T,true,false>
		{
				static void store(const T &d,T v,std::map<void *,double> &data,
						std::map<void *,destructible *> &des)
				{
					*((T *)(&data[(void *) &d]))=v;
				};
				static T get(const T &d,const std::map<void *,double> &data,
						bool &present,const std::map<void *,destructible *> &des)
				{
					std::map<void *,double>::const_iterator i=data.find((void *) &d);
					if(i!=data.end()) return *( (T *) &(i->second));
					else {present=false;return T();}
				}
		};
		template<class T>
		struct back<T,true,true>
		{
				static void store(const T &d,T v,std::map<void *,double> &data,
						std::map<void *,destructible *> &des)
				{
					des[(void *)&d]=(destructible *)v;
				};
				static T get(const T &d,const std::map<void *,double> &data,
						bool &present,const std::map<void *,destructible *> &des)
				{
					std::map<void *,destructible *>::const_iterator 
						i=des.find((void *) &d);
					if(i!=des.end()) return (T) i->second;
					else {present=false;return (T)NULL;}
				}
		};

	public:

		template<class T>
		void context_t::store(const T &d,T v)
		{
			back<T,
					sizeof(T)<=sizeof(double),
					Conversion<T,destructible *>::exists>
					::store(d,v,data,destructibles);
		}

		template<class T>
		T get(const T &d)
		{
			bool present=true;
			return back<T,
									sizeof(T)<=sizeof(double),
									Conversion<T,destructible *>::exists>
									::get(d,data,present,destructibles);
		};
		template<class T>
		T get(const T &d,bool &present)
		{
			present=true;
			return back<T,
									sizeof(T)<=sizeof(double),
									Conversion<T,destructible *>::exists>
									::get(d,data,present,destructibles);
		};

		~context_t()
		{
			for(std::map<void *,destructible *>::iterator i=destructibles.begin();
					i!=destructibles.end();++i)
				delete i->second;
		};
		
	protected:

		std::map<void *,double> data;
		std::map<void *,destructible *> destructibles;
};

template<class T>
class locked_t : public T
{
	public:
		void wait() {mutex.wait();};
		void signal() {mutex.signal();};
	protected:
		mutex_t mutex;
};

__END_YAFRAY

#endif
