#!perl -w
#
# OpenFirmwareMapEntry - encapsulate a line from modules.ofmap.
#   this file is bases on PciMapEnty which is
#   Copyright (C) 2005  Erik van Konijnenburg
#   and changed for OpenFirmware by Bernhard R. Link in 2006
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
#
# Knows how to match, can return module name.
#

use strict;
use warnings;
use Base;
package OpenFirmwareMapEntry;
use base 'Obj';

sub fill {
	my $self = shift;
	$self->SUPER::fill();
	$self->takeArgs ('module', 'name', 'type', 'compatible');
}

sub module	{ return $_[0]->{module}; }

sub matches {
	my ($self, $dev) = @_;
	# As /sys only contains the name, neither type nor compatible
	# can be checked...
	if ($self->{name} eq $dev->name) {
		return 1;
	}
	return 0;
}

1;
