// $Id: passwordwidget.cc 2359 2009-06-11 15:06:07Z rafi $
//
// Copyright (C) 2008, 2009  Rafael Ostertag
//
// This file is part of YAPET.
//
// YAPET is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// YAPET is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along with
// YAPET.  If not, see <http://www.gnu.org/licenses/>.
//

#include "../intl.h"
#include "passwordwidget.h"

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

using namespace YAPETUI;

PasswordWidget::PasswordWidget(int sx, int sy, int w, int ml)
    throw(UIException) : InputWidget(sx, sy, w, ml) {}

PasswordWidget::~PasswordWidget() {

}

void
PasswordWidget::refresh() throw(UIException) {
    int retval = wclear(getWindow());
    if (retval == ERR)
	throw UIException(_("Error clearing input widget"));

    if (getPos() > 0) {
	char* tmp = (char*)malloc(getPos()+1);
	memset(tmp, '*', getPos());
	tmp[getPos()] = '\0';
	retval = mymvwaddnstr(getWindow(),
			      0,
			      0,
			      tmp,
			      getWidth()-1);
	free(tmp);
	if (retval == ERR)
	    throw UIException(_("Error adding text to window"));

	if (getPos() >= getWidth() - 1)
	    retval = wmove(getWindow(), 0, getWidth()-1);
	else
	    retval = wmove(getWindow(), 0, getPos());

	if (retval == ERR)
	    throw UIException(_("Error moving cursor"));
    }

    retval = wrefresh(getWindow());
    if (retval == ERR)
	throw UIException(_("Error refreshing input widget"));
}
