DROP TABLE route;
DROP TABLE preroute;
DROP TABLE cdr;
DROP SEQUENCE route_routeid_seq;
DROP SEQUENCE preroute_prerouteid_seq;
DROP SEQUENCE cdr_cdrid_seq;
CREATE TABLE route (
	routeid bigserial,
	context varchar(15),
	prefix varchar(50),
	driver varchar(20),
	data varchar(100)
);

CREATE TABLE preroute (
	prerouteid bigserial,
	driver varchar(20),
	channel varchar(20),
	caller varchar(30),
	called varchar(30),
	context varchar(15)
);

CREATE TABLE cdr (
	cdrid bigserial,
	time TIMESTAMP with time zone NOT NULL DEFAULT now(),
	channel varchar(20),
	caller varchar(30),
	called varchar(30),
	billtime INTEGER NOT NULL default '0',
	ringtime INTEGER NOT NULL default '0',
	duration INTEGER NOT NULL default '0',
	status varchar(15)
);

INSERT INTO route (context,prefix,driver,data) VALUES ('paul','1','sip','jen');
INSERT INTO route (context,prefix,driver,data) VALUES ('bell','112','sip','bell');
INSERT INTO route (context,prefix,driver,data) VALUES ('gigi','4021','zap','1');
INSERT INTO route (context,prefix,driver,data) VALUES ('whatever','40238','zap','g1');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','1','sip','jen');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','2','sip','bell');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','3','zap','g1');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','4','zap','g2');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','11','zap','g11');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','12','zap','g12');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','13','zap','g13');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','14','zap','g14');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','15','zap','g15');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','16','zap','g16');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','17','zap','g17');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','18','zap','g18');
INSERT INTO route (context,prefix,driver,data) VALUES ('default','19','zap','g19');



INSERT INTO preroute (driver,channel,caller,called,context) VALUES ('zap','1','5556','','default');
INSERT INTO preroute (driver,channel,caller,called,context) VALUES ('zap','1','1','','default');
INSERT INTO preroute (driver,channel,caller,called,context) VALUES ('zap','1','2','','bell');
INSERT INTO preroute (driver,channel,caller,called,context) VALUES ('zap','1','12','','gigi');



INSERT INTO cdr (channel,caller,called,billtime,ringtime,duration) VALUES ('zap','1','12','34','10','45');

