/**
 * yateaddressbook.hpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __YATEADDRESSBOOK_HPP
#define __YATEADDRESSBOOK_HPP

class YateAddress {
 public:
	YateAddress ();
	~YateAddress();
 public:
	void setAddress (const char *newAddress);
	void setAlias (const char *newAlias);
 public:
	const char *getAddress(void) const {return address;}
	const char *getAlias(void) const {return alias;}
 protected:
	char *address;
	char *alias; /* using UTF-8 for fancy stuff should do */
};

#include <vector>

class YateAddressBook {
 public:
	YateAddressBook (const char *filename = NULL);
	~YateAddressBook();
 protected:
	void loadAddresses (void);
 public:
	bool store(void);
 public:
	void addAddress (const char *alias, const char *address);
 public:
	unsigned int getNContacts (void) {return addresses.size();}
	YateAddress *getContact (unsigned int index) {return addresses[index];}
 protected:
	char *yab_filename;
	std::vector<YateAddress *> addresses;
};

#endif /* !__YATEADDRESSBOOK_HPP */
