/**
 * yateaddressinput.hpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __YATEADDRESSINPUT_HPP
#define __YATEADDRESSINPUT_HPP

class QLabel;
class QLineEdit;
class QPushButton;

#include <qdialog.h>

class YateAddressInput : public QDialog
{
	Q_OBJECT
 public:
	YateAddressInput (QWidget *parent, const char *initialAddress);
	~YateAddressInput();
 public:
	const char *getAddress(void);
	const char *getAlias (void);
 protected:
	QLabel *labelAlias, *labelAddress;
	QLineEdit *leAlias, *leAddress;
	QPushButton *pbAccept, *pbCancel;
};

#endif /* !__YATEADDRESSINPUT_HPP */
