#!/usr/bin/php -q
<?
/* Test script for the Yate PHP interface

   To test add in extmodule.conf

   [scripts]
   route.php=

   Alternatively, you can start it from a rmanager session:
   external route.php

   To stop use rmanager:
   external stop route.php
*/
require_once("libyate.php");

function route_one(&$ev,$called)
{
//    Yate::Output("PHP Route sleeping...");
    usleep(100000);
    if ($called == "88881007")
    {
	$ev->retval = "tone/milliwatt";
	$ev->handled = true;
	Yate::Output("PHP Routed $called to " . $ev->retval);
    }
}

/* Always the first action to do */
Yate::Init();

/* Install a high priority handler for the routing message */
Yate::Install("call.route",50);

/* The main loop. We pick events and handle them */
for (;;) {
    $ev=Yate::GetEvent();
    /* If Yate disconnected us then exit cleanly */
    if ($ev == "EOF")
        break;
    /* Empty events are normal in non-blocking operation.
       This is an opportunity to do idle tasks and check timers */
    if ($ev == "")
        continue;

    /* If we reached here we should have a valid object */
    switch ($ev->type) {
	case "incoming":
//	    Yate::Output("PHP Message: " . $ev->name . " id: " . $ev->id . " called: " . $ev->params["called"] . " caller: " . $ev->params["caller"]);
	    // We just know it's a "call.route" since we installed no other
	    route_one($ev,$ev->params["called"]);
	    /* This is extremely important.
	       We MUST let messages return, handled or not */
	    $ev->Acknowledge();
	    break;
    }
}

Yate::Output("PHP: bye!");

/* vi: set ts=8 sw=4 sts=4 noet: */
?>
