# to add a distro release tag run rpmbuild --define 'dist value'
# to suppress auto dependencies run rpmbuild --define 'nodeps 1'

%{!?dist:%define dist %{nil}}
%{?nodeps:%define no_auto_deps 1}

Summary:	Yet Another Telephony Engine
Name:     	yate
Version: 	1.1.0
Release:	1%{dist}
License:	GPL
Packager:	Paul Chitescu <paulc@voip.null.ro>
Source:		http://yate.null.ro/%{name}-%{version}-1.tar.gz
Group:		Applications/Communications
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root
URL:		http://yate.null.ro/
BuildRequires:	gcc-c++

%define prefix  /usr


%description
Yate is a telephony engine designed to implement PBX and IVR solutions
for small to large scale projects.

%files
%defattr(-, root, root)
%dir /usr/share/doc/yate-%{version}
%doc /usr/share/doc/yate-%{version}/README
%doc /usr/share/doc/yate-%{version}/COPYING
%doc /usr/share/doc/yate-%{version}/ChangeLog
/usr/lib/lib*.so.*
/usr/bin/yate
/usr/share/man/*/yate.*
/etc/rc.d/init.d/yate
%dir /usr/lib/yate
%dir /usr/lib/yate/modules
%dir /etc/yate
/usr/lib/yate/modules/cdrbuild.yate
/usr/lib/yate/modules/cdrfile.yate
/usr/lib/yate/modules/regexroute.yate
/usr/lib/yate/modules/regfile.yate
/usr/lib/yate/modules/accfile.yate
/usr/lib/yate/modules/register.yate
/usr/lib/yate/modules/tonegen.yate
/usr/lib/yate/modules/tonedetect.yate
/usr/lib/yate/modules/wavefile.yate
/usr/lib/yate/modules/conference.yate
/usr/lib/yate/modules/moh.yate
/usr/lib/yate/modules/callgen.yate
/usr/lib/yate/modules/analyzer.yate
/usr/lib/yate/modules/rmanager.yate
/usr/lib/yate/modules/msgsniff.yate
/usr/lib/yate/modules/pbx.yate
/usr/lib/yate/modules/dbpbx.yate
/usr/lib/yate/modules/pbxassist.yate
/usr/lib/yate/modules/dumbchan.yate
/usr/lib/yate/modules/callfork.yate
/usr/lib/yate/modules/extmodule.yate
/usr/lib/yate/modules/yradius.yate
/usr/lib/yate/modules/ysipchan.yate
/usr/lib/yate/modules/yrtpchan.yate
/usr/lib/yate/modules/yiaxchan.yate
/usr/lib/yate/modules/enumroute.yate
/usr/lib/yate/modules/osschan.yate
/usr/lib/yate/modules/ilbccodec.yate
%config /etc/yate/accfile.conf
%config /etc/yate/cdrbuild.conf
%config /etc/yate/cdrfile.conf
%config /etc/yate/dbpbx.conf
%config /etc/yate/dsoundchan.conf
%config /etc/yate/enumroute.conf
%config /etc/yate/extmodule.conf
%config /etc/yate/moh.conf
%config /etc/yate/pbxassist.conf
%config /etc/yate/regexroute.conf
%config /etc/yate/regfile.conf
%config /etc/yate/register.conf
%config /etc/yate/rmanager.conf
%config /etc/yate/yate.conf
%config /etc/yate/yiaxchan.conf
%config /etc/yate/yradius.conf
%config /etc/yate/yrtpchan.conf
%config /etc/yate/ysipchan.conf

%post
ldconfig

%postun
ldconfig


%package alsa
Summary:	ALSA sound driver for Yate
Group:		Applications/Communication
ExclusiveOS:	linux

%description alsa
Advanced Linux Sound Architecture audio driver for Yate. This is the recommended
audio interface for using the client under Linux.

%files alsa
/usr/lib/yate/modules/alsachan.yate


%package gsm
Summary:	GSM audio codec for Yate
Group:		Applications/Communication

%description gsm
European GSM 06.10 audio codec for Yate. This is a low CPU usage codec that
provides moderate compression and good voice quality.

%files gsm
/usr/lib/yate/modules/gsmcodec.yate


%package h323
Summary:	H.323 protocol driver for Yate
Group:		Applications/Communication

%description h323
Yate driver for the ITU-T H.323 VoIP protocol based on the OpenH323 library.

%files h323
/usr/lib/yate/modules/h323chan.yate
%config /etc/yate/h323chan.conf


%package isdn
Summary:	ISDN PRI card and protocol drivers for Yate
Group:		Applications/Communication
ExclusiveOS:	linux

%description isdn
Yate drivers for ISDN PRI cards supported by the Zaptel or Wanpipe kernel
interfaces.

%files isdn
/usr/lib/yate/modules/wpchan.yate
/usr/lib/yate/modules/zapchan.yate
%config /etc/yate/wpchan.conf
%config /etc/yate/zapchan.conf


%package pgsql
Summary:	PostgreSQL database driver for Yate
Group:		Applications/Communication
Provides:	yate-database

%description pgsql
This package allows Yate to connect to a PostgreSQL database server. All
modules that support database access will be able to use PostgreSQL.

%files pgsql
/usr/lib/yate/modules/pgsqldb.yate
%config /etc/yate/pgsqldb.conf


%package mysql
Summary:	MySQL database driver for Yate
Group:		Applications/Communication
Provides:	yate-database

%description mysql
This package allows Yate to connect to a MySQL database server. All modules
that support database access will be able to use MySQL.

%files mysql
/usr/lib/yate/modules/mysqldb.yate
%config /etc/yate/mysqldb.conf


%package gtk2
Summary:	Gtk2 client package for Yate
Group:		Applications/Communication
Provides:	yate-client

%description gtk2
The yate-gtk2 package includes the files needed to use Yate as a VoIP client
with a Gtk2 graphical interface.

%files gtk2
%defattr(-, root, root)
/usr/bin/yate-gtk2
/usr/lib/menu/yate-gtk2.menu
/usr/share/applications/yate-gtk2.desktop
%dir /usr/lib/yate/modules/skin
/usr/lib/yate/modules/skin/*
%dir /usr/lib/yate/modules/help
/usr/lib/yate/modules/help/*
%config /etc/yate/yate-gtk2.conf
%config /etc/yate/providers.conf

%post gtk2
test -x /usr/bin/update-menus && /usr/bin/update-menus || /bin/true

%postun gtk2
test -x /usr/bin/update-menus && /usr/bin/update-menus || /bin/true


%package mozilla
Summary:	Mozilla embedding in Yate
Group:		Applications/Communication
Requires:	yate-gtk2 = %{version}
Provides:	yate-browser

%description mozilla
This package adds a Mozilla widget that can be embedded in a Yate client window.

%files mozilla
%defattr(-, root, root)
%dir /usr/lib/yate/modules/gtk2
/usr/lib/yate/modules/gtk2/*


%package scripts
Summary:	External scripting package for Yate
Group:		Applications/Communication
Requires:	%{name}

%description scripts
The yate-scripts package includes libraries for using external scripts with Yate.

%files scripts
%dir /usr/lib/yate/scripts
/usr/lib/yate/scripts/*.*


%package devel
Summary:	Development package for Yate
Group:		Development/Libraries
Requires:	%{name} = %{version}

%description devel
The yate-devel package includes the libraries and header files for Yate that
can be used to build and install new modules.

%files devel
%defattr(-, root, root)
%doc /usr/share/doc/yate-%{version}/*.html
%doc /usr/share/doc/yate-%{version}/api/*
/usr/include/*
/usr/lib/lib*.so
/usr/bin/yate-config
/usr/share/man/*/yate-config.*
/usr/lib/pkgconfig/yate.pc


%package all
Summary:	Metapackage for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}
Requires:	%{name}-alsa = %{version}
Requires:	%{name}-gsm = %{version}
Requires:	%{name}-h323 = %{version}
Requires:	%{name}-isdn = %{version}
Requires:	%{name}-mysql = %{version}
Requires:	%{name}-pgsql = %{version}
Requires:	%{name}-gtk2 = %{version}
Requires:	%{name}-mozilla = %{version}
Requires:	%{name}-scripts = %{version}
Requires:	%{name}-devel = %{version}

%description all
Metapackage for Yate allowing to fetch and install all components at once.
It contains no files, just dependencies to all other packages.

%files all
%defattr(-,root,root)


%prep
%setup -q -n %{name}

%if "%{no_auto_deps}" == "1"
%define local_find_requires %{_builddir}/%{name}/local-find-requires
%define local_find_provides %{_builddir}/%{name}/local-find-provides
#
%{__cat} <<EOF >%{local_find_requires}
#! /bin/sh
grep -v '\.yate$' | %{__find_requires} | grep -v '^perl'
exit 0
EOF
#
%{__cat} <<EOF >%{local_find_provides}
#! /bin/sh
%{__find_provides} | grep -v '\.yate$'
exit 0
EOF
#
chmod +x %{local_find_requires} %{local_find_provides}
%define _use_internal_dependency_generator 0
%define __find_requires %{local_find_requires}
%define __find_provides %{local_find_provides}
%define __perl_requires /bin/true
%endif

%build
./configure --prefix=%{prefix} --sysconfdir=/etc --mandir=%{prefix}/share/man
make strip

%install
make install DESTDIR=%{buildroot}
mkdir -p %{buildroot}/etc/rc.d/init.d
cp -p %{_builddir}/%{name}/yate.init %{buildroot}/etc/rc.d/init.d/yate

%clean
# make clean
rm -rf %{buildroot}


%changelog
* Mon Sep 18 2006 Paul Chitescu <paulc@voip.null.ro>
- Version 1.1.0-1

* Mon Jul 10 2006 Paul Chitescu <paulc@voip.null.ro>
- Added metapackage yate-all

* Fri Jul 07 2006 Paul Chitescu <paulc@voip.null.ro>
- Built separate packages for modules with external dependencies
- By default packages have dependencies

* Tue Jul 04 2006 Paul Chitescu <paulc@voip.null.ro>
- Version 1.0.0-pre1
- Capability to add a distro release tag at rpmbuild time

* Fri Jun 16 2006 Paul Chitescu <paulc@voip.null.ro>
- Added .desktop and .menu files and update-menus scriptlets

* Mon Nov 07 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre4
- Separated modules and scripts directories

* Mon Oct 24 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre3
- Changed obsolete Copyright: tag to License: to keep newer RPMs happy

* Mon Oct 10 2005 Diana Cionoiu <diana@diana.null.ro>
- Version 0.9.0-pre2

* Tue Sep 06 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre1

* Tue Jan 18 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.7

* Mon Jan 10 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.6
- Versioned the shared library and packaged manpage for yate-config

* Sun Jan 09 2005 Paul Chitescu <paulc-devel@null.ro>
- Cleaned up the build and packaging system

* Wed Dec 15 2004 Paul Chitescu <paulc-devel@null.ro>
- Added custom requires/provides filters to supress modules dependencies

* Mon Nov 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.5
- Removed non-packaging changes - see ChangeLog instead

* Wed Sep 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.4

* Sat Jun 26 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.3

* Sat May 15 2004 Paul Chitescu <paulc-devel@null.ro>
- Added pkgconfig support

* Sun Apr 04 2004 Paul Chitescu <paulc-devel@null.ro>
- Added yate-config to the devel package

* Mon Mar 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Created specfile
