/*
 * Copyright (C) 1994-2003, Index Data.
 * See the file LICENSE for details.
 * Sebastian Hammer, Adam Dickmeiss
 *
 * $Id: requestq.c,v 1.1 2003/10/27 12:21:35 adam Exp $
 *
 */

/*
 * Simple queue management.
 *
 * We also use the request-freelist to store encoding buffers, rather than
 * freeing and xmalloc'ing them on each cycle.
 */

#include <stdlib.h>

#include <yaz/xmalloc.h>
#include "session.h"

void request_enq(request_q *q, request *r)
{
    if (q->tail)
    	q->tail->next = r;
    else
    	q->head = r;
    q->tail = r;
    q->num++;
}

request *request_head(request_q *q)
{
    return q->head;
}

request *request_deq(request_q *q)
{
    request *r = q->head;

    if (!r)
    	return 0;
    q->head = q->head->next;
    if (!q->head)
    	q->tail = 0;
    q->num--;
    return r;
}

void request_initq(request_q *q)
{
    q->head = q->tail = q->list = 0;
    q->num = 0;
}

void request_delq(request_q *q)
{
    request *r1, *r = q->list;
    while (r)
    {
	xfree (r->response);
        r1 = r;
        r = r->next;
        xfree (r1);
    }
}

request *request_get(request_q *q)
{
    request *r = q->list;

    if (r)
    	q->list = r->next;
    else
    {
    	if (!(r = (request *)xmalloc(sizeof(*r))))
	    abort();
	r->response = 0;
	r->size_response = 0;
    }
    r->q = q;
    r->len_refid = 0;
    r->refid = 0;
    r->gdu_request = 0;
    r->apdu_request = 0;
    r->request_mem = 0;
    r->len_response = 0;
    r->clientData = 0;
    r->state = REQUEST_IDLE;
    r->next = 0;
    return r;
}

void request_release(request *r)
{
    request_q *q = r->q;
    r->next = q->list;
    q->list = r;
}

