#include <stdarg.h>
#include <string.h>

#include <gc/gc.h>

#include "util.h"

char *GC_str_append(char *buffer, const char *to_append, int append_len,
                    int *strsz, int *bufsz)
{
  int new_bufsz = *bufsz;
  
  if (append_len < 0)
    append_len = strlen(to_append);

  if (new_bufsz == 0)
    new_bufsz = 16;
  
  while (*strsz + append_len >= new_bufsz)
    new_bufsz <<= 1;
  
  if (new_bufsz > *bufsz)
    buffer = GC_realloc(buffer, new_bufsz);
  
  memcpy(buffer + *strsz, to_append, append_len);
  
  *bufsz = new_bufsz;
  *strsz += append_len;
  
  //buffer[*strsz] = '\0';
  
  return buffer;
}

char *GC_str_concat(char *buffer, int *strsz, int *bufsz,
                    const char *first, ...)
{
  const char *to_append;
  va_list args;

  va_start(args, first);
  for (to_append = first; to_append; to_append = va_arg(args, const char *))
    buffer = GC_str_append(buffer, to_append, -1, strsz, bufsz);
  va_end(args);
  
  return buffer;
}
