#include <unistd.h>

#include <stdio.h>
#include <iostream>

#include <sigc++/object_slot.h>
#include <sigcx/util.h>

#include "yehia/io.h"

using namespace std;
using namespace SigC;
using namespace SigCX;
using namespace Yehia;

int main(int argc, char *argv[])
{
  const int BUFSZ = 20 * 1024;
  
  StandardDispatcher disp;
  DispatcherDataSink sink(disp, STDOUT_FILENO);
  
  if (argc <= 1)
  {
    DispatcherDataSource src(disp, STDIN_FILENO);
    DataStream stream(src, sink, BUFSZ);
    stream.done.connect(slot(disp, &Dispatcher::exit));
    disp.run();
  }
  else
  {
    for (int i = 1; i < argc; i++)
    {
      FILE *fp = fopen(argv[i], "r");
      if (fp == NULL)
      {
        cerr << "unable to open file '" << argv[i] << "': " 
             << errno_string() << endl;
        continue;
      }
      DispatcherDataSource src(disp, fileno(fp));
      DataStream stream(src, sink, BUFSZ);
      stream.done.connect(slot(disp, &Dispatcher::exit));
      
      try
      {
        disp.run();
      } 
      catch (IOException& e)
      {
        cerr << "I/O failure: " << e.what() << endl;
      }
    }
  }
}
