/* protocols.h
 * Definitions for protocol stuff
 *
 * $Id: protocols.h,v 1.5 2005/07/30 15:17:13 t0mac Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __PROTOCOLS_H__
#define __PROTOCOLS_H__

#include <pcap.h>

//#include "thread-util.h"
//#include "interfaces.h"

/* Protocols info */
#define PROTO_STP    0
#define PROTO_CDP    1
#define PROTO_DHCP   2 
#define PROTO_HSRP   3
#define PROTO_DTP    4
#define PROTO_DOT1Q  5
#define PROTO_ISL    6
#define PROTO_VTP    7
#define PROTO_ARP    8

#define NO_PROTO -1 
#define ALL_PROTO 999
#define COMMON_TLV 69

/* Read the HGTTG */
#define PROTO_ALL      42 
#define SNAPLEN   1500

#define MAX_PROTOCOLS 9 
#define MAX_PROTO_NAME 8
#define MAX_PROTO_DESCRIPTION 64

#define MAX_FILENAME 64

/* different packets received for stats */
#define MAX_PACKET_STATS  10

/* Packets minimum size */
#define CDP_MIN_LENGTH        LIBNET_CDP_H + LIBNET_802_2SNAP_H + LIBNET_802_3_H 
#define DHCP_MIN_LENGTH       LIBNET_DHCPV4_H + LIBNET_UDP_H + LIBNET_IPV4_H + LIBNET_ETH_H
#define DOT1Q_MIN_LENGTH      LIBNET_802_1Q_H
#define DTP_MIN_LENGTH        12 + LIBNET_802_2_H + LIBNET_802_3_H
#define HSRP_MIN_LENGTH       20 + LIBNET_UDP_H + LIBNET_IPV4_H + LIBNET_ETH_H
#define VTP_MIN_LENGTH        40 + LIBNET_802_2_H + LIBNET_802_3_H
#define STP_CONF_MIN_LENGTH   LIBNET_STP_CONF_H + LIBNET_802_2_H + LIBNET_802_3_H
#define STP_TCN_MIN_LENGTH    LIBNET_STP_TCN_H + LIBNET_802_2_H + LIBNET_802_3_H


struct term_node;
struct attacks;
struct attack;
struct pcap_pkthdr;

struct pcap_data {
       struct pcap_pkthdr *header;
       u_int8_t *packet;
       u_int16_t iface;
};

struct proto_features {
       int8_t field;
       u_int32_t value;
};
                         
/* struct needed for giving info about packet fields and 
 * letting the user to choose values when crafting the packet */
struct tuple_type_desc {
       u_int16_t type;
       char *desc;
};

struct tuple_tlv {
       u_int16_t type;
       u_int8_t format;
};

typedef int8_t   (*init_attribs_t)(struct term_node *);
typedef int8_t   (*learn_packet_t)(int8_t, u_int8_t *, void *, struct pcap_pkthdr *);
typedef char     **(*get_printable_packet_t)(struct pcap_data *);
typedef char     **(*get_printable_store_t)(struct term_node *);
typedef int8_t   (*load_values_t)(struct pcap_data *, void *);
typedef int8_t   (*update_data_t)(int8_t, int8_t, int8_t, struct term_node *);
typedef void     (*display_help_t)(void);
typedef int8_t   (*parser_t)(struct term_node *, int8_t, char **, void *);
typedef char     *(*get_info_t)(u_int8_t, char *);
typedef int8_t   (*update_field_t)(int8_t, struct term_node *, void *);
typedef int8_t   (*edit_tlv_t)(struct term_node *, u_int8_t, u_int8_t, u_int16_t, u_int8_t *);


/* struct needed to move among fields when crafting the packet */
struct position_fields {
       u_int8_t v;     /* value       */
       char *name; /* field name  */
       u_int8_t y;     /* y           */
       u_int8_t fx;    /* field start */
       u_int8_t x;     /* x           */
       u_int16_t l;    /* length      */
       u_int8_t mwindow;  /* visible in the main window? */
       u_int8_t mwindowx; /* x position in the main window */
       u_int8_t type;  /* type        */
       u_int8_t position; /* first, last or normal field */
       const struct tuple_type_desc *desc; /* field value description */
};

struct protocol_def {
       u_int8_t proto;                  /* Proto id      */
       char name[MAX_PROTO_NAME];   /* Proto name    */
       char description[MAX_PROTO_DESCRIPTION];   /* Proto description    */
       u_int8_t active;                 /* Active or not */
       u_int16_t size;                  /* Struct size   */
       init_attribs_t init_attribs;
       learn_packet_t learn_packet;
       get_printable_packet_t get_printable_packet;
       get_printable_store_t get_printable_store;
       load_values_t load_values;
       update_data_t update_data;
       struct attack *attacks;
       struct pcap_data stats[MAX_PACKET_STATS];
       /* parser */
       display_help_t display_help;
       parser_t parser;
       struct position_fields *fields;
       get_info_t get_info;
       update_field_t update_field;
	   edit_tlv_t edit_tlv;
	   const struct tuple_type_desc *ttd;
	   struct attack_param *tlv;
	   u_int16_t tlv_params;
       u_int32_t packets;
       u_int32_t packets_out;
       struct proto_features *features;
       void *default_values;
};

struct protocol_def protocols[MAX_PROTOCOLS];

void   protocol_init(void);
int8_t protocol_register(u_int8_t, const char *, const char *, u_int16_t, init_attribs_t,
                  learn_packet_t, get_printable_packet_t,
                  get_printable_store_t, load_values_t,
                  update_data_t, struct attack *, display_help_t,
		  parser_t, struct position_fields *, get_info_t,
		  update_field_t, struct proto_features *);
int8_t protocol_register_tlv(u_int8_t, edit_tlv_t, const struct tuple_type_desc *, struct attack_param *, u_int16_t);

void protocol_register_all(void);
void protocol_destroy(void);
char **protocol_create_printable(u_int8_t, struct position_fields *);
u_int8_t protocol_return_last_field(struct position_fields *);

extern void write_log( u_int16_t mode, char *msg, ... );

#endif
/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
