/***************************************************************************
 *
 * $Header: /usr/local/cvsroot/utils/ytree/view.c,v 1.20 2003/08/31 11:11:00 werner Exp $
 *
 * View-Kommando-Bearbeitung
 *
 ***************************************************************************/


#include "ytree.h"

static long current_line;
static int fd;
static struct stat fdstat;
static int WLINES, WCOLS, BYTES;
static WINDOW *VIEW, *BORDER;

static int ViewFile(DirEntry * dir_entry, char *file_path);
static int ViewArchiveFile(char *file_path);

int View(DirEntry * dir_entry, char *file_path)
{
  switch( mode )
  {
    case DISK_MODE :
    case USER_MODE :     return( ViewFile(dir_entry, file_path ) );
    case TAPE_MODE:
    case RAR_FILE_MODE:
    case RPM_FILE_MODE:
    case TAR_FILE_MODE : 
    case ZOO_FILE_MODE :
    case ZIP_FILE_MODE :
    case LHA_FILE_MODE :
    case ARC_FILE_MODE : return( ViewArchiveFile( file_path ) );
    default:             beep(); return( -1 );
  }
}



static int ViewFile(DirEntry * dir_entry, char *file_path)
{
  char *command_line, *aux;
  int  compress_method;
  int  result = -1;
  int  l;
  char *file_p_aux;
  BOOL notice_mapped = FALSE;
  char cwd[PATH_LENGTH+1];
  char path[PATH_LENGTH+1];
      
  command_line = file_p_aux = NULL;

  if( ( file_p_aux = (char *) malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }
  StrCp(file_p_aux, file_path);

  if( access( file_path, R_OK ) )
  {
    (void) sprintf( message, 
		    "View not possible!*\"%s\"*%s", 
		    file_path, 
		    strerror(errno) 
		  );
    MESSAGE( message );
    ESCAPE;
  }

  if( ( command_line = malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }
  
  if (( aux = GetExtViewer(file_path))!= NULL) 
  {
     if (strstr(aux,"%s") != NULL) 
     {
        (void) sprintf(command_line, aux, file_p_aux);
     } 
     else 
          (void) sprintf(command_line, "%s %s", aux, file_p_aux);
  } 
  else 
  {
    compress_method = GetFileMethod( file_path );
    l = strlen( file_path );
    if( compress_method == FREEZE_COMPRESS )
    {
      (void) sprintf( command_line, 
		      "%s < %s %s | %s", 
		      MELT, 
		      file_p_aux, 
		      ERR_TO_STDOUT,
		      PAGER 
		    );
  }
  else if( compress_method == COMPRESS_COMPRESS )
  {
    (void) sprintf( command_line, 
		    "%s < %s %s | %s", 
		    UNCOMPRESS, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else if( compress_method == GZIP_COMPRESS )
  {
    (void) sprintf( command_line, 
                    "%s < %s %s | %s", 
		    GNUUNZIP, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else if( compress_method == BZIP_COMPRESS )
  {
    (void) sprintf( command_line, 
                    "%s < %s %s | %s", 
		    BUNZIP, 
		    file_p_aux, 
		    ERR_TO_STDOUT,
		    PAGER 
		  );
  }
  else
  {
    (void) sprintf( command_line, 
		    "%s %s", 
		    PAGER,
		    file_p_aux
		  );
  }
  }

/* --crb3 01oct02: replicating what I did to <e>dit, eliminate
the problem with jstar-chained-thru-less writing new files to
the ytree starting cwd. new code grabbed from execute.c.
*/                                                                                


  if (mode == DISK_MODE)
  {
  	if (Getcwd(cwd, PATH_LENGTH) == NULL)
  	{
  		WARNING("Getcwd failed*\".\"assumed");
  		(void) strcpy(cwd, ".");    
  	}
  	if (chdir(GetPath(dir_entry, path)))
  	{
  		(void) sprintf(message, "Can't change directory to*\"%s\"", path);
  		MESSAGE(message);
  	}else{
  		result = SystemCall(command_line);
  	}
  	(void) chdir(cwd);  
  }else{
  	result = SystemCall(command_line);  
  }
  
  /*  if((result = SilentSystemCall( command_line )))   ..did systemcall just above */
  if(result)                                                                      
  {
    (void) sprintf( message, "can't execute*%s", command_line );
    MESSAGE( message );
  }

  if( notice_mapped ) 
  {
    UnmapNoticeWindow();
  }

FNC_XIT:

  if(file_p_aux)
    free(file_p_aux);
  if(command_line)
    free(command_line);

  return( result );
}



static int ViewArchiveFile(char *file_path)
{
  char *command_line, *aux;
  char buffer[100];
  char *archive;
  int  l;
  int  result = -1;

  if( ( command_line = malloc( COMMAND_LINE_LENGTH + 1 ) ) == NULL )
  {
    ERROR_MSG( "Malloc failed*ABORT" );
    exit( 1 );
  }

  l = strlen( file_path );
  
  if (( aux = GetExtViewer(file_path)) != NULL) {
     if (strstr(aux,"%s") != NULL) {
  	(void) sprintf( buffer, "| %s", PAGER );
     } else {
  	(void) sprintf( buffer, "| %s", aux ); /* maybe pipe-able */
     }
  } else {
    (void) sprintf( buffer, "| %s", PAGER );
  }

  archive = (mode == TAPE_MODE) ? statistic.tape_name : statistic.login_path;

  MakeExtractCommandLine( command_line, 
			  archive,
			  file_path, 
			  buffer
			);
  if((result = SystemCall( command_line )))
  {
    (void) sprintf( message, "can't execute*%s", command_line );
    MESSAGE( message );
  }

  free( command_line );

  return( result );
}



char *strn2print(char *dest, char *src, int c)
{
    dest[c]='\0';
    for( ;c >= 0;c--)
	dest[c] = (isprint(src[c]) ? src[c] : '.');
    return dest;
}


void printhexline(WINDOW *win, char *line, char *buf, int r, long offset)
{
    char *aux;
    char ch;
    int i;
    aux = (char *) xmalloc(WCOLS );
    if (r==0)
    {
	wclrtoeol(win);
	return;
    }
    sprintf(line, "%010d  ", offset);
    for (i = 1; i <= r; i++ ) 
    {
        if ((i == (BYTES / 2) ) || (i == BYTES ))
	    sprintf(aux, "%02hhX  ", buf[i-1]);
        else
	    sprintf(aux, "%02hhX ", buf[i-1]);
        strcat(line, aux);
    }
    for (i = r+1; i <= BYTES; i++)
    {
        buf[i-1]= ' ';
        if ((i == (BYTES / 2) ) || (i == BYTES ))
	    sprintf(aux, "    ");
        else
	    sprintf(aux, "   ");
        strcat(line, aux);
    }
/*    strcat(line, " ");*/
    line[strlen(line)] = ' ';
    for (i=0; i< WCOLS-BYTES; i++)
	waddch(win, line[i]| COLOR_PAIR(DIR_COLOR));
    for( i=0; i< BYTES; i++)
	isprint(buf[i]) ? waddch(win, buf[i] | COLOR_PAIR(DIR_COLOR)) : 
			  waddch(win, ACS_BLOCK | COLOR_PAIR(HIDIR_COLOR));
    free(aux);
    return;
}

void update_line(WINDOW *win, long line)
{
    int r;
    unsigned char *buf;
    char *line_string;
    char mensaje[50];

    line_string = (char *) xmalloc(WCOLS);
    memset(line_string, ' ', WCOLS);
    line_string[0] = '\0';
    buf = (char *) xmalloc(BYTES);
    memset(buf, ' ', BYTES);
    if (lseek(fd, line * BYTES, SEEK_SET)== -1 )
    {
        sprintf(mensaje,"Error %l ", line);
	perror(mensaje);
	fflush(stdout);
	return;
    }
    r = read(fd, buf, BYTES);
    printhexline(win, line_string, buf, r, (line - 1) * (BYTES));
    xfree(line_string);
    xfree(buf);
}

void scroll_down(WINDOW *win)
{
    scrollok(win,TRUE);
    wscrl(win,1);
    scrollok(win,FALSE);
    wmove(win, WLINES - 1 , 0);
    update_line(win, current_line + WLINES - 1);
    wnoutrefresh(win);
    doupdate();    
}

void scroll_up(WINDOW *win)
{
    scrollok(win,TRUE);
    wscrl(win,-1);
    scrollok(win,FALSE);
    wmove(win, 0, 0);
    update_line(win, current_line );
    wnoutrefresh(win);
    doupdate();    
}

void update_all(WINDOW *win, char lines)
{
    long i;

    for (i = current_line; i <= current_line + lines; i++)
    {
	wmove(win, i - current_line, 0);
	update_line(win, i);
    }
    wnoutrefresh(win);
    doupdate();    
}

void SetupViewWindow(char *file_path)
{
    int i;
    char str[COLS];

    
    WLINES= LINES - 6;
    WCOLS= COLS - 2;
    if (BORDER)
	delwin(BORDER);
    BORDER=newwin(WLINES + 2, WCOLS + 2, 1, 0);
    if (VIEW)
	delwin(VIEW);
    VIEW=newwin(WLINES, WCOLS, 2, 1);
    keypad(VIEW,TRUE);
    scrollok(VIEW,FALSE);
    clearok(VIEW,TRUE);
    leaveok(VIEW,FALSE);
/*    werase(VIEW);*/
    WbkgdSet(VIEW,COLOR_PAIR(WINDIR_COLOR));
    wclear(VIEW);
    for( i = 0; i < WLINES - 1; i++)
    {
	wmove(VIEW,i,0);
	wclrtoeol(VIEW);
    }
    WbkgdSet(BORDER,COLOR_PAIR(WINDIR_COLOR)|A_BOLD);
    box(BORDER,0,0);
    RefreshWindow(BORDER);
    RefreshWindow(VIEW);  
/*    RefreshWindow(stdscr);*/
    for(i = WLINES + 4; i < LINES; i++)
    {
	wmove(stdscr,i , 0);
	wclrtoeol(stdscr);
    }
    doupdate();
    
    Print( stdscr, 0, 0, "File: ", MENU_COLOR );
    Print( stdscr, 0, 6, CutPathname(str,file_path,WCOLS-5), HIMENUS_COLOR );
    PrintOptions( stdscr, LINES - 2, 0, "(Q)uit   (^L) redraw");
    PrintOptions( stdscr, LINES - 1, 0, 
		"(HOME)   (END)   (NEXT)-(RIGHT)/(PREV)-(LEFT) page    (DOWN)-(UP) line");
    
    BYTES = (WCOLS - 13) / 4;
    return;

}

int InternalView(char *file_path)
{
    long oldpos;
    int ch;
    int j;
    BOOL QUIT=FALSE;
    
    if (stat(file_path, &fdstat)!=0)
	return -1;
    if (!(S_ISREG(fdstat.st_mode)) || S_ISBLK(fdstat.st_mode))
	return -1;
    fd=open(file_path,O_RDONLY);
    if (fd == -1)
	return -1;
    SetupViewWindow(file_path);
    current_line = 1;
    oldpos = 1;
    update_all(VIEW,WLINES-1);
    while (!QUIT) {
    ch = (resize_request) ? -1 : Getch();
#ifdef VI_KEYS
	ch = ViKey(ch);
#endif
       if (resize_request)
       {
    	    SetupViewWindow(file_path);
	    current_line = oldpos/BYTES;
	    update_all(VIEW,WLINES-1);
	}

	switch(ch){
	    case ESC:
	    case 'q':
	    case 'Q': QUIT=TRUE;
		      break;
	    case KEY_DOWN: /*ScrollDown();*/
			   fstat(fd,&fdstat);
			   if (fdstat.st_size > ((current_line + 1) * BYTES) )
			   {
				current_line++;
				oldpos = current_line * BYTES;
				scroll_down(VIEW);
			    }
			    else
				beep();
			    break;
	    case KEY_UP: /*ScroollUp();*/
			if (current_line > 1)
			{
			    current_line--;
			    oldpos = current_line * BYTES;
			    scroll_up(VIEW);
			}
			else
			    beep();
	                break;
	    case KEY_LEFT:
	    case KEY_PPAGE: /*ScrollPageDown();*/
			    if (current_line > WLINES)
				current_line -= WLINES;
			    else
				if (current_line > 1)
				   current_line = 1;
				else
				    beep();
			    oldpos = current_line * BYTES;
			    update_all(VIEW,WLINES);
			    break;
	    case KEY_RIGHT:
	    case KEY_NPAGE: /*ScroollPageUp();*/
			    fstat(fd,&fdstat);
			    if (fdstat.st_size > 
				((current_line + WLINES) * BYTES) ) 
				current_line += WLINES;
			    else
				beep();
			    oldpos = current_line * BYTES;
			    update_all(VIEW,WLINES);
		            break;
	    case KEY_HOME: /*ScrollHome();*/
			    if (current_line > 1)
			    {
				current_line = 1;
				oldpos = current_line * BYTES;
				update_all(VIEW,WLINES-1);
			    }else
				beep();			    
	                    break;
	    case KEY_END: /*ScrollEnd();*/
			 fstat(fd,&fdstat);
			 if (fdstat.st_size >= BYTES * 2) 
			    current_line = (fdstat.st_size - BYTES) / BYTES;
			 else
			    beep();
			oldpos = current_line * BYTES;
			update_all(VIEW,WLINES);
	                break;
	    case 'L' & 0x1f: 
			clearok(stdscr,TRUE);
			RefreshWindow(stdscr);
			break;
	    default: break;
	}
    }
    Print( stdscr, 0, 0, "Path: ", MENU_COLOR );
    delwin(VIEW);
    delwin(BORDER);
    touchwin(stdscr);
    wnoutrefresh(stdscr);
    close(fd);
    return 0;
}
