package Zaptel::Xpp::Xbus;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
#use strict;
use Zaptel::Xpp::Xpd;

my $proc_base = "/proc/xpp";

# Accessors (miniperl does not have Class:Accessor)
sub AUTOLOAD {
	my $self = shift;
	my $name = uc($AUTOLOAD);
	$name =~ s/.*://;   # strip fully-qualified portion
	if (@_) {
		return $self->{$name} = shift;
	} else {
		return $self->{$name};
	}
}

sub xpds($) {
	my $xbus = shift;
	return @{$xbus->{XPDS}};
}

sub new($$) {
	my $pack = shift or die "Wasn't called as a class method\n";
	my $self = { @_ };
	bless $self, $pack;
	$self->{NAME} or die "Missing xbus name";
	my $prefix = "$proc_base/" . $self->{NAME};
	@{$self->{XPDS}} = ();
	foreach my $fqn (glob "$prefix/XPD-??") {
		$fqn =~ s:$proc_base/::;
		$fqn =~ /(\d+)$/;
		my $num = $1;
		my $xpd = Zaptel::Xpp::Xpd->new(
					FQN => $fqn,
					NUM =>, $num,
					XBUS => $self
					);
		push(@{$self->{XPDS}}, $xpd);
	}
	return $self;
}

1;
