plot.zelig <- function(object, alt.col = "red", xlab = "", user.par = FALSE, ...) {
  model <- object$zelig.call$model
  object$qi$theta <- NULL
  k <- length(object$qi)
  op <- par(no.readonly = TRUE)
  if (!user.par) 
    par(mar = c(4,4,2,1), tcl = -0.25, mgp = c(2, 0.6, 0))
  if (dim(object$x)[1] > 1)
    stop("\n     default plot methods only supported for sim()\n     results from one-observation values of x.") 
  if (model %in% c("ls", "normal", "exp", "lognorm","weibull", "gamma")) {
    par(mfrow = c(k, 1))
    for (i in 1:k) {
      qi <- as.vector(object$qi[[i]])
      plot(density(qi), main = object$qi.name[[i]], xlab = xlab, ...)
    }
  }
  tau1 <- model == "relogit" && dim(object$qi[[1]])[2] == 1 
  if (model %in% c("logit", "probit") || tau1) {
    par(mfrow = c(k, 1))
    pr <- object$qi$pr
    y0 <- sum(pr == 0)
    y1 <- sum(pr == 1)
    xmax <- max(y0, y1)
    barplot(c(y0, y1), horiz = TRUE, col = alt.col, las = 1,
            names.arg = c("Y = 0", "Y = 1"), xlab = xlab,
            main = object$qi.name$pr, xlim = c(0, 1.15*xmax), ...)
    object$qi$pr <- object$qi.name$pr <- NULL
    for (i in 1:(k-1)) {
      qi <- as.vector(object$qi[[i]])
      plot(density(qi), main = object$qi.name[[i]], xlab = xlab, ...)
    }    
  }
  if (model == "relogit" && dim(object$qi[[1]])[2] == 2) {
    par(mfrow = c(k,1))
    for (i in 1:k) {
      qi <- object$qi[[i]]
      main <- as.character(object$qi.name[i])
      if (is.null(rownames(qi)))
        rownames(qi) <- 1:dim(qi)[1]
      idx <- as.integer(sample(rownames(qi), 100))
      tmp <- qi[idx,,1]
      xlim <- c(min(qi[,1,1]), max(qi[,2,1]))
      plot(xlim, type = "n", xlab = xlab, ylab = "Observations (n = 100)",
           main = main, ylim = c(0, 100), xlim = xlim, ...)
      for (j in 1:nrow(tmp))
        lines(c(tmp[j,1], tmp[j,2]), c(j,j), col = alt.col)
      abline(v = mean(qi[,1,1]))
      abline(v = mean(qi[,2,1]))
    }
  }
  if (model %in% c("blogit", "bprobit")) {
    if ("rr" %in% names(object$qi)) {
      object$qi$rr <- object$qi.name$rr <- NULL
      k <- k - 1
    }
    main <- object$qi.name
    par(mfrow = c(k, 1))
    for (i in 1:k) {
      qi <- as.matrix(object$qi[[i]])
      if (is.character(qi[1])) {
        y00 <- sum(as.integer(qi[,1]))
        y01 <- sum(as.integer(qi[,2]))
        y10 <- sum(as.integer(qi[,3]))
        y11 <- sum(as.integer(qi[,4]))
        xmax <- max(y00, y01, y10, y11)
        labels <- c("(0,0)", "(0,1)","(1,0)", "(1,1)")
        barplot(c(y00, y01, y10, y11), horiz = TRUE, col = alt.col,
                names.arg = labels, xpd = TRUE, main = main[[i]],
                las = 1, xlim = c(0, 1.15*xmax), ...)
      }
      else if (is.numeric(qi[1])) {
        y1 <- qi[, 3] + qi[, 4]
        y2 <- qi[, 2] + qi[, 4]
        contour(kde2d(y1, y2), xlab = "Pr(Y1 = 1)", 
                ylab = "Pr(Y2 = 1)", main = main[[i]], ...)
      }
    }
  }
  if(model %in% c("negbin", "poisson")) {
    par(mfrow = c(k,1))
    truehist(object$qi$pr, main = object$qi.name$pr, x0 = -0.25,
             xlab = xlab, ylab = "Probability", ...)
    plot(density(object$qi$ev), main = object$qi.name$ev, xlab = xlab, ...) 
    if (k == 3)
      plot(density(object$qi$fd), main = object$qi$fd, xlab = xlab, ...)
  }
  if (model %in% c("oprobit", "ologit", "mlogit")) {
    if (!is.null(object$qi$rr)) {
      k <- k - 1
      object$qi$rr <- object$qi.name$rr <- NULL
    }
    par(mfrow = c(k,1))
    pr <- object$qi$pr
    spr <- array()
    lev <- sort(unique(pr))
    K <- length(lev)
    for (i in 1:K)
      spr[i] <- sum(pr == lev[i])
    xmax <- max(spr)
    labels <- paste("Y=", lev, sep = "")
    barplot(spr, horiz = TRUE, col = rainbow(K), names.arg = labels,
            las = 1, main = object$qi.name$pr, xlim = c(0, 1.15*xmax), ...)
    object$qi$pr <- object$qi.name$pr <- NULL
    main <- object$qi.name
    for (i in 1:(k-1)) {
      qi <- object$qi[[i]]
      if (length(dim(qi)) == 3 && dim(qi)[3] == 1)
        qi <- qi[,,1]
      dens <- list()
      xmax <- ymax <- array()
      for (j in 1:ncol(qi)) {
        dens[[j]] <- density(qi[,j])
        xmax[j] <- max(dens[[j]]$x)
        ymax[j] <- max(dens[[j]]$y)
      }
      plot(dens[[1]], col = rainbow(K)[1],
           xlim = c(min(min(qi), 0), max(xmax)),
           xlab = xlab, main = "",
           ylim = c(0, max(ymax)), ...)
      for (j in 2:ncol(qi)) 
        lines(dens[[j]], col = rainbow(K)[j])
      title(main = object$qi.name[[i]][1])
    }
  }
  par(op)
}

















