print.summary.relogit <- function(object, digits = getOption("digits")) {
  if (length(object) == 2)
    call <- object[[1]]$call
  else
    call <- object$call
  tau <- eval(call$tau, sys.parent())
  if (length(tau) == 2) {
    printing <- function(obj, tau, digits) {
      print.glm(obj, digits = digits)
      cat(paste("Prior correction is made with tau = ",
                round(tau, digits = max(digits, 5)),"\n"))
      if (call$bias.correct)
        cat("Rare events bias correction was made.")
      cat("\n\n")
    }
    printing(object$lower.summary, tau[1], digits)
    printing(object$upper.summary, tau[2], digits)
  }
  if (length(tau) == 1 || length(tau) == 0){
    print.glm(object, digits)
    if(!is.null(tau))
      cat(paste("Prior correction is made with tau = ",
                round(tau, digits = max(digits, 5)),"\n"))
    if(call$bias.correct)
      cat("Rare events bias correction was made.\n\n")
  }
}
