print.zelig <- function (object, digits = max(3, getOption("digits") - 3), ...) 
{
    cat("\nModel:", object$zelig.call$model, "\n", sep = " ")
    cat("Number of simulations:", object$call$num, "\n\n", sep = " ")
    idx <- unlist(object$qi.name)
    cat("Available Quantities of Interest: \n")
    for (i in 1:length(object$qi.name)){
      cat(paste("  qi$", names(object$qi)[i], " = ", idx[[i]], "\n", sep = ""))
    }
    cat("\nPlease use summary() to obtain more information. \n")
    invisible(object)
}
