qi.polr <- function(object, par, x, x1 = NULL, y = NULL) {
  m <- length(coef(object))
  sim.coef <- par[,1:m]
  sim.zeta <- par[,(m+1):ncol(par)]
  k <- length(object$zeta) + 1
  lev <- object$lev
  eta <- array()
  if (ncol(x) == 1)
    eta <- 0
  else 
    eta <- x[,-1] %*% t(sim.coef)
  ev.polr <- function(ev, eta, sim.zeta, lev) {
    for (j in 1:ncol(sim.zeta)) 
      ev[,j,] <- 1 / (1 + exp(-sim.zeta[,j] + eta))
    for (j in 0:(ncol(sim.zeta)-1))
      for (i in 1:dim(ev)[3])
        ev[,ncol(ev)-j,i] <- ev[,ncol(ev)-j,i]-ev[,(ncol(ev)-j-1),i]
    ev
  }
  ev <- array(1, dim = c(nrow(sim.coef), length(lev), nrow(x)),
              dimnames = list(NULL, lev, rownames(x)))
  n <- nrow(sim.coef)
  z <- nrow(x)
  ev <- ev.polr(ev, eta, sim.zeta, lev)
  Ipr <- array(NA, dim(ev), dimnames(ev))
  sim.cut <- array(NA, dim(ev)[1:2], dimnames(ev)[1:2])
  tmp <- array()
  pr <- matrix(NA, nrow = n, ncol = z)
  pr.polr <- function(ev, Ipr, lev) {
    sim.cut[,1] <- ev[,1]
    for (j in 2:length(lev)) 
      sim.cut[,j] <- sim.cut[,(j-1)] + ev[,j]
    tmp <- runif(dim(ev)[1], 0, 1)
    for (j in 1:length(lev)) 
      Ipr[,j] <- tmp > sim.cut[,j]
    for (l in 1:nrow(Ipr))
      tmp[l] <- 1 + sum(Ipr[l,])
    factor(tmp, levels = sort(unique(tmp)), labels = lev)
  }
  for (i in 1:z)
    pr[,i] <- as.character(pr.polr(ev[,,i], Ipr[,,i], lev))
  colnames(pr) <- rownames(x)
  qi <- list(ev=ev, pr=pr)
  qi.name <- list(ev="Expected Values: P(Y=j|X)",
                  pr="Predicted Values: Y|X")
  if(!is.null(x1)){
    ev1 <- array(1, dim = c(nrow(sim.coef), length(lev), nrow(x)),
                 dimnames = list(NULL, lev, rownames(x)))
    eta1 <- x1[,-1] %*% t(sim.coef)
    ev1 <- ev.polr(ev1, eta1, sim.zeta, lev)
    qi$fd <- ev1-ev
    qi$rr <- ev1/ev
    qi.name$fd <- "First Differences: P(Y=j|X1)-P(Y=j|X)"
    qi.name$rr <- "Risk Ratio: P(Y=j|X1)-P(Y=j|X)"
  }
  if (!is.null(y)) {
    yvar <- matrix(NA, nrow = length(y), ncol = length(lev))
    tmp.ev <- tmp.pr <- array(NA, dim = dim(qi$ev))
    pr.idx <- array(NA, dim = c(nrow(pr), length(lev), nrow(x)))
    qi$ate.ev <- qi$ate.pr <- matrix(NA, dim(qi$ev)[1], dim(qi$ev)[2])
    for (i in 1:length(lev)) {
      yvar[,i] <- as.integer(y == lev[i])
      pr.idx[,i,] <- as.integer(pr[,i] == lev[i])
    }
    colnames(yvar) <- lev 
    for (j in 1:ncol(yvar)) {
      for (i in 1:n) {
        tmp.ev[i,j,] <- yvar[,j] - qi$ev[i,j,]
        tmp.pr[i,j,] <- yvar[,j] - pr.idx[i,j,]
      }
      qi$ate.ev[,j] <- apply(tmp.ev[,j,], 1, mean)
      qi$ate.pr[,j] <- apply(tmp.pr[,j,], 1, mean)
    }
    colnames(qi$ate.ev) <- colnames(qi$ate.pr) <- lev
    qi.name$ate.ev <- "Average Treatment Effect: Y - EV"
    qi.name$ate.pr <- "Average Treatment Effect: Y - PR"
  }
  list(qi=qi, qi.name=qi.name)
}











