sim.default <- function(object, x, x1=NULL, num=c(1000, 100), prev =
      NULL, bootstrap = FALSE, bootfn=NULL, cond.data = NULL, ...) {
  if (is.null(dim(x)))
    x <- matrix(x, nrow = 1)
  if (class(x) == "setx.cond") {
    if (!is.null(x1)) {
      warning("First Differences are not calculated in conditional prediction models.")
      x1 <- NULL
    }
    if (object$call$model %in% c("bprobit", "blogit")) {
      yvar <- x[,1:2]
      x <- x[,3:ncol(x)]
    }
    else {
      yvar <- x[,1]
      x <- x[,2:ncol(x)]
    }
    class(x) <- "setx.cond"
  }
  if (any(class(object) == "MCMCZelig"))
    num <- nrow(object$coefficients)
  else if (!bootstrap)
    num <- num[1]
  else
    num <- num[2]
  if (is.null(prev)) {
    if (!bootstrap & any(class(object) != "relogit"))
      simpar <- param(object, num=num, bootstrap=bootstrap)
    else if (class(object) == "relogit") 
      simpar <- param.relogit(object, num=num, x=x, bootstrap=bootstrap, bootfn=bootfn, ...) 
    else {
      if (any(class(object)=="vglm")) 
        tt <- object@terms$terms
      else
        tt <- terms(object)
      dta <- eval(object$data, sys.parent())
      dta <- dta[complete.cases(model.frame(tt, dta)),]
      if (is.null(bootfn)) {
        bootfn <- function(data, i, object) {
          d <- data[i,]
          object$call$data <- d
          fit <- eval(object$call, sys.parent())
          l <- length(param(object, bootstrap = TRUE))
          l1 <- length(param(fit, bootstrap = TRUE))
          while (l > l1) {
            object$call$data <- data[sample(nrow(data), replace=TRUE),]
            fit <- eval(object$call, sys.parent())
            l1 <- length(param(fit, bootstrap = TRUE))
          }
          return(param(fit, bootstrap = TRUE))
        }
      }
      res <- boot(dta, bootfn, R = num, object = object, ...)
      colnames(res$t) <- names(res$t0)
      simpar <- res$t
    }
  }
  else {
    if (bootstrap)
      stop("Error: Choosing 'bootstrap = TRUE' generates new parameters.  \nIf you wish to use previously generated parameters, \nplease specify only 'prev'.")
    else
      simpar <- prev
  }
  if (class(x) == "setx.cond") {
    if (class(object)[1] == "survreg") 
      simqi <- qi(object, simpar, x = x, x1 = x1, y = yvar, cond.data = cond.data)
    else
      simqi <- qi(object, simpar, x = x, x1 = x1, y = yvar)
    class(x) <- "setx.cond"
  }
  else 
    simqi <- qi(object, simpar, x = x, x1 = x1, y = NULL)
  c <- match.call()
  c$num <- num
  res <- list(x=x, x1=x1, call = c, zelig.call = object$call,
              par = simpar, qi=simqi$qi, qi.name=simqi$qi.name)
  class(res) <- "zelig"
  res
}
















