sim.multiple <- function(object, x, x1 = NULL, num = 100, ...){
  m <- length(object)
  dta <- eval(object[[1]]$data, sys.parent())
  res <- simpar <- list()
  by <- object[[1]]$call$by
  idx <- pmatch(by, names(dta))
  lev <- sort(unique(eval(dta[[idx]], sys.parent())))
  for (i in 1:length(lev)) {
    if (class(x) == "list") {
      object[[i]]$data <- eval(dta[[idx]] == lev[i])
      res[[i]] <- sim(object[[i]], x = x[[i]], x1 = x1[[i]], num = num, ...)
      res[[i]]$nx <- nrow(x[[i]])/nrow(dta)
    }
    else if (class(x) == "setx") {
      res[[i]] <- sim(object[[i]], x = x, x1 = x1, num = num, ...)
      res[[i]]$nx <- nrow(dta[dta[[idx]] == lev[i],])/nrow(dta)
    }
  }
  class(res) <- "zelig.multiple"
  names(res) <- names(object)
  res
}







