summary.relogit <- function(object, ...) {
  if (!is.numeric(object$call$tau))
    tau <- eval(object$call$tau, sys.frame(sys.parent()))
  else
    tau <- object$call$tau
  dta <- eval(object$call$data, sys.parent())
  tt <- terms(object)
  dta <- dta[complete.cases(model.frame(tt, dta)),]
  n <- nrow(dta)
  k <- ncol(dta)
  bias.cor <- function(res.obj, bc, n, k){
    if (bc) {
      res.obj$cov.unscaled <- res.obj$cov.unscaled * (n/(n+k))^2
      res.obj$cov.scaled <- res.obj$cov.unscaled * res.obj$dispersion
      res.obj$coef[,2] <- sqrt(diag(res.obj$cov.scaled))
      res.obj$coef[,3] <- res.obj$coef[,1] / res.obj$coef[,2]
      res.obj$coef[,4 ] <- 2*pt(-abs(res.obj$coef[,3]), res.obj$df.residual)
    }
    res.obj
  }
  if(length(tau) == 1 || length(tau) == 0){
    res <- summary.glm(object, ...)
    res <- bias.cor(res, object$call$bias.correct, n, k)
    res$call <- object$call
  }
  else if (length(tau) == 2) {
    res <- list()
    res0 <- summary.glm(object$lower.estimate, ...)
    res0$call <- object$call
    res$lower.summary <- bias.cor(res0, object$call$bias.correct, n, k)
    res1 <- summary.glm(object$upper.estimate, ...)
    res1$call <- object$call
    res$upper.summary <- bias.cor(res1, object$call$bias.correct, n, k)
  }
  class(res)<-c("summary.relogit", class(object))
  res
}












