summary.zelig.multiple <-function(object, subset = NULL, CI=95, 
                        stats=c("mean", "sd", "min", "max"), ...){
  m <- length(object)
  if(is.null(subset)) { # summary for all strata together
    w <- NULL
    for (j in 1:m) 
      w <- c(w, object[[j]]$nx)
    w <- round(w*object[[1]]$call$num)
    qi <- object[[1]]$qi
    for (i in 1:length(qi)){
      qi1i <- object[[1]]$qi[[i]]
      if(class(object[[1]]$x)=="setx.cond") # conditional prediction
        if(length(dim(qi1i))==3){
          tdim <- dim(qi1i)
          for (j in 2:m)
            tdim[2:3] <- tdim[2:3] + dim(object[[j]]$qi[[i]])[2:3]
          tmp <- array(NA, dim=tdim)
          tmp[,1:dim(qi1i)[2],1:dim(qi1i)[3]] <- qi1i
          tdim <- dim(qi1i)
        }
        else
          tmp <- as.matrix(qi1i)
      else # unconditional prediction
        if(length(dim(qi1i))==3){
          tmp <- array(NA, dim=c(sum(w), dim(qi1i))[2:3])
          tmp[1:w[1],,] <- qi1i[1:w[1],,] 
        }
        else
          tmp <- as.matrix(qi1i[1:w[1],])
      for (j in 2:m) {
        qiji <- object[[j]]$qi[[i]]
        if(class(object[[j]]$x)=="setx.cond") # conditional prediction
          if(length(dim(qi1i))==3) {
            tmp[,(tdim[2]+1):(tdim[2]+dim(qiji[2])),(tdim[3]+1):(tdim[3]+dim(qiji[3]))] <- qiji
            tdim <- tdim + dim(qiji)
          }
          else
            tmp <- cbind(tmp, qiji)
        else{ # unconditional prediction
          if(length(dim(qi1i))==3)
            tmp[(sum(w[1:(j-1)])+1):sum(w[1:j]),,] <- qiji[1:w[j],,]
          else
            tmp <- rbind(tmp, as.matrix(qiji[1:w[j],]))
        }
      }
      qi[[i]] <- tmp
    }
    c <- match.call()
    c$num <- object[[1]]$call$num
    res <- list(qi=qi, qi.name=object[[1]]$qi.name,
                x=object[[1]]$x, x1=NULL, call=c,
                zelig.call=object[[1]]$zelig)
  }
  else { # summary for each strata
    res <- list()
    if(is.function(subset)){
      m <- length(object)
      subset <- 1:m
    }
    else
      m <- length(subset)
    for (i in 1:m) {
      res[[i]] <- summary.zelig(object[[subset[i]]], subset=NULL, ...)
      names(res)[i] <- names(object)[i]
    }
    class(res) <- "summary.zelig.multiple"
    return(res)
  }
  return(summary.zelig(res, ...))  
}



















