/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.StringReader;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Filter;
import net.sf.saxon.IdentityTransformer;
import net.sf.saxon.IdentityTransformerHandler;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TemplatesHandlerImpl;
import net.sf.saxon.TransformerHandlerImpl;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.Sender;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private Configuration config;
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public TransformerFactoryImpl() {
        this.config = new Configuration();
    }

    public TransformerFactoryImpl(Configuration configuration) {
        this.config = configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.config);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        CompilerInfo compilerInfo = new CompilerInfo();
        compilerInfo.setURIResolver(this.config.getURIResolver());
        compilerInfo.setErrorListener(this.config.getErrorListener());
        PreparedStylesheet preparedStylesheet = new PreparedStylesheet(this.config, compilerInfo);
        preparedStylesheet.prepare(source);
        return preparedStylesheet;
    }

    public Templates newTemplates(Source source, CompilerInfo compilerInfo) throws TransformerConfigurationException {
        PreparedStylesheet preparedStylesheet = new PreparedStylesheet(this.config, compilerInfo);
        preparedStylesheet.prepare(source);
        return preparedStylesheet;
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        PIGrabber pIGrabber;
        block6: {
            pIGrabber = new PIGrabber();
            pIGrabber.setFactory(this.config);
            pIGrabber.setCriteria(string, string2, string3);
            pIGrabber.setBaseURI(source.getSystemId());
            pIGrabber.setURIResolver(this.config.getURIResolver());
            try {
                new Sender(this.config.makePipelineConfiguration()).send(source, pIGrabber);
            }
            catch (XPathException xPathException) {
                if (pIGrabber.isTerminated()) break block6;
                throw new TransformerConfigurationException("Failed while looking for xml-stylesheet PI", xPathException);
            }
        }
        try {
            Source[] sourceArray = pIGrabber.getAssociatedStylesheets();
            if (sourceArray == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return this.compositeStylesheet(source.getSystemId(), sourceArray);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException;
            }
            throw new TransformerConfigurationException(transformerException);
        }
    }

    private Source compositeStylesheet(String string, Source[] sourceArray) throws TransformerConfigurationException {
        if (sourceArray.length == 1) {
            return sourceArray[0];
        }
        if (sourceArray.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("<xsl:stylesheet version='1.0' ");
        stringBuffer.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        for (int i = 0; i < sourceArray.length; ++i) {
            stringBuffer.append("<xsl:import href='" + sourceArray[i].getSystemId() + "'/>");
        }
        stringBuffer.append("</xsl:stylesheet>");
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(string);
        inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
        return new SAXSource(this.config.getSourceParser(), inputSource);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.config.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.config.getURIResolver();
    }

    public boolean getFeature(String string) {
        if (string.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return this.isDOMAvailable();
        }
        if (string.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return this.isDOMAvailable();
        }
        if (string.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        if (string.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.config.isAllowExternalFunctions();
        }
        throw new IllegalArgumentException("Unknown feature " + string);
    }

    private boolean isDOMAvailable() {
        List list = this.config.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getClass().getName().equals("net.sf.saxon.dom.DOMObjectModel")) continue;
            return true;
        }
        return false;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals("http://saxon.sf.net/feature/configuration")) {
            this.config = (Configuration)object;
        } else {
            this.config.setConfigurationProperty(string, object);
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals("http://saxon.sf.net/feature/configuration")) {
            return this.config;
        }
        return this.config.getConfigurationProperty(string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.config.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.config.getErrorListener();
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        TransformerHandlerImpl transformerHandlerImpl = new TransformerHandlerImpl(controller);
        return transformerHandlerImpl;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer identityTransformer = new IdentityTransformer(this.config);
        return new IdentityTransformerHandler(identityTransformer);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.config);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new Filter(controller);
    }

    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (!string.equals(FEATURE_SECURE_PROCESSING)) {
            throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + string);
        }
        this.config.setAllowExternalFunctions(!bl);
    }
}

