/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.Reference;
import java.util.Arrays;
import java.util.Map;

public class FixedReference
extends Reference {
    private ConnectionI[] _fixedConnections;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FixedReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, ConnectionI[] fixedConns) {
        super(inst, com, ident, ctx, fs, md);
        this._fixedConnections = fixedConns;
    }

    public final ConnectionI[] getFixedConnections() {
        return this._fixedConnections;
    }

    public boolean getSecure() {
        return false;
    }

    public String getAdapterId() {
        return "";
    }

    public EndpointI[] getEndpoints() {
        return new EndpointI[0];
    }

    public boolean getCollocationOptimization() {
        return false;
    }

    public Reference changeSecure(boolean sec) {
        return this;
    }

    public Reference changeRouter(RouterPrx newRouter) {
        return this;
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        return this;
    }

    public Reference changeCollocationOptimization(boolean newCollocationOptimization) {
        return this;
    }

    public Reference changeAdapterId(String newAdapterId) {
        return this;
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        return this;
    }

    public Reference changeCompress(boolean newCompress) {
        return this;
    }

    public Reference changeTimeout(int newTimeout) {
        return this;
    }

    public Reference changeConnectionId(String connectionId) {
        return this;
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public String toString() throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public ConnectionI getConnection(BooleanHolder compress) {
        ConnectionI[] filteredConns = this.filterConnections(this._fixedConnections);
        if (filteredConns.length == 0) {
            NoEndpointException ex = new NoEndpointException();
            ex.proxy = "";
            throw ex;
        }
        ConnectionI connection = filteredConns[0];
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        compress.value = connection.endpoint().compress();
        return connection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedReference)) {
            return false;
        }
        FixedReference rhs = (FixedReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return Arrays.equals(this._fixedConnections, rhs._fixedConnections);
    }

    static {
        $assertionsDisabled = !FixedReference.class.desiredAssertionStatus();
    }
}

