/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Identity;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import java.util.Map;

public abstract class RoutableReference
extends Reference {
    private boolean _secure;
    private RouterInfo _routerInfo;
    private boolean _collocationOptimization;

    public final RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    public final EndpointI[] getRoutedEndpoints() {
        if (this._routerInfo != null) {
            ObjectPrx clientProxy = this._routerInfo.getClientProxy();
            return ((ObjectPrxHelperBase)clientProxy).__reference().getEndpoints();
        }
        return new EndpointI[0];
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final boolean getCollocationOptimization() {
        return this._collocationOptimization;
    }

    public Reference changeSecure(boolean newSecure) {
        if (newSecure == this._secure) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._secure = newSecure;
        return r;
    }

    public Reference changeRouter(RouterPrx newRouter) {
        RouterInfo newRouterInfo = this.getInstance().routerManager().get(newRouter);
        if (newRouterInfo == this._routerInfo || newRouterInfo != null && this._routerInfo != null && newRouterInfo.equals(this._routerInfo)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._routerInfo = newRouterInfo;
        return r;
    }

    public Reference changeCollocationOptimization(boolean newCollocationOptimization) {
        if (newCollocationOptimization == this._collocationOptimization) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._collocationOptimization = newCollocationOptimization;
        return r;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        RoutableReference rhs = (RoutableReference)obj;
        if (this._secure != rhs._secure) {
            return false;
        }
        if (this._collocationOptimization != rhs._collocationOptimization) {
            return false;
        }
        return this._routerInfo == null ? rhs._routerInfo == null : this._routerInfo.equals(rhs._routerInfo);
    }

    protected RoutableReference(Instance inst, Communicator com, Identity ident, Map ctx, String fac, int md, boolean sec, RouterInfo rtrInfo, boolean collocationOpt) {
        super(inst, com, ident, ctx, fac, md);
        this._secure = sec;
        this._routerInfo = rtrInfo;
        this._collocationOptimization = collocationOpt;
    }
}

