/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Communicator;
import Ice.PluginInitializationException;
import Ice.Properties;
import Ice.Util;
import IceInternal.ProtocolPluginFacade;
import IceSSL.Context;
import IceSSL.SslEndpointFactory;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

class Instance {
    private ProtocolPluginFacade _facade;
    private int _securityTraceLevel;
    private String _securityTraceCategory;
    private Context _clientContext;
    private Context _serverContext;

    Instance(Communicator communicator) {
        SecureRandom rand;
        this._facade = Util.getProtocolPluginFacade(communicator);
        this._securityTraceLevel = communicator.getProperties().getPropertyAsIntWithDefault("IceSSL.Trace.Security", 0);
        this._securityTraceCategory = "Security";
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
            rand.nextInt();
        }
        catch (GeneralSecurityException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "IceSSL: unable to initialize secure PRNG";
            e.initCause(ex);
            throw e;
        }
        try {
            this._clientContext = this.createContext("Client", rand);
        }
        catch (GeneralSecurityException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "IceSSL: unable to initialize client context";
            e.initCause(ex);
            throw e;
        }
        try {
            this._serverContext = this.createContext("Server", rand);
        }
        catch (GeneralSecurityException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "IceSSL: unable to initialize server context";
            e.initCause(ex);
            throw e;
        }
        this._facade.addEndpointFactory(new SslEndpointFactory(this));
    }

    Communicator communicator() {
        return this._facade.getCommunicator();
    }

    String defaultHost() {
        return this._facade.getDefaultHost();
    }

    int networkTraceLevel() {
        return this._facade.getNetworkTraceLevel();
    }

    String networkTraceCategory() {
        return this._facade.getNetworkTraceCategory();
    }

    int securityTraceLevel() {
        return this._securityTraceLevel;
    }

    String securityTraceCategory() {
        return this._securityTraceCategory;
    }

    Context clientContext() {
        return this._clientContext;
    }

    Context serverContext() {
        return this._serverContext;
    }

    private Context createContext(String mode, SecureRandom rand) throws GeneralSecurityException {
        String prefix = "IceSSL." + mode + ".";
        Properties properties = this.communicator().getProperties();
        String ciphers = properties.getProperty(prefix + "Ciphers");
        String keyStore = properties.getProperty(prefix + "Keystore");
        String password = properties.getProperty(prefix + "Password");
        String keyStorePassword = properties.getProperty(prefix + "KeystorePassword");
        String certs = properties.getProperty(prefix + "Certs");
        String certsPassword = properties.getProperty(prefix + "CertsPassword");
        return new Context(ciphers, keyStore, password, keyStorePassword, certs, certsPassword, rand);
    }
}

