/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.CommunicatorDestroyedException;
import Ice.ConnectionLostException;
import Ice.Logger;
import Ice.SocketException;
import Ice.Stats;
import Ice.TimeoutException;
import IceInternal.BasicStream;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.Instance;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import javax.net.ssl.SSLSocket;

final class SslTransceiver
implements Transceiver {
    private Instance _instance;
    private SSLSocket _fd;
    private Logger _logger;
    private Stats _stats;
    private String _desc;
    private InputStream _in;
    private OutputStream _out;
    private volatile boolean _shutdown;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectableChannel fd() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "closing ssl connection\n" + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        SslTransceiver sslTransceiver = this;
        synchronized (sslTransceiver) {
            if (!$assertionsDisabled && this._fd == null) {
                throw new AssertionError();
            }
            try {
                this._fd.close();
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            finally {
                this._fd = null;
            }
        }
    }

    public void shutdownWrite() {
    }

    public void shutdownReadWrite() {
        if (this._instance.networkTraceLevel() >= 2) {
            String s = "shutting down ssl connection for reading and writing\n" + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        if (!$assertionsDisabled && this._fd == null) {
            throw new AssertionError();
        }
        this._shutdown = true;
    }

    public void write(BasicStream stream, int timeout) {
        int off;
        byte[] data;
        ByteBuffer buf;
        block13: {
            buf = stream.prepareWrite();
            data = null;
            off = 0;
            try {
                data = buf.array();
                off = buf.arrayOffset();
            }
            catch (UnsupportedOperationException ex) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        try {
            if (timeout == -1) {
                timeout = 0;
            } else if (timeout == 0) {
                timeout = 1;
            }
            this._fd.setSoTimeout(timeout);
        }
        catch (java.net.SocketException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        while (buf.hasRemaining()) {
            int pos = buf.position();
            try {
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                int rem = buf.remaining();
                this._out.write(data, off + pos, rem);
                buf.position(pos + rem);
                if (this._instance.networkTraceLevel() >= 3) {
                    String s = "sent " + rem + " of " + buf.limit() + " bytes via ssl\n" + this.toString();
                    this._logger.trace(this._instance.networkTraceCategory(), s);
                }
                if (this._stats == null) break;
                this._stats.bytesSent(this.type(), rem);
                break;
            }
            catch (InterruptedIOException ex) {
                buf.position(pos + ex.bytesTransferred);
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
    }

    public void read(BasicStream stream, int timeout) {
        int off;
        byte[] data;
        int remaining;
        ByteBuffer buf;
        block17: {
            buf = stream.prepareRead();
            remaining = 0;
            if (this._instance.networkTraceLevel() >= 3) {
                remaining = buf.remaining();
            }
            data = null;
            off = 0;
            try {
                data = buf.array();
                off = buf.arrayOffset();
            }
            catch (UnsupportedOperationException ex) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        int interval = 500;
        if (timeout >= 0 && timeout < interval) {
            interval = timeout;
        }
        while (buf.hasRemaining() && !this._shutdown) {
            int pos = buf.position();
            try {
                this._fd.setSoTimeout(interval);
                if (!$assertionsDisabled && this._fd == null) {
                    throw new AssertionError();
                }
                int ret = this._in.read(data, off + pos, buf.remaining());
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret <= 0) continue;
                if (this._instance.networkTraceLevel() >= 3) {
                    String s = "received " + ret + " of " + remaining + " bytes via ssl\n" + this.toString();
                    this._logger.trace(this._instance.networkTraceCategory(), s);
                }
                if (this._stats != null) {
                    this._stats.bytesReceived(this.type(), ret);
                }
                buf.position(pos + ret);
            }
            catch (SocketTimeoutException ex) {
                if (ex.bytesTransferred > 0) {
                    buf.position(pos + ex.bytesTransferred);
                }
                if (timeout < 0) continue;
                if (interval >= timeout) {
                    throw new TimeoutException();
                }
                timeout -= interval;
            }
            catch (InterruptedIOException ex) {
                buf.position(pos + ex.bytesTransferred);
            }
            catch (IOException ex) {
                SocketException se;
                if (Network.connectionLost(ex)) {
                    se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        if (this._shutdown) {
            throw new ConnectionLostException();
        }
    }

    public String type() {
        return "ssl";
    }

    public String toString() {
        return this._desc;
    }

    SslTransceiver(Instance instance, SSLSocket fd) {
        this._instance = instance;
        this._fd = fd;
        this._logger = instance.communicator().getLogger();
        try {
            this._stats = instance.communicator().getStats();
        }
        catch (CommunicatorDestroyedException ex) {
            // empty catch block
        }
        this._desc = Network.fdToString(this._fd);
        try {
            this._in = this._fd.getInputStream();
            this._out = this._fd.getOutputStream();
        }
        catch (IOException ex) {
            try {
                this._fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this._fd = null;
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        this._shutdown = false;
    }

    protected synchronized void finalize() throws Throwable {
        if (!$assertionsDisabled && this._fd != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !SslTransceiver.class.desiredAssertionStatus();
    }
}

