/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import Ice.StringHolder;
import java.io.UnsupportedEncodingException;

public final class StringUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int findFirstOf(String str, String match) {
        return StringUtil.findFirstOf(str, match, 0);
    }

    public static int findFirstOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String str, String match) {
        return StringUtil.findFirstNotOf(str, match, 0);
    }

    public static int findFirstNotOf(String str, String match, int start) {
        int len = str.length();
        for (int i = start; i < len; ++i) {
            char ch = str.charAt(i);
            if (match.indexOf(ch) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void escapeChar(byte b, StringBuffer s, String special) {
        switch (b) {
            case 92: {
                s.append("\\\\");
                break;
            }
            case 39: {
                s.append("\\'");
                break;
            }
            case 34: {
                s.append("\\\"");
                break;
            }
            case 8: {
                s.append("\\b");
                break;
            }
            case 12: {
                s.append("\\f");
                break;
            }
            case 10: {
                s.append("\\n");
                break;
            }
            case 13: {
                s.append("\\r");
                break;
            }
            case 9: {
                s.append("\\t");
                break;
            }
            default: {
                if (b <= 31 || b == 127) {
                    s.append('\\');
                    String octal = Integer.toOctalString(b);
                    for (int j = octal.length(); j < 3; ++j) {
                        s.append('0');
                    }
                    s.append(octal);
                    break;
                }
                if (special != null && special.indexOf((char)b) != -1) {
                    s.append('\\');
                    StringUtil.escapeChar(b, s, null);
                    break;
                }
                s.append((char)b);
            }
        }
    }

    public static String escapeString(String s, String special) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        StringBuffer result = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            StringUtil.escapeChar(bytes[i], result, special);
        }
        return result.toString();
    }

    public static boolean unescapeString(String s, int start, int end, StringHolder result) {
        block22: {
            int len = s.length();
            if (!$assertionsDisabled && start < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && end > len) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && start > end) {
                throw new AssertionError();
            }
            byte[] bytes = new byte[len];
            int bc = 0;
            block12: while (start < end) {
                char ch = s.charAt(start);
                if (ch == '\\') {
                    if (++start == end) {
                        return false;
                    }
                    ch = s.charAt(start);
                    switch (ch) {
                        case '\\': {
                            bytes[bc++] = 92;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            bytes[bc++] = (byte)ch;
                            break;
                        }
                        case 'b': {
                            bytes[bc++] = 8;
                            break;
                        }
                        case 'f': {
                            bytes[bc++] = 12;
                            break;
                        }
                        case 'n': {
                            bytes[bc++] = 10;
                            break;
                        }
                        case 'r': {
                            bytes[bc++] = 13;
                            break;
                        }
                        case 't': {
                            bytes[bc++] = 9;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int val = 0;
                            for (int count = 0; count < 3 && start < end && s.charAt(start) >= '0' && s.charAt(start) <= '9'; ++start, ++count) {
                                val <<= 3;
                                val |= s.charAt(start) - 48;
                            }
                            if (val > 255) {
                                return false;
                            }
                            bytes[bc++] = (byte)val;
                            continue block12;
                        }
                        default: {
                            byte b = (byte)ch;
                            if (b <= 31 || b == 127) {
                                return false;
                            }
                            bytes[bc++] = b;
                            break;
                        }
                    }
                } else {
                    bytes[bc++] = (byte)ch;
                }
                ++start;
            }
            try {
                result.value = new String(bytes, 0, bc, "UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                if ($assertionsDisabled) break block22;
                throw new AssertionError();
            }
        }
        return true;
    }

    public static int checkQuote(String s) {
        return StringUtil.checkQuote(s, 0);
    }

    public static int checkQuote(String s, int start) {
        char quoteChar = s.charAt(start);
        if (quoteChar == '\"' || quoteChar == '\'') {
            int pos;
            ++start;
            int len = s.length();
            while (start < len && (pos = s.indexOf(quoteChar, start)) != -1) {
                if (s.charAt(pos - 1) != '\\') {
                    return pos;
                }
                start = pos + 1;
            }
            return -1;
        }
        return 0;
    }

    static {
        $assertionsDisabled = !StringUtil.class.desiredAssertionStatus();
    }
}

