/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import Ice.LocalException;
import IceGrid.AccessDeniedException;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationNotExistException;
import IceGrid.ApplicationUpdateDescriptor;
import IceGrid.BoxedDistributionDescriptor;
import IceGrid.BoxedString;
import IceGrid.DeploymentException;
import IceGrid.DistributionDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.ApplicationEditor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.ListTreeNode;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.Nodes;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.PropertySets;
import IceGridGUI.Application.ReplicaGroup;
import IceGridGUI.Application.ReplicaGroups;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.ServerTemplate;
import IceGridGUI.Application.ServerTemplates;
import IceGridGUI.Application.ServiceTemplate;
import IceGridGUI.Application.ServiceTemplates;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.ApplicationPane;
import IceGridGUI.Coordinator;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Root
extends ListTreeNode {
    private Coordinator _coordinator;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private Utils.Resolver _resolver;
    private boolean _live;
    private File _file;
    private ApplicationDescriptor _descriptor;
    private Map _origVariables;
    private String _origDescription;
    private DistributionDescriptor _origDistrib;
    private boolean _registryUpdatesEnabled;
    private boolean _discardMe;
    private boolean _updated;
    private List _concurrentUpdates;
    private boolean _canUseUpdateDescriptor;
    private int _skipUpdates;
    private Nodes _nodes;
    private PropertySets _propertySets;
    private ReplicaGroups _replicaGroups;
    private ServerTemplates _serverTemplates;
    private ServiceTemplates _serviceTemplates;
    private boolean _selectionListenerEnabled;
    private ApplicationEditor _editor;
    private Map _editorMap;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Root(Coordinator coordinator, ApplicationDescriptor desc, boolean live, File file) {
        block2: {
            super(false, null, desc.name);
            this._registryUpdatesEnabled = true;
            this._discardMe = false;
            this._updated = false;
            this._concurrentUpdates = new LinkedList();
            this._canUseUpdateDescriptor = true;
            this._skipUpdates = 0;
            this._selectionListenerEnabled = true;
            this._editorMap = new HashMap();
            this._coordinator = coordinator;
            this._descriptor = desc;
            this._file = file;
            this._live = live;
            try {
                this.init();
            }
            catch (UpdateFailedException e) {
                System.err.println(e.toString());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public Root(Coordinator coordinator, ApplicationDescriptor desc) {
        block2: {
            super(true, null, desc.name);
            this._registryUpdatesEnabled = true;
            this._discardMe = false;
            this._updated = false;
            this._concurrentUpdates = new LinkedList();
            this._canUseUpdateDescriptor = true;
            this._skipUpdates = 0;
            this._selectionListenerEnabled = true;
            this._editorMap = new HashMap();
            this._coordinator = coordinator;
            this._descriptor = desc;
            this._file = null;
            this._live = false;
            try {
                this.init();
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void init() throws UpdateFailedException {
        this._resolver = new Utils.Resolver(this._descriptor.variables);
        this._resolver.put("application", this._descriptor.name);
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origDistrib = (DistributionDescriptor)this._descriptor.distrib.clone();
        this._propertySets = new PropertySets((TreeNode)this, this._descriptor.propertySets);
        this._replicaGroups = new ReplicaGroups((TreeNode)this, this._descriptor.replicaGroups);
        this._serviceTemplates = new ServiceTemplates(this, this._descriptor.serviceTemplates);
        this._serverTemplates = new ServerTemplates(this, this._descriptor.serverTemplates);
        this._nodes = new Nodes((TreeNode)this, this._descriptor.nodes);
        this._children.add(this._nodes);
        this._children.add(this._propertySets);
        this._children.add(this._replicaGroups);
        this._children.add(this._serverTemplates);
        this._children.add(this._serviceTemplates);
        this._tree = new JTree(this, true);
        this._treeModel = (DefaultTreeModel)this._tree.getModel();
    }

    public static ApplicationDescriptor copyDescriptor(ApplicationDescriptor ad) {
        ApplicationDescriptor copy = (ApplicationDescriptor)ad.clone();
        copy.propertySets = PropertySets.copyDescriptors(copy.propertySets);
        copy.replicaGroups = ReplicaGroups.copyDescriptors(copy.replicaGroups);
        copy.serverTemplates = ServerTemplates.copyDescriptors(copy.serverTemplates);
        copy.serviceTemplates = ServiceTemplates.copyDescriptors(copy.serviceTemplates);
        copy.nodes = Nodes.copyDescriptors(copy.nodes);
        copy.distrib = (DistributionDescriptor)copy.distrib.clone();
        return copy;
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ApplicationEditor)this.getEditor(ApplicationEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ApplicationEditor();
    }

    public TreeNode findNodeLike(TreePath path, boolean exactMatch) {
        TreeNode result = null;
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.getPathCount(); ++i) {
            TreeNode node = (TreeNode)path.getPathComponent(i);
            if (result == null) {
                if (node.getId().equals(this._id)) {
                    result = this;
                    continue;
                }
                return null;
            }
            TreeNode newNode = result.findChildLike(node);
            if (newNode == null) {
                if (exactMatch) {
                    return null;
                }
                return result;
            }
            result = newNode;
        }
        return result;
    }

    public boolean hasNode(TreeNode node) {
        while (node != this) {
            TreeNode parent = (TreeNode)node.getParent();
            if (parent == null || parent.getIndex(node) == -1) {
                return false;
            }
            node = parent;
        }
        return true;
    }

    public void setSelectedNode(TreeNode node) {
        this._tree.setSelectionPath(node.getPath());
    }

    public TreeNode getSelectedNode() {
        TreePath path = this._tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (TreeNode)path.getLastPathComponent();
    }

    public void selectServer(String nodeName, String serverId) {
        TreeNode target = this._nodes;
        if (target != null) {
            Node node = (Node)target.findChild(nodeName);
            if (node != null) {
                target = node;
                Server server = node.findServer(serverId);
                if (server != null) {
                    target = (TreeNode)((Object)server);
                }
            }
            this.setSelectedNode(target);
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/application_open.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/application_closed.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        actions[15] = true;
        Object descriptor = this._coordinator.getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof ApplicationDescriptor;
        }
        actions[16] = true;
        actions[17] = true;
        actions[2] = true;
        actions[3] = true;
        actions[4] = true;
        actions[10] = true;
        actions[11] = true;
        actions[12] = true;
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this._coordinator.getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(2));
            _popup.add(actions.get(3));
            _popup.add(actions.get(4));
            _popup.addSeparator();
            _popup.add(actions.get(10));
            _popup.add(actions.get(11));
            _popup.addSeparator();
            _popup.add(actions.get(12));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void copy() {
        this._coordinator.setClipboard(Root.copyDescriptor(this._descriptor));
        this._coordinator.getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        this._coordinator.pasteApplication();
    }

    public void newNode() {
        this._nodes.newNode();
    }

    public void newPropertySet() {
        this._propertySets.newPropertySet();
    }

    public void newReplicaGroup() {
        this._replicaGroups.newReplicaGroup();
    }

    public void newTemplateServer() {
        this._serverTemplates.newTemplateServer();
    }

    public void newTemplateServerIceBox() {
        this._serverTemplates.newTemplateServerIceBox();
    }

    public void newTemplateService() {
        this._serviceTemplates.newTemplateService();
    }

    public void save() {
        if (this._live) {
            this.saveToRegistry();
        } else if (this._file != null) {
            File file = this._coordinator.saveToFile(false, this, this._file);
            if (file != null) {
                this._file = file;
                this.commit();
                this._coordinator.getSaveAction().setEnabled(false);
                this._coordinator.getDiscardUpdatesAction().setEnabled(false);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void saveToRegistry() {
        Runnable runnable = new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    block18: {
                        try {
                            if (Root.this._live && Root.this._canUseUpdateDescriptor) {
                                ApplicationUpdateDescriptor updateDescriptor = Root.this.createUpdateDescriptor();
                                if (updateDescriptor != null) {
                                    Root.this._coordinator.getAdmin().updateApplication(updateDescriptor);
                                    Root.this.commit();
                                    Root.this._skipUpdates++;
                                }
                            } else if (Root.this._coordinator.getLiveDeploymentRoot().getApplicationDescriptor(Root.this._id) == null) {
                                if (!$assertionsDisabled && Root.this._live) {
                                    throw new AssertionError();
                                }
                                Root.this._coordinator.getAdmin().addApplication(Root.this._descriptor);
                                Root.this.commit();
                                Root.this.liveReset();
                                Root.this._coordinator.addLiveApplication(Root.this);
                            } else {
                                Root.this._coordinator.getAdmin().syncApplication(Root.this._descriptor);
                                Root.this.commit();
                                if (Root.this._live) {
                                    Root.this.liveReset();
                                    Root.this._skipUpdates++;
                                } else {
                                    ApplicationPane app = Root.this._coordinator.getLiveApplication(Root.this._id);
                                    if (app == null) {
                                        Root.this.liveReset();
                                        Root.this._coordinator.addLiveApplication(Root.this);
                                    } else {
                                        boolean selected = Root.this.isSelected();
                                        Root.this._coordinator.getMainPane().removeApplication(Root.this);
                                        if (selected) {
                                            Root.this._coordinator.getMainPane().setSelectedComponent(app);
                                        }
                                    }
                                }
                            }
                            if (!Root.this.isSelected()) break block18;
                            Root.this._coordinator.getSaveAction().setEnabled(false);
                            Root.this._coordinator.getSaveToRegistryAction().setEnabled(false);
                            Root.this._coordinator.getDiscardUpdatesAction().setEnabled(false);
                        }
                        catch (DeploymentException e) {
                            JOptionPane.showMessageDialog(Root.this._coordinator.getMainFrame(), "Application '" + Root.this._id + "': " + e.reason, "Deployment Exception", 0);
                            Object var4_9 = null;
                            Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                            Root.this._coordinator.releaseExclusiveWriteAccess();
                            return;
                        }
                        catch (ApplicationNotExistException e) {
                            JOptionPane.showMessageDialog(Root.this._coordinator.getMainFrame(), "Application '" + Root.this._id + "' was not found in the IceGrid registry", "Deployment Exception", 0);
                            Object var4_10 = null;
                            Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                            Root.this._coordinator.releaseExclusiveWriteAccess();
                            return;
                        }
                        catch (AccessDeniedException e) {
                            Root.this._coordinator.accessDenied(e);
                            Object var4_11 = null;
                            Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                            Root.this._coordinator.releaseExclusiveWriteAccess();
                            return;
                        }
                        catch (LocalException e) {
                            JOptionPane.showMessageDialog(Root.this._coordinator.getMainFrame(), e.toString(), "Communication Exception", 0);
                            Object var4_12 = null;
                            Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                            Root.this._coordinator.releaseExclusiveWriteAccess();
                            return;
                        }
                    }
                    Object var4_8 = null;
                    Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                    Root.this._coordinator.releaseExclusiveWriteAccess();
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_13 = null;
                    Root.this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                    Root.this._coordinator.releaseExclusiveWriteAccess();
                    throw throwable;
                }
            }

            static {
                $assertionsDisabled = !(class$IceGridGUI$Application$Root == null ? (class$IceGridGUI$Application$Root = Root.class$("IceGridGUI.Application.Root")) : class$IceGridGUI$Application$Root).desiredAssertionStatus();
            }
        };
        try {
            this._coordinator.acquireExclusiveWriteAccess(runnable);
        }
        catch (AccessDeniedException e) {
            this._coordinator.accessDenied(e);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), e.toString(), "Communication Exception", 0);
        }
    }

    public void saveToFile() {
        File file = this._coordinator.saveToFile(true, this, this._file);
        if (file != null) {
            this._file = file;
            this._live = false;
            this._coordinator.removeLiveApplication(this._id);
            this._coordinator.getMainPane().resetIcon(this);
            this.commit();
            this._coordinator.getSaveAction().setEnabled(false);
            this._coordinator.getDiscardUpdatesAction().setEnabled(false);
        }
    }

    public void discardUpdates() {
        ApplicationDescriptor desc = null;
        if (this._live) {
            desc = this._coordinator.getLiveDeploymentRoot().getApplicationDescriptor(this._id);
            if (!$assertionsDisabled && desc == null) {
                throw new AssertionError();
            }
            desc = Root.copyDescriptor(desc);
        } else if (this._file != null) {
            desc = this._coordinator.parseFile(this._file);
            if (desc == null) {
                return;
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        Root newRoot = new Root(this._coordinator, desc, this._live, this._file);
        ApplicationPane app = this._coordinator.getMainPane().findApplication(this);
        if (!$assertionsDisabled && app == null) {
            throw new AssertionError();
        }
        app.setRoot(newRoot);
        TreeNode node = newRoot.findNodeLike(this._tree.getSelectionPath(), false);
        if (node == null) {
            newRoot.setSelectedNode(newRoot);
        } else {
            newRoot.setSelectedNode(node);
        }
        this._coordinator.getCurrentTab().selected();
    }

    private void liveReset() {
        this._live = true;
        this._file = null;
        this._coordinator.getMainPane().resetIcon(this);
    }

    private ApplicationUpdateDescriptor createUpdateDescriptor() {
        ApplicationUpdateDescriptor update = new ApplicationUpdateDescriptor();
        update.name = this._descriptor.name;
        if (this._editable.isModified()) {
            if (!this._descriptor.description.equals(this._origDescription)) {
                update.description = new BoxedString(this._descriptor.description);
            }
            update.variables = new TreeMap(this._descriptor.variables);
            LinkedList removeVariables = new LinkedList();
            Iterator p = this._origVariables.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                Object key = entry.getKey();
                Object newValue = update.variables.get(key);
                if (newValue == null) {
                    removeVariables.add(key);
                    continue;
                }
                Object value = entry.getValue();
                if (!newValue.equals(value)) continue;
                update.variables.remove(key);
            }
            update.removeVariables = removeVariables.toArray(new String[0]);
            if (!this._descriptor.distrib.equals(this._origDistrib)) {
                update.distrib = new BoxedDistributionDescriptor(this._descriptor.distrib);
            }
        } else {
            update.variables = new TreeMap();
            update.removeVariables = new String[0];
        }
        update.removePropertySets = this._propertySets.getEditable().removedElements(PropertySet.class);
        update.propertySets = this._propertySets.getUpdates();
        update.removeReplicaGroups = this._replicaGroups.getEditable().removedElements(ReplicaGroup.class);
        update.replicaGroups = this._replicaGroups.getUpdates();
        update.removeServerTemplates = this._serverTemplates.getEditable().removedElements(ServerTemplate.class);
        update.serverTemplates = this._serverTemplates.getUpdates();
        update.removeServiceTemplates = this._serviceTemplates.getEditable().removedElements(ServiceTemplate.class);
        update.serviceTemplates = this._serviceTemplates.getUpdates();
        update.removeNodes = this._nodes.getEditable().removedElements(Node.class);
        update.nodes = this._nodes.getUpdates();
        if (!this._editable.isModified() && update.removePropertySets.length == 0 && update.propertySets.size() == 0 && update.removeReplicaGroups.length == 0 && update.replicaGroups.size() == 0 && update.removeServerTemplates.length == 0 && update.serverTemplates.size() == 0 && update.removeServiceTemplates.length == 0 && update.serviceTemplates.size() == 0 && update.removeNodes.length == 0 && update.nodes.size() == 0) {
            return null;
        }
        return update;
    }

    private void commit() {
        this._updated = false;
        this._registryUpdatesEnabled = true;
        this._canUseUpdateDescriptor = true;
        if (!$assertionsDisabled && this._concurrentUpdates.size() != 0) {
            throw new AssertionError();
        }
        this._editable.commit();
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origDistrib = (DistributionDescriptor)this._descriptor.distrib.clone();
        this._nodes.commit();
        this._propertySets.commit();
        this._replicaGroups.commit();
        this._serverTemplates.commit();
        this._serviceTemplates.commit();
    }

    public boolean isEphemeral() {
        return false;
    }

    public void destroy() {
        if (!this._live && this._file == null) {
            this._coordinator.getMainPane().removeApplication(this);
        } else if (this._live) {
            int confirm = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to remove application '" + this._id + "' from the IceGrid registry. " + "Do you want to proceed?", "Remove Confirmation", 0);
            if (confirm == 0) {
                this._coordinator.removeApplicationFromRegistry(this._id);
                this._discardMe = true;
            }
        } else {
            if (!$assertionsDisabled && this._file == null) {
                throw new AssertionError();
            }
            int confirm = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to remove application '" + this._id + "' and its associated file. " + "Do you want to proceed?", "Remove Confirmation", 0);
            if (confirm == 0 && this._file.delete()) {
                this._coordinator.getMainPane().removeApplication(this);
            }
        }
    }

    public boolean update(ApplicationUpdateDescriptor desc) {
        block15: {
            if (!$assertionsDisabled && !this._live) {
                throw new AssertionError();
            }
            if (this._skipUpdates > 0) {
                --this._skipUpdates;
                return false;
            }
            if (!this._registryUpdatesEnabled) {
                if (this._updated) {
                    this._canUseUpdateDescriptor = false;
                } else {
                    this._concurrentUpdates.add(desc);
                }
                return false;
            }
            try {
                int i;
                if (desc.description != null) {
                    this._origDescription = this._descriptor.description = desc.description.value;
                }
                for (i = 0; i < desc.removeVariables.length; ++i) {
                    this._descriptor.variables.remove(desc.removeVariables[i]);
                }
                this._descriptor.variables.putAll(desc.variables);
                if (desc.distrib != null) {
                    this._descriptor.distrib = desc.distrib.value;
                    this._origDistrib = (DistributionDescriptor)this._descriptor.distrib.clone();
                }
                for (i = 0; i < desc.removePropertySets.length; ++i) {
                    this._descriptor.propertySets.remove(desc.removePropertySets[i]);
                }
                this._descriptor.propertySets.putAll(desc.propertySets);
                this._propertySets.update(desc.propertySets, desc.removePropertySets);
                for (i = 0; i < desc.removeReplicaGroups.length; ++i) {
                    this._descriptor.replicaGroups.remove(desc.removeReplicaGroups[i]);
                }
                this._descriptor.replicaGroups.addAll(desc.replicaGroups);
                this._replicaGroups.update(desc.replicaGroups, desc.removeReplicaGroups);
                for (i = 0; i < desc.removeServiceTemplates.length; ++i) {
                    this._descriptor.serviceTemplates.remove(desc.removeServiceTemplates[i]);
                }
                this._descriptor.serviceTemplates.putAll(desc.serviceTemplates);
                this._serviceTemplates.update(desc.serviceTemplates, desc.removeServiceTemplates);
                for (i = 0; i < desc.removeServerTemplates.length; ++i) {
                    this._descriptor.serverTemplates.remove(desc.removeServerTemplates[i]);
                }
                this._descriptor.serverTemplates.putAll(desc.serverTemplates);
                this._serverTemplates.update(desc.serverTemplates, desc.removeServerTemplates, desc.serviceTemplates.keySet());
                for (i = 0; i < desc.removeNodes.length; ++i) {
                    this._descriptor.nodes.remove(desc.removeNodes[i]);
                }
                this._nodes.update(desc.nodes, desc.removeNodes, desc.serverTemplates.keySet(), desc.serviceTemplates.keySet());
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        return true;
    }

    public JTree getTree() {
        return this._tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    public boolean isSelectionListenerEnabled() {
        return this._selectionListenerEnabled;
    }

    public void enableSelectionListener() {
        this._selectionListenerEnabled = true;
    }

    public void disableSelectionListener() {
        this._selectionListenerEnabled = false;
    }

    public void cancelEdit() {
        if (!this._updated) {
            this._registryUpdatesEnabled = true;
            Iterator p = this._concurrentUpdates.iterator();
            while (p.hasNext()) {
                ApplicationUpdateDescriptor d = (ApplicationUpdateDescriptor)p.next();
                boolean ok = this.update(d);
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
            }
            this._concurrentUpdates.clear();
        }
    }

    public boolean kill() {
        this._live = false;
        if (this._registryUpdatesEnabled || this._discardMe) {
            return true;
        }
        this._coordinator.getMainPane().resetIcon(this);
        this._coordinator.getCurrentTab().selected();
        return false;
    }

    public boolean isLive() {
        return this._live;
    }

    public boolean hasFile() {
        return this._file != null;
    }

    public boolean needsSaving() {
        return this._updated;
    }

    Editor getEditor(Class c, TreeNode node) {
        Editor result = (Editor)this._editorMap.get(c);
        if (result == null) {
            result = node.createEditor();
            this._editorMap.put(c, result);
        }
        return result;
    }

    Object getDescriptor() {
        return this._descriptor;
    }

    ApplicationDescriptor saveDescriptor() {
        ApplicationDescriptor clone = (ApplicationDescriptor)this._descriptor.clone();
        clone.distrib = (DistributionDescriptor)clone.distrib.clone();
        return clone;
    }

    void restoreDescriptor(ApplicationDescriptor clone) {
        this._descriptor.name = clone.name;
        this._descriptor.variables = clone.variables;
        this._descriptor.distrib.icepatch = clone.distrib.icepatch;
        this._descriptor.distrib.directories = clone.distrib.directories;
        this._descriptor.description = clone.description;
    }

    public void write(XMLWriter writer) throws IOException {
        writer.writeStartTag("icegrid");
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        attributes.add(Root.createAttribute("name", this._id));
        writer.writeStartTag("application", attributes);
        if (this._descriptor.description.length() > 0) {
            writer.writeElement("description", this._descriptor.description);
        }
        Root.writeVariables(writer, this._descriptor.variables);
        Root.writeDistribution(writer, this._descriptor.distrib);
        this._serviceTemplates.write(writer);
        this._serverTemplates.write(writer);
        this._replicaGroups.write(writer);
        this._propertySets.write(writer);
        this._nodes.write(writer);
        writer.writeEndTag("application");
        writer.writeEndTag("icegrid");
    }

    void disableRegistryUpdates() {
        this._registryUpdatesEnabled = false;
    }

    void updated() {
        this._updated = true;
        this._registryUpdatesEnabled = false;
        this._concurrentUpdates.clear();
        this._coordinator.getSaveAction().setEnabled(this._live || this._file != null);
        this._coordinator.getDiscardUpdatesAction().setEnabled(this._live || this._file != null);
        this._coordinator.getSaveToRegistryAction().setEnabled(this._coordinator.getSession() != null);
        this._coordinator.getSaveToFileAction().setEnabled(true);
    }

    void rebuild() throws UpdateFailedException {
        Utils.Resolver oldResolver = this._resolver;
        String oldId = this._id;
        this._id = this._descriptor.name;
        this._resolver = new Utils.Resolver(this._descriptor.variables);
        this._resolver.put("application", this._id);
        try {
            this._nodes.rebuild();
        }
        catch (UpdateFailedException e) {
            this._id = oldId;
            this._resolver = oldResolver;
            throw e;
        }
    }

    void removeServerInstances(String templateId) {
        this._nodes.removeServerInstances(templateId);
    }

    void removeServiceInstances(String templateId) {
        this._nodes.removeServiceInstances(templateId);
        this._serverTemplates.removeServiceInstances(templateId);
    }

    ServerTemplate findServerTemplate(String id) {
        return (ServerTemplate)this._serverTemplates.findChild(id);
    }

    ServiceTemplate findServiceTemplate(String id) {
        return (ServiceTemplate)this._serviceTemplates.findChild(id);
    }

    ReplicaGroup findReplicaGroup(String id) {
        return (ReplicaGroup)this._replicaGroups.findChild(id);
    }

    List findServerInstances(String template) {
        return this._nodes.findServerInstances(template);
    }

    List findServiceInstances(String template) {
        List result = this._serverTemplates.findServiceInstances(template);
        result.addAll(this._nodes.findServiceInstances(template));
        return result;
    }

    TemplateDescriptor findServerTemplateDescriptor(String templateName) {
        return (TemplateDescriptor)this._descriptor.serverTemplates.get(templateName);
    }

    TemplateDescriptor findServiceTemplateDescriptor(String templateName) {
        return (TemplateDescriptor)this._descriptor.serviceTemplates.get(templateName);
    }

    ServerTemplates getServerTemplates() {
        return this._serverTemplates;
    }

    ServiceTemplates getServiceTemplates() {
        return this._serviceTemplates;
    }

    ReplicaGroups getReplicaGroups() {
        return this._replicaGroups;
    }

    Root getRoot() {
        return this;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    Map getVariables() {
        return this._descriptor.variables;
    }

    private boolean isSelected() {
        if (this._coordinator.getCurrentTab() instanceof ApplicationPane) {
            return ((ApplicationPane)this._coordinator.getCurrentTab()).getRoot() == this;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Root.class.desiredAssertionStatus();
    }
}

