/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.UserException;
import IceGrid.AMI_Admin_enableServer;
import IceGrid.AMI_Admin_patchServer;
import IceGrid.AMI_Admin_startServer;
import IceGrid.AMI_Admin_stopServer;
import IceGrid.AdapterDescriptor;
import IceGrid.AdapterDynamicInfo;
import IceGrid.ApplicationDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGrid.IceBoxDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.ServerInstanceDescriptor;
import IceGrid.ServerState;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.Adapter;
import IceGridGUI.LiveDeployment.DbEnv;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListArrayTreeNode;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.ServerEditor;
import IceGridGUI.LiveDeployment.Service;
import IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Server
extends ListArrayTreeNode {
    private ServerInstanceDescriptor _instanceDescriptor;
    private ServerDescriptor _serverDescriptor;
    private ApplicationDescriptor _application;
    private Utils.Resolver _resolver;
    private List _adapters = new LinkedList();
    private List _dbEnvs = new LinkedList();
    private List _services = new LinkedList();
    private ServerState _state;
    private boolean _enabled;
    private int _stateIconIndex;
    private int _pid;
    private String _toolTip;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon[][][] _icons;
    private static ServerEditor _editor;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[7];
        if (this._state != null) {
            actions[0] = this._state == ServerState.Inactive && this._enabled && !this._resolver.substitute(this._serverDescriptor.activation).equals("session");
            actions[1] = this._state != ServerState.Inactive;
            actions[2] = !this._enabled;
            actions[3] = this._enabled;
            actions[5] = !this._serverDescriptor.distrib.icepatch.equals("");
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        final String prefix = "Starting server '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_startServer cb = new AMI_Admin_startServer(){

            public void ice_response() {
                Server.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Server.this.amiFailure(prefix, "Failed to start " + Server.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Server.this.amiFailure(prefix, "Failed to start " + Server.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().startServer_async(cb, this._id);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to start " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        final String prefix = "Stopping server '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_stopServer cb = new AMI_Admin_stopServer(){

            public void ice_response() {
                Server.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Server.this.amiFailure(prefix, "Failed to stop " + Server.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Server.this.amiFailure(prefix, "Failed to stop " + Server.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().stopServer_async(cb, this._id);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to stop " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void enable() {
        this.enableServer(true);
    }

    public void disable() {
        this.enableServer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchServer() {
        int shutdown = JOptionPane.showConfirmDialog(this.getCoordinator().getMainFrame(), "You are about to install or refresh your server distribution and your application distribution onto this node.\n Do you want shut down all servers affected by this update?", "Patch Confirmation", 1);
        if (shutdown == 2) {
            return;
        }
        final String prefix = "Patching server '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_patchServer cb = new AMI_Admin_patchServer(){

            public void ice_response() {
                Server.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Server.this.amiFailure(prefix, "Failed to patch " + Server.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Server.this.amiFailure(prefix, "Failed to patch " + Server.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().patchServer_async(cb, this._id, shutdown == 0);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to patch " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableServer(boolean enable) {
        final String prefix = (enable ? "Enabling" : "Disabling") + " server '" + this._id + "'...";
        final String action = enable ? "enable" : "disable";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_enableServer cb = new AMI_Admin_enableServer(){

            public void ice_response() {
                Server.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Server.this.amiFailure(prefix, "Failed to " + action + " " + Server.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Server.this.amiFailure(prefix, "Failed to " + action + " " + Server.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().enableServer_async(cb, this._id, enable);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to " + action + " " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(0));
            _popup.add(la.get(1));
            _popup.addSeparator();
            _popup.add(la.get(2));
            _popup.add(la.get(3));
            _popup.addSeparator();
            _popup.add(la.get(5));
        }
        la.setTarget(this);
        return _popup;
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new ServerEditor(this.getCoordinator());
        }
        _editor.show(this);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int disabled;
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _icons = new Icon[7][2][2];
            Server._icons[0][0][0] = Utils.getIcon("/icons/16x16/server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_activating.png");
            Server._icons[ServerState.Active.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_destroyed.png");
            Server._icons[0][1][0] = Utils.getIcon("/icons/16x16/icebox_server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_activating.png");
            Server._icons[ServerState.Active.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_destroyed.png");
            Server._icons[0][0][1] = Utils.getIcon("/icons/16x16/server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_activating.png");
            Server._icons[ServerState.Active.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_destroyed.png");
            Server._icons[0][1][1] = Utils.getIcon("/icons/16x16/icebox_server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_activating.png");
            Server._icons[ServerState.Active.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_destroyed.png");
        }
        int icebox = this._serverDescriptor instanceof IceBoxDescriptor ? 1 : 0;
        int n = disabled = this._enabled ? 0 : 1;
        if (expanded) {
            _cellRenderer.setOpenIcon(_icons[this._stateIconIndex][icebox][disabled]);
        } else {
            _cellRenderer.setClosedIcon(_icons[this._stateIconIndex][icebox][disabled]);
        }
        _cellRenderer.setToolTipText(this._toolTip);
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    Server(Node parent, String serverId, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, ServerDescriptor serverDescriptor, ApplicationDescriptor application, ServerState state, int pid, boolean enabled) {
        super(parent, serverId, 3);
        this._resolver = resolver;
        this._instanceDescriptor = instanceDescriptor;
        this._serverDescriptor = serverDescriptor;
        this._application = application;
        this._childrenArray[0] = this._adapters;
        this._childrenArray[1] = this._dbEnvs;
        this._childrenArray[2] = this._services;
        this.update(state, pid, enabled, false);
        this.createAdapters();
        this.createDbEnvs();
        this.createServices();
    }

    ApplicationDescriptor getApplication() {
        return this._application;
    }

    ServerInstanceDescriptor getInstanceDescriptor() {
        return this._instanceDescriptor;
    }

    ServerDescriptor getServerDescriptor() {
        return this._serverDescriptor;
    }

    ServerState getState() {
        return this._state;
    }

    int getPid() {
        return this._pid;
    }

    boolean isEnabled() {
        return this._enabled;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    void rebuild(Server server) {
        this._resolver = server._resolver;
        this._instanceDescriptor = server._instanceDescriptor;
        this._serverDescriptor = server._serverDescriptor;
        this._application = server._application;
        this._adapters = server._adapters;
        this._dbEnvs = server._dbEnvs;
        this._services = server._services;
        this._childrenArray[0] = this._adapters;
        this._childrenArray[1] = this._dbEnvs;
        this._childrenArray[2] = this._services;
        this.getRoot().getTreeModel().nodeStructureChanged(this);
    }

    void rebuild(Utils.Resolver resolver, boolean variablesChanged, Set serviceTemplates, Set serverTemplates) {
        if (variablesChanged || this._instanceDescriptor != null && serverTemplates.contains(this._instanceDescriptor.template)) {
            if (this._instanceDescriptor != null) {
                TemplateDescriptor templateDescriptor = (TemplateDescriptor)this._application.serverTemplates.get(this._instanceDescriptor.template);
                if (!$assertionsDisabled && templateDescriptor == null) {
                    throw new AssertionError();
                }
                this._resolver.reset(resolver, this._instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
                this._resolver.put("server", this._id);
                this._serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
            }
            this._adapters.clear();
            this.createAdapters();
            this._dbEnvs.clear();
            this.createDbEnvs();
            this._services.clear();
            this.createServices();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
        } else if (serviceTemplates.size() > 0 && this._serverDescriptor instanceof IceBoxDescriptor) {
            this._services.clear();
            this.createServices();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
        }
    }

    void update(ServerState state, int pid, boolean enabled, boolean fireEvent) {
        if (state != this._state || pid != this._pid || enabled != this._enabled) {
            this._state = state;
            this._pid = pid;
            this._enabled = enabled;
            this._toolTip = Server.toolTip(this._state, this._pid, this._enabled);
            this._stateIconIndex = this._state == null ? 0 : this._state.value() + 1;
            if (fireEvent) {
                this.getRoot().getTreeModel().nodeChanged(this);
            }
        }
    }

    boolean updateAdapter(AdapterDynamicInfo info) {
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(info)) continue;
            return true;
        }
        p = this._services.iterator();
        while (p.hasNext()) {
            Service service = (Service)p.next();
            if (!service.updateAdapter(info)) continue;
            return true;
        }
        return false;
    }

    int updateAdapters(List infoList) {
        int result = 0;
        Iterator p = this._adapters.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(infoList)) continue;
            ++result;
        }
        p = this._services.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Service service = (Service)p.next();
            result += service.updateAdapters(infoList);
        }
        return result;
    }

    void nodeDown() {
        this.update(null, 0, true, true);
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            adapter.update((AdapterDynamicInfo)null);
        }
        p = this._services.iterator();
        while (p.hasNext()) {
            Service service = (Service)p.next();
            service.nodeDown();
        }
    }

    SortedMap getProperties() {
        Utils.ExpandedPropertySet instancePropertySet = null;
        Node node = (Node)this._parent;
        if (this._instanceDescriptor != null) {
            instancePropertySet = node.expand(this._instanceDescriptor.propertySet, this._application.name, this._resolver);
        }
        Utils.ExpandedPropertySet propertySet = node.expand(this._serverDescriptor.propertySet, this._application.name, this._resolver);
        return Utils.propertySetToMap(propertySet, instancePropertySet, this._resolver);
    }

    private void createAdapters() {
        Iterator p = this._serverDescriptor.adapters.iterator();
        while (p.hasNext()) {
            AdapterDescriptor descriptor = (AdapterDescriptor)p.next();
            String adapterName = Utils.substitute(descriptor.name, this._resolver);
            String adapterId = Utils.substitute(descriptor.id, this._resolver);
            ObjectPrx proxy = null;
            if (adapterId.length() > 0) {
                proxy = ((Node)this._parent).getProxy(adapterId);
            }
            this.insertSortedChild(new Adapter(this, adapterName, this._resolver, adapterId, descriptor, proxy), this._adapters, null);
        }
    }

    private void createDbEnvs() {
        Iterator p = this._serverDescriptor.dbEnvs.iterator();
        while (p.hasNext()) {
            DbEnvDescriptor descriptor = (DbEnvDescriptor)p.next();
            String dbEnvName = Utils.substitute(descriptor.name, this._resolver);
            this.insertSortedChild(new DbEnv(this, dbEnvName, this._resolver, descriptor), this._dbEnvs, null);
        }
    }

    private void createServices() {
        if (this._serverDescriptor instanceof IceBoxDescriptor) {
            IceBoxDescriptor iceBoxDescriptor = (IceBoxDescriptor)this._serverDescriptor;
            Iterator p = iceBoxDescriptor.services.iterator();
            while (p.hasNext()) {
                ServiceInstanceDescriptor descriptor = (ServiceInstanceDescriptor)p.next();
                this.createService(descriptor);
            }
        }
    }

    private void createService(ServiceInstanceDescriptor descriptor) {
        ServiceDescriptor serviceDescriptor = null;
        String serviceName = null;
        Utils.Resolver serviceResolver = null;
        if (descriptor.template.length() > 0) {
            TemplateDescriptor templateDescriptor = (TemplateDescriptor)this._application.serviceTemplates.get(descriptor.template);
            if (!$assertionsDisabled && templateDescriptor == null) {
                throw new AssertionError();
            }
            serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
            if (!$assertionsDisabled && serviceDescriptor == null) {
                throw new AssertionError();
            }
            serviceResolver = new Utils.Resolver(this._resolver, descriptor.parameterValues, templateDescriptor.parameterDefaults);
            serviceName = serviceResolver.substitute(serviceDescriptor.name);
            serviceResolver.put("service", serviceName);
        } else {
            serviceDescriptor = descriptor.descriptor;
            if (!$assertionsDisabled && serviceDescriptor == null) {
                throw new AssertionError();
            }
            serviceResolver = new Utils.Resolver(this._resolver);
            serviceName = this._resolver.substitute(serviceDescriptor.name);
            serviceResolver.put("service", serviceName);
        }
        this._services.add(new Service(this, serviceName, serviceResolver, descriptor, serviceDescriptor));
    }

    private static String toolTip(ServerState state, int pid, boolean enabled) {
        String result;
        String string = result = state == null ? "Unknown" : state.toString();
        if (!enabled) {
            result = result + ", disabled";
        }
        if (pid != 0) {
            result = result + ", pid: " + pid;
        }
        return result;
    }

    static {
        $assertionsDisabled = !Server.class.desiredAssertionStatus();
    }
}

