/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocatorPrx;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.StringHolder;
import IceInternal.BasicStream;
import IceInternal.DirectReference;
import IceInternal.EndpointI;
import IceInternal.FixedReference;
import IceInternal.IndirectReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceUtil.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReferenceFactory {
    private Instance _instance;
    private Communicator _communicator;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;
    private WeakHashMap _references = new WeakHashMap();

    public synchronized Reference create(Identity ident, Map context, String facet, int mode, boolean secure, EndpointI[] endpoints, RouterInfo routerInfo, boolean collocationOptimization) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        DirectReference ref = new DirectReference(this._instance, this._communicator, ident, context, facet, mode, secure, endpoints, routerInfo, collocationOptimization);
        return this.updateCache(ref);
    }

    public synchronized Reference create(Identity ident, Map context, String facet, int mode, boolean secure, String adapterId, RouterInfo routerInfo, LocatorInfo locatorInfo, boolean collocationOptimization, int locatorCacheTimeout) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        IndirectReference ref = new IndirectReference(this._instance, this._communicator, ident, context, facet, mode, secure, adapterId, routerInfo, locatorInfo, collocationOptimization, locatorCacheTimeout);
        return this.updateCache(ref);
    }

    public synchronized Reference create(Identity ident, Map context, String facet, int mode, ConnectionI[] fixedConnections) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        FixedReference ref = new FixedReference(this._instance, this._communicator, ident, context, facet, mode, fixedConnections);
        return this.updateCache(ref);
    }

    public synchronized Reference copy(Reference r) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        Identity ident = r.getIdentity();
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        return (Reference)r.clone();
    }

    public Reference create(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String delim = " \t\n\r";
        int end = 0;
        int beg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
        if (beg == -1) {
            ProxyParseException e = new ProxyParseException();
            e.str = s;
            throw e;
        }
        String idstr = null;
        end = StringUtil.checkQuote(s, beg);
        if (end == -1) {
            ProxyParseException e = new ProxyParseException();
            e.str = s;
            throw e;
        }
        if (end == 0) {
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            idstr = s.substring(beg, end);
        } else {
            idstr = s.substring(++beg, end);
            ++end;
        }
        if (beg == end) {
            ProxyParseException e = new ProxyParseException();
            e.str = s;
            throw e;
        }
        Identity ident = this._instance.stringToIdentity(idstr);
        if (ident.name.length() == 0) {
            if (ident.category.length() > 0) {
                IllegalIdentityException e = new IllegalIdentityException();
                e.id = ident;
                throw e;
            }
            if (StringUtil.findFirstNotOf(s, " \t\n\r", end) != -1) {
                ProxyParseException e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            return null;
        }
        String facet = "";
        int mode = 0;
        boolean secure = false;
        String adapter = "";
        block9: while ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", end)) != -1 && s.charAt(beg) != ':' && s.charAt(beg) != '@') {
            char ch;
            end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
            if (end == -1) {
                end = s.length();
            }
            if (beg == end) break;
            String option = s.substring(beg, end);
            if (option.length() != 2 || option.charAt(0) != '-') {
                ProxyParseException e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            String argument = null;
            int argumentBeg = StringUtil.findFirstNotOf(s, " \t\n\r", end);
            if (argumentBeg != -1 && (ch = s.charAt(argumentBeg)) != '@' && ch != ':' && ch != '-') {
                beg = argumentBeg;
                end = StringUtil.checkQuote(s, beg);
                if (end == -1) {
                    ProxyParseException e = new ProxyParseException();
                    e.str = s;
                    throw e;
                }
                if (end == 0) {
                    end = StringUtil.findFirstOf(s, " \t\n\r:@", beg);
                    if (end == -1) {
                        end = s.length();
                    }
                    argument = s.substring(beg, end);
                } else {
                    argument = s.substring(++beg, end);
                    ++end;
                }
            }
            switch (option.charAt(1)) {
                case 'f': {
                    if (argument == null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    StringHolder facetH = new StringHolder();
                    if (!StringUtil.unescapeString(argument, 0, argument.length(), facetH)) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    facet = facetH.value;
                    continue block9;
                }
                case 't': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    mode = 0;
                    continue block9;
                }
                case 'o': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    mode = 1;
                    continue block9;
                }
                case 'O': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    mode = 2;
                    continue block9;
                }
                case 'd': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    mode = 3;
                    continue block9;
                }
                case 'D': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    mode = 4;
                    continue block9;
                }
                case 's': {
                    if (argument != null) {
                        ProxyParseException e = new ProxyParseException();
                        e.str = s;
                        throw e;
                    }
                    secure = true;
                    continue block9;
                }
            }
            ProxyParseException e = new ProxyParseException();
            e.str = s;
            throw e;
        }
        RouterInfo routerInfo = this._instance.routerManager().get(this.getDefaultRouter());
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this.getDefaultLocator());
        if (beg == -1) {
            return this.create(ident, this._instance.getDefaultContext(), facet, mode, secure, "", routerInfo, locatorInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization, this._instance.defaultsAndOverrides().defaultLocatorCacheTimeout);
        }
        ArrayList endpoints = new ArrayList();
        if (s.charAt(beg) == ':') {
            ArrayList<String> unknownEndpoints = new ArrayList<String>();
            end = beg;
            while (end < s.length() && s.charAt(end) == ':') {
                beg = end + 1;
                if ((end = s.indexOf(58, beg)) == -1) {
                    end = s.length();
                }
                String es = s.substring(beg, end);
                EndpointI endp = this._instance.endpointFactoryManager().create(es);
                if (endp != null) {
                    ArrayList endps = endp.expand(false);
                    endpoints.addAll(endps);
                    continue;
                }
                unknownEndpoints.add(es);
            }
            if (endpoints.size() == 0) {
                EndpointParseException e = new EndpointParseException();
                e.str = (String)unknownEndpoints.get(0);
                throw e;
            }
            if (unknownEndpoints.size() != 0 && this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Endpoints", 1) > 0) {
                String msg = "Proxy contains unknown endpoints:";
                Iterator iter = unknownEndpoints.iterator();
                while (iter.hasNext()) {
                    msg = msg + " `" + (String)iter.next() + "'";
                }
                this._instance.initializationData().logger.warning(msg);
            }
            EndpointI[] endp = new EndpointI[endpoints.size()];
            endpoints.toArray(endp);
            return this.create(ident, this._instance.getDefaultContext(), facet, mode, secure, endp, routerInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization);
        }
        if (s.charAt(beg) == '@') {
            StringHolder token;
            if ((beg = StringUtil.findFirstNotOf(s, " \t\n\r", beg + 1)) == -1) {
                ProxyParseException e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            end = StringUtil.checkQuote(s, beg);
            if (end == -1) {
                ProxyParseException e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            if (end == 0) {
                end = StringUtil.findFirstOf(s, " \t\n\r", beg);
                if (end == -1) {
                    end = s.length();
                }
            } else {
                ++beg;
            }
            if (!StringUtil.unescapeString(s, beg, end, token = new StringHolder()) || token.value.length() == 0) {
                ProxyParseException e = new ProxyParseException();
                e.str = s;
                throw e;
            }
            adapter = token.value;
            return this.create(ident, this._instance.getDefaultContext(), facet, mode, secure, adapter, routerInfo, locatorInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization, this._instance.defaultsAndOverrides().defaultLocatorCacheTimeout);
        }
        ProxyParseException ex = new ProxyParseException();
        ex.str = s;
        throw ex;
    }

    public Reference create(Identity ident, BasicStream s) {
        String facet;
        if (ident.name.length() == 0 && ident.category.length() == 0) {
            return null;
        }
        String[] facetPath = s.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new ProxyUnmarshalException();
            }
            facet = facetPath[0];
        } else {
            facet = "";
        }
        byte mode = s.readByte();
        if (mode < 0 || mode > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean secure = s.readBool();
        String adapterId = "";
        RouterInfo routerInfo = this._instance.routerManager().get(this.getDefaultRouter());
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this.getDefaultLocator());
        int sz = s.readSize();
        if (sz > 0) {
            EndpointI[] endpoints = new EndpointI[sz];
            for (int i = 0; i < sz; ++i) {
                endpoints[i] = this._instance.endpointFactoryManager().read(s);
            }
            return this.create(ident, this._instance.getDefaultContext(), facet, mode, secure, endpoints, routerInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization);
        }
        EndpointI[] endpoints = new EndpointI[]{};
        adapterId = s.readString();
        return this.create(ident, this._instance.getDefaultContext(), facet, mode, secure, adapterId, routerInfo, locatorInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization, this._instance.defaultsAndOverrides().defaultLocatorCacheTimeout);
    }

    public synchronized void setDefaultRouter(RouterPrx defaultRouter) {
        this._defaultRouter = defaultRouter;
    }

    public synchronized RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public synchronized void setDefaultLocator(LocatorPrx defaultLocator) {
        this._defaultLocator = defaultLocator;
    }

    public synchronized LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    synchronized void destroy() {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        this._instance = null;
        this._communicator = null;
        this._defaultRouter = null;
        this._defaultLocator = null;
        this._references.clear();
    }

    private Reference updateCache(Reference ref) {
        WeakReference w = (WeakReference)this._references.get(ref);
        if (w != null) {
            Reference r = (Reference)w.get();
            if (r != null) {
                ref = r;
            } else {
                this._references.put(ref, new WeakReference<Reference>(ref));
            }
        } else {
            this._references.put(ref, new WeakReference<Reference>(ref));
        }
        return ref;
    }
}

