/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;

public abstract class AbstractFormBuilder {
    private final Container container;
    private final FormLayout layout;
    private CellConstraints currentCellConstraints;
    private boolean leftToRight;

    public AbstractFormBuilder(FormLayout layout, Container container) {
        if (layout == null) {
            throw new NullPointerException("The layout must not be null.");
        }
        if (container == null) {
            throw new NullPointerException("The layout container must not be null.");
        }
        this.container = container;
        this.layout = layout;
        container.setLayout(layout);
        this.currentCellConstraints = new CellConstraints();
        ComponentOrientation orientation = container.getComponentOrientation();
        this.leftToRight = orientation.isLeftToRight() || !orientation.isHorizontal();
    }

    public final Container getContainer() {
        return this.container;
    }

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    public final void setColumn(int column) {
        this.currentCellConstraints.gridX = column;
    }

    public final int getRow() {
        return this.currentCellConstraints.gridY;
    }

    public final void setColumnSpan(int columnSpan) {
        this.currentCellConstraints.gridWidth = columnSpan;
    }

    public final void nextColumn() {
        this.nextColumn(1);
    }

    public final void nextColumn(int columns) {
        this.currentCellConstraints.gridX += columns * this.getColumnIncrementSign();
    }

    public final void nextRow(int rows) {
        this.currentCellConstraints.gridY += rows;
    }

    public final void nextLine() {
        this.nextLine(1);
    }

    public final void nextLine(int lines) {
        this.nextRow(lines);
        this.setColumn(this.getLeadingColumn());
    }

    public final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    public final void appendGlueColumn() {
        this.appendColumn(FormFactory.GLUE_COLSPEC);
    }

    public final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
    }

    public final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    public final Component add(Component component, CellConstraints cellConstraints) {
        this.container.add(component, cellConstraints);
        return component;
    }

    public final Component add(Component component) {
        this.add(component, this.currentCellConstraints);
        return component;
    }

    protected final CellConstraints cellConstraints() {
        return this.currentCellConstraints;
    }

    protected int getLeadingColumn() {
        return this.isLeftToRight() ? 1 : this.getColumnCount();
    }

    protected final int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }

    protected final CellConstraints createLeftAdjustedConstraints(int columnSpan) {
        int firstColumn = this.isLeftToRight() ? this.getColumn() : this.getColumn() + 1 - columnSpan;
        return new CellConstraints(firstColumn, this.getRow(), columnSpan, this.cellConstraints().gridHeight);
    }
}

