/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.StringSeqHolder;
import IceGridGUI.Coordinator;
import IceGridGUI.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main
extends JFrame {
    private Coordinator _coordinator;

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.createAndShowGUI(args);
            }
        });
    }

    Main(String[] args) {
        super("IceGrid Admin");
        ImageIcon icon = Utils.getIcon("/icons/16x16/grid.png");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (Main.this._coordinator != null) {
                    Main.this._coordinator.exit(0);
                }
            }
        });
        this._coordinator = new Coordinator(this, new StringSeqHolder(args), Preferences.userNodeForPackage(this.getClass()));
        this._coordinator.showMainFrame();
    }

    private static void createAndShowGUI(String[] args) {
        try {
            if (UIManager.getSystemLookAndFeelClassName().equals("apple.laf.AquaLookAndFeel")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
            } else {
                UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        new Main(args);
    }
}

